/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.texteditor.ui;

import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.ui.EMFEditUIPlugin;
import org.eclipse.emf.edit.ui.util.EditUIMarkerHelper;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.eventb.texteditor.ui.build.ast.IParseProblemWrapper;

public class MarkerHelper
extends EditUIMarkerHelper {
    private final String markerId;

    public MarkerHelper(String markerId) {
        this.markerId = markerId;
    }

    protected String getMarkerID() {
        return this.markerId;
    }

    protected boolean adjustMarker(IMarker marker, Diagnostic diagnostic) throws CoreException {
        if (diagnostic.getData() != null) {
            for (Object element : diagnostic.getData()) {
                if (!(element instanceof IParseProblemWrapper)) continue;
                IParseProblemWrapper parseProblem = (IParseProblemWrapper)element;
                int offset = parseProblem.getOffset();
                int line = parseProblem.getLine();
                int column = parseProblem.getColumn();
                Map attributes = marker.getAttributes();
                MarkerUtilities.setCharStart((Map)attributes, (int)offset);
                MarkerUtilities.setCharEnd((Map)attributes, (int)(offset + parseProblem.getTokenLength()));
                MarkerUtilities.setMessage((Map)attributes, (String)parseProblem.getMessage());
                MarkerUtilities.setLineNumber((Map)attributes, (int)line);
                attributes.put("location", EMFEditUIPlugin.getPlugin().getString("_UI_MarkerLocation", (Object[])new String[]{Integer.toString(line + 1), Integer.toString(column + 1)}));
                marker.setAttributes(attributes);
                return true;
            }
        }
        return super.adjustMarker(marker, diagnostic);
    }

    public void deleteMarkers(Resource resource, String markerType, boolean includeSubtypes, int depth) {
        IFile file = this.getFile(resource);
        try {
            file.deleteMarkers(markerType, includeSubtypes, depth);
        }
        catch (CoreException coreException) {}
    }
}

