/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.texteditor.ui.reconciler;

import java.util.ArrayList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.Token;
import org.eventb.texteditor.ui.TextDecoration;
import org.eventb.texteditor.ui.TextEditorPlugin;
import org.eventb.texteditor.ui.build.dom.DomManager;
import org.eventb.texteditor.ui.build.dom.IComponentDom;
import org.eventb.texteditor.ui.reconciler.IdentifierRule;
import org.eventb.texteditor.ui.reconciler.partitioning.KeywordDetector;
import org.eventb.texteditor.ui.reconciler.partitioning.WordPredicateRule;
import org.eventb.texttools.Constants;

public class SemanticTokenScanner
extends RuleBasedScanner {
    private final DomManager domManager = TextEditorPlugin.getDomManager();
    private final IdentifierRule identifierRule;
    private IComponentDom currentDom;
    private Resource resource;

    public SemanticTokenScanner() {
        this.setRules(this.getRules());
        this.identifierRule = new IdentifierRule();
    }

    private IRule[] getRules() {
        ArrayList<WordPredicateRule> rules = new ArrayList<WordPredicateRule>();
        WordPredicateRule structKWRule = new WordPredicateRule(new KeywordDetector());
        String[] stringArray = Constants.structural_keywords;
        int n = Constants.structural_keywords.length;
        int n2 = 0;
        while (n2 < n) {
            String keyword = stringArray[n2];
            structKWRule.addWord(keyword, (IToken)TextDecoration.ESyntaxElement.Keyword.getToken());
            ++n2;
        }
        rules.add(structKWRule);
        WordPredicateRule formulaKwRule = new WordPredicateRule(new KeywordDetector());
        String[] stringArray2 = Constants.formula_keywords;
        int n3 = Constants.formula_keywords.length;
        n = 0;
        while (n < n3) {
            String keyword = stringArray2[n];
            formulaKwRule.addWord(keyword, (IToken)TextDecoration.ESyntaxElement.MathKeyword.getToken());
            ++n;
        }
        rules.add(formulaKwRule);
        return rules.toArray(new IRule[rules.size()]);
    }

    public IToken nextToken() {
        int startOffset = this.fOffset;
        IToken nextToken = super.nextToken();
        if (this.acceptToken(nextToken)) {
            return nextToken;
        }
        this.fTokenOffset = startOffset;
        this.fOffset = startOffset;
        this.fColumn = -1;
        this.checkInit();
        this.identifierRule.setOffset(this.fOffset);
        IToken token = this.identifierRule.evaluate((ICharacterScanner)this);
        if (!token.isUndefined()) {
            return token;
        }
        if (this.read() == -1) {
            return Token.EOF;
        }
        return this.fDefaultReturnToken;
    }

    private boolean acceptToken(IToken nextToken) {
        int c = this.read();
        if (Character.isJavaIdentifierPart(c) || c == 39) {
            this.unread();
            return false;
        }
        return nextToken == TextDecoration.ESyntaxElement.Keyword.getToken() || nextToken == TextDecoration.ESyntaxElement.MathKeyword.getToken() || nextToken.isEOF();
    }

    public void setInputResource(Resource resource) {
        this.resource = resource;
        this.currentDom = null;
    }

    private void checkInit() {
        if (this.currentDom == null && this.resource != null) {
            this.currentDom = this.domManager.getDom(this.resource);
            this.identifierRule.setDom(this.currentDom);
        }
    }
}

