/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.texteditor.ui.preferences;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eventb.texteditor.ui.TextDecoration;
import org.eventb.texteditor.ui.TextEditorPlugin;

public class HighlightingPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private final List<Field> fields = new ArrayList<Field>();

    public HighlightingPreferencePage() {
        this.setPreferenceStore(TextEditorPlugin.getPlugin().getPreferenceStore());
        this.setDescription("Please configure the syntax highlighting for the Event-B TextEditor. You can select the color and the style for each element type.");
    }

    protected Control createContents(Composite parent) {
        Composite colorComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        colorComposite.setLayout((Layout)layout);
        TextDecoration.ESyntaxElement[] eSyntaxElementArray = TextDecoration.ESyntaxElement.values();
        int n = eSyntaxElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            TextDecoration.ESyntaxElement element = eSyntaxElementArray[n2];
            this.createField(element, colorComposite);
            ++n2;
        }
        this.loadPreferences();
        colorComposite.layout(false);
        return colorComposite;
    }

    private void savePreferences() {
        IPreferenceStore store = this.getPreferenceStore();
        for (Field f : this.fields) {
            TextDecoration.ESyntaxElement element = f.element;
            int bold = f.boldButton.getSelection() ? 1 : 0;
            int italic = f.italicButton.getSelection() ? 2 : 0;
            int underline = f.underlineButton.getSelection() ? 0x40000000 : 0;
            int style = bold | italic | underline;
            PreferenceConverter.setValue((IPreferenceStore)store, (String)element.getColorKey(), (RGB)f.colorSelector.getColorValue());
            store.setValue(element.getStyleKey(), style);
            element.resetToken();
        }
    }

    private void loadPreferences() {
        IPreferenceStore store = this.getPreferenceStore();
        for (Field f : this.fields) {
            TextDecoration.ESyntaxElement element = f.element;
            RGB color = PreferenceConverter.getColor((IPreferenceStore)store, (String)element.getColorKey());
            int style = store.getInt(element.getStyleKey());
            this.setFieldValues(f, color, style);
        }
    }

    private void loadDefaultPreferences() {
        IPreferenceStore store = this.getPreferenceStore();
        for (Field f : this.fields) {
            TextDecoration.ESyntaxElement element = f.element;
            RGB color = PreferenceConverter.getDefaultColor((IPreferenceStore)store, (String)element.getColorKey());
            int style = store.getDefaultInt(element.getStyleKey());
            this.setFieldValues(f, color, style);
        }
    }

    private void setFieldValues(Field f, RGB color, int style) {
        f.colorSelector.setColorValue(color);
        f.boldButton.setSelection((style & 1) == 1);
        f.italicButton.setSelection((style & 2) == 2);
        f.underlineButton.setSelection((style & 0x40000000) == 0x40000000);
    }

    private void createField(TextDecoration.ESyntaxElement element, Composite parent) {
        Composite field = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        GridLayout layout = new GridLayout(5, false);
        layout.marginWidth = 5;
        field.setLayout((Layout)layout);
        field.setLayoutData((Object)gridData);
        Label label = new Label(field, 0);
        label.setText(element.getLabel());
        label.setLayoutData((Object)gridData);
        ColorSelector colorSelector = new ColorSelector(field);
        Button boldButton = new Button(field, 32);
        boldButton.setText("Bold");
        Button italicButton = new Button(field, 32);
        italicButton.setText("Italic");
        Button underlineButton = new Button(field, 32);
        underlineButton.setText("Underline");
        this.fields.add(new Field(element, colorSelector, boldButton, italicButton, underlineButton));
    }

    public boolean performOk() {
        this.savePreferences();
        return true;
    }

    protected void performDefaults() {
        this.loadDefaultPreferences();
        super.performDefaults();
    }

    public void init(IWorkbench workbench) {
    }

    private class Field {
        protected final TextDecoration.ESyntaxElement element;
        protected final ColorSelector colorSelector;
        protected final Button boldButton;
        protected final Button italicButton;
        protected final Button underlineButton;

        protected Field(TextDecoration.ESyntaxElement element, ColorSelector colorSelector, Button boldButton, Button italicButton, Button underlineButton) {
            this.element = element;
            this.colorSelector = colorSelector;
            this.boldButton = boldButton;
            this.italicButton = italicButton;
            this.underlineButton = underlineButton;
        }
    }
}

