/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.texteditor.ui.editor;

import java.util.ResourceBundle;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;

public class TrimLinesAction
extends TextEditorAction {
    public TrimLinesAction(ResourceBundle bundle, String prefix, ITextEditor editor) {
        super(bundle, prefix, editor);
        this.update();
    }

    public void run() {
        ITextEditor editor = this.getTextEditor();
        if (editor == null) {
            return;
        }
        if (!this.validateEditorInputState()) {
            return;
        }
        IDocument document = TrimLinesAction.getDocument(editor);
        if (document == null) {
            return;
        }
        int startLine = 0;
        int endLine = document.getNumberOfLines() - 1;
        ITextSelection selection = TrimLinesAction.getSelection(editor);
        if (selection != null) {
            startLine = selection.getStartLine();
            endLine = selection.getEndLine();
        }
        try {
            TrimLinesAction.trimLines(document, startLine, endLine, (IProgressMonitor)SubMonitor.convert(null, (String)"Trimming lines", (int)1));
            if (selection != null) {
                int startOffset = document.getLineOffset(selection.getStartLine());
                editor.selectAndReveal(startOffset, 0);
            }
        }
        catch (BadLocationException badLocationException) {}
    }

    private static IDocument getDocument(ITextEditor editor) {
        IDocumentProvider documentProvider = editor.getDocumentProvider();
        if (documentProvider == null) {
            return null;
        }
        IDocument document = documentProvider.getDocument((Object)editor.getEditorInput());
        if (document == null) {
            return null;
        }
        return document;
    }

    private static ITextSelection getSelection(ITextEditor editor) {
        ISelectionProvider selectionProvider = editor.getSelectionProvider();
        if (selectionProvider == null) {
            return null;
        }
        ISelection selection = selectionProvider.getSelection();
        if (!(selection instanceof ITextSelection)) {
            return null;
        }
        return (ITextSelection)selection;
    }

    public void update() {
        super.update();
        if (!this.isEnabled()) {
            return;
        }
        if (!this.canModifyEditor()) {
            this.setEnabled(false);
            return;
        }
        ITextEditor editor = this.getTextEditor();
        this.setEnabled(editor.isEditable());
    }

    public static int trimLines(IDocument document, int startLine, int endLine, IProgressMonitor monitor) throws BadLocationException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
        if (startLine >= document.getNumberOfLines() || startLine > endLine) {
            return 0;
        }
        int removeChars = 0;
        StringBuffer buffer = new StringBuffer();
        subMonitor.setWorkRemaining(endLine - startLine + 1);
        int line = startLine;
        while (line <= endLine) {
            String trimmedLine = TrimLinesAction.trim(document, line);
            buffer.append(trimmedLine);
            removeChars += document.getLineLength(line) - trimmedLine.length();
            subMonitor.worked(1);
            ++line;
        }
        int startLineOffset = document.getLineOffset(startLine);
        int endLineOffset = document.getLineOffset(endLine) + document.getLineLength(endLine);
        String replaceString = buffer.toString();
        document.replace(startLineOffset, endLineOffset - startLineOffset, replaceString);
        subMonitor.worked(1);
        return removeChars;
    }

    private static String trim(IDocument document, int line) throws BadLocationException {
        int lineOffset = document.getLineOffset(line);
        int lineDelimiterLength = TrimLinesAction.getLineDelimiterLength(document, line);
        int lineLength = document.getLineLength(line) - lineDelimiterLength;
        while (lineLength > 0 && Character.isWhitespace(document.getChar(lineOffset + lineLength - 1))) {
            --lineLength;
        }
        String lineDelimiter = lineDelimiterLength > 0 ? document.getLineDelimiter(line) : "";
        return String.valueOf(document.get(lineOffset, lineLength)) + lineDelimiter;
    }

    private static int getLineDelimiterLength(IDocument document, int line) throws BadLocationException {
        String lineDelimiter = document.getLineDelimiter(line);
        return lineDelimiter != null ? lineDelimiter.length() : 0;
    }
}

