/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.texteditor.ui.build.dom;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eventb.emf.core.EventBObject;
import org.eventb.texteditor.ui.build.dom.IDom;
import org.eventb.texttools.TextPositionUtil;
import org.eventb.texttools.model.texttools.TextRange;

public abstract class AbstractDom
implements IDom {
    private final IDom.Type type;
    private final IDom parent;
    private final List<IDom> children = new LinkedList<IDom>();

    protected AbstractDom(IDom.Type type, IDom parent) {
        this.type = type;
        this.parent = parent;
    }

    @Override
    public IDom.Type getType() {
        return this.type;
    }

    @Override
    public IDom getParent() {
        return this.parent;
    }

    public synchronized void reset() {
        this.children.clear();
    }

    @Override
    public synchronized List<IDom> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    @Override
    public synchronized void addChild(IDom child) {
        this.children.add(child);
    }

    @Override
    public synchronized IDom getScopingDom(int offset) {
        if (!this.containsOffset(TextPositionUtil.getTextRange((EventBObject)this.getEventBElement()), offset)) {
            return null;
        }
        for (IDom child : this.children) {
            IDom scope = child.getScopingDom(offset);
            if (scope == null) continue;
            return scope;
        }
        return this;
    }

    @Override
    public Set<String> getIdentifiers() {
        HashSet<String> result = new HashSet<String>();
        if (this.parent != null) {
            result.addAll(this.parent.getIdentifiers());
        }
        result.addAll(this.doGetIdentifiers());
        return result;
    }

    @Override
    public IDom.IdentifierType getIdentifierType(String identifier) {
        IDom currentDom = this;
        IDom.IdentifierType type = null;
        while (currentDom != null && (type = currentDom.doGetIdentifierType(identifier)) == null) {
            currentDom = currentDom.getParent();
        }
        return type;
    }

    private boolean containsOffset(TextRange range, int offset) {
        return range != null && range.getOffset() <= offset && range.getOffset() + range.getLength() >= offset;
    }

    protected abstract Set<String> doGetIdentifiers();

    protected abstract IDom.IdentifierType doGetIdentifierType(String var1);
}

