/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.texteditor.ui.build.dom;

import org.eclipse.emf.ecore.resource.Resource;
import org.eventb.emf.core.EventBNamedCommentedComponentElement;
import org.eventb.texteditor.ui.build.dom.AbstractDom;
import org.eventb.texteditor.ui.build.dom.DomBuilder;
import org.eventb.texteditor.ui.build.dom.IComponentDom;
import org.eventb.texteditor.ui.build.dom.IDom;

public abstract class AbstractComponentDom
extends AbstractDom
implements IComponentDom {
    protected boolean initialized = false;
    private boolean initializing = false;
    private final Resource resource;

    protected AbstractComponentDom(IDom.Type type, IDom parent, Resource resource) {
        super(type, parent);
        this.resource = resource;
    }

    @Override
    public synchronized void reset() {
        if (this.initialized) {
            super.reset();
            this.doReset();
            this.initialized = false;
        }
    }

    @Override
    public synchronized void resetAndinit() {
        this.reset();
        this.init();
    }

    @Override
    public Resource getResource() {
        return this.resource;
    }

    protected void checkInitialization() {
        if (!this.isInitialized()) {
            this.init();
        }
    }

    private synchronized void init() {
        if (!this.initialized && !this.initializing) {
            this.initializing = true;
            this.doInitialize();
            this.initialized = true;
            this.initializing = false;
        }
    }

    private synchronized boolean isInitialized() {
        return this.initialized;
    }

    protected void doInitialize() {
        DomBuilder.initializeDOM(this, (EventBNamedCommentedComponentElement)this.getEventBElement(), this.resource);
    }

    protected abstract void doReset();
}

