/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.texteditor.ui.build.ast;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eventb.core.ast.ASTProblem;
import org.eventb.core.ast.SourceLocation;
import org.eventb.texteditor.ui.build.ast.IParseProblemWrapper;

public class FormulaExceptionWrapperDiagnostic
implements IParseProblemWrapper {
    final ASTProblem problem;
    private final IDocument document;
    private final int startOffset;

    public FormulaExceptionWrapperDiagnostic(ASTProblem problem, int formulaOffset, IDocument document) {
        this.problem = problem;
        this.startOffset = formulaOffset;
        this.document = document;
    }

    @Override
    public int getColumn() {
        try {
            int offset = this.getOffset();
            return offset - this.document.getLineOffset(this.document.getLineOfOffset(offset));
        }
        catch (BadLocationException badLocationException) {
            return 0;
        }
    }

    @Override
    public int getLine() {
        try {
            return this.document.getLineOfOffset(this.getOffset());
        }
        catch (BadLocationException badLocationException) {
            return 0;
        }
    }

    @Override
    public int getOffset() {
        return this.startOffset + this.problem.getSourceLocation().getStart();
    }

    @Override
    public int getTokenLength() {
        SourceLocation location = this.problem.getSourceLocation();
        return location.getEnd() - location.getStart();
    }

    @Override
    public String getToken() {
        try {
            return this.document.get(this.getOffset(), this.getTokenLength());
        }
        catch (BadLocationException badLocationException) {
            return "";
        }
    }

    @Override
    public String getMessage() {
        return String.format(this.problem.getMessage().toString(), this.problem.getArgs());
    }
}

