/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.texteditor.ui.build;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.text.IDocument;
import org.eventb.texteditor.ui.build.IBuildPhase;
import org.eventb.texteditor.ui.build.ast.AstBuilder;
import org.eventb.texteditor.ui.build.dom.DomBuilder;
import org.eventb.texteditor.ui.editor.EventBTextEditor;

public class Builder {
    private final List<IBuildPhase> buildPhases = new ArrayList<IBuildPhase>();
    private boolean successful;

    public Builder() {
        this.buildPhases.add(new AstBuilder());
        this.buildPhases.add(new DomBuilder());
    }

    public void run(EventBTextEditor editor, IDocument document, IProgressMonitor monitor) {
        Resource resource = editor.getResource();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)("Building '" + resource + "'..."), (int)this.buildPhases.size());
        this.successful = true;
        for (IBuildPhase phase : this.buildPhases) {
            if (subMonitor.isCanceled()) {
                return;
            }
            phase.run(editor, resource, document, (IProgressMonitor)subMonitor.newChild(1));
            if (!phase.canFail() || phase.wasSuccessful()) continue;
            this.successful = false;
            return;
        }
    }

    public boolean wasSuccessful() {
        return this.successful;
    }
}

