/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.texteditor.ui;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eventb.texteditor.ui.TextEditorPlugin;

public class TextDecoration {
    private static final IPreferenceStore store = TextEditorPlugin.getPlugin().getPreferenceStore();

    private static TextAttribute getAttribute(ESyntaxElement element) {
        RGB color = PreferenceConverter.getColor((IPreferenceStore)store, (String)element.getColorKey());
        int style = store.getInt(element.getStyleKey());
        TextAttribute attribute = new TextAttribute(new Color((Device)Display.getDefault(), color), null, style);
        return attribute;
    }

    public static enum ESyntaxElement {
        Comment("Comment"),
        Label("Label"),
        Keyword("Keyword"),
        MathKeyword("Mathematical Keyword"),
        GlobalVariable("Global Variable"),
        Parameter("Event Parameter"),
        BoundedVariable("Bound Variable"),
        Constant("Constant"),
        Set("Carrier Set");

        private final String label;
        private final String colorKey;
        private final String styleKey;
        private final Token token = new Token(null);

        private ESyntaxElement(String label) {
            this.label = label;
            this.colorKey = String.valueOf(this.toString()) + "." + "colorPreference";
            this.styleKey = String.valueOf(this.toString()) + "." + "stylePreference";
        }

        public String getLabel() {
            return this.label;
        }

        public String getColorKey() {
            return this.colorKey;
        }

        public String getStyleKey() {
            return this.styleKey;
        }

        public synchronized Token getToken() {
            if (this.token.getData() == null) {
                this.token.setData((Object)TextDecoration.getAttribute(this));
            }
            return this.token;
        }

        public synchronized void resetToken() {
            this.token.setData((Object)TextDecoration.getAttribute(this));
        }
    }
}

