/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.texteditor.ui.reconciler;

import java.util.Set;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eventb.texteditor.ui.TextEditorPlugin;
import org.eventb.texteditor.ui.build.dom.DomManager;
import org.eventb.texteditor.ui.build.dom.IComponentDom;
import org.eventb.texteditor.ui.build.dom.IDomChangeListener;
import org.eventb.texteditor.ui.reconciler.CommentTokenScanner;
import org.eventb.texteditor.ui.reconciler.LabelTokenScanner;
import org.eventb.texteditor.ui.reconciler.SemanticTokenScanner;

public class EventBPresentationReconciler
extends PresentationReconciler
implements IDomChangeListener {
    private static final DomManager domManager = TextEditorPlugin.getDomManager();
    private SemanticTokenScanner semanticScanner;
    private ITextViewer viewer;
    private IComponentDom dom = null;
    private Resource resource;

    public EventBPresentationReconciler() {
        this.init();
    }

    private void init() {
        this.semanticScanner = new SemanticTokenScanner();
        DefaultDamagerRepairer damager = new DefaultDamagerRepairer((ITokenScanner)this.semanticScanner);
        this.setDamager((IPresentationDamager)damager, "__dftl_partition_content_type");
        this.setRepairer((IPresentationRepairer)damager, "__dftl_partition_content_type");
        damager = new DefaultDamagerRepairer((ITokenScanner)new CommentTokenScanner());
        this.setDamager((IPresentationDamager)damager, "content_type_comment");
        this.setRepairer((IPresentationRepairer)damager, "content_type_comment");
        damager = new DefaultDamagerRepairer((ITokenScanner)new LabelTokenScanner());
        this.setDamager((IPresentationDamager)damager, "content_type_label");
        this.setRepairer((IPresentationRepairer)damager, "content_type_label");
    }

    public void reconcilePresentation() {
        if (this.viewer == null && this.viewer.getTextWidget() == null && this.viewer.getTextWidget().isDisposed()) {
            return;
        }
        this.viewer.getTextWidget().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                EventBPresentationReconciler.this.viewer.invalidateTextPresentation();
            }
        });
    }

    public void install(ITextViewer viewer) {
        super.install(viewer);
        this.viewer = viewer;
        domManager.addDomChangeListener(this);
    }

    public void uninstall() {
        domManager.removeDomChangeListener(this);
        super.uninstall();
        this.setInputResource(null);
    }

    public void setInputResource(Resource input) {
        this.resource = input;
        this.dom = input != null ? domManager.getDom(input) : null;
        this.semanticScanner.setInputResource(input);
    }

    @Override
    public void domChanged(IComponentDom changedDom) {
        Set<IComponentDom> referencedDoms;
        this.checkInit();
        if (changedDom == this.dom) {
            this.reconcilePresentation();
        } else if (this.dom != null && (referencedDoms = this.dom.getReferencedDoms(true)).contains(changedDom)) {
            this.reconcilePresentation();
        }
    }

    private void checkInit() {
        if (this.dom == null && this.resource != null) {
            this.dom = domManager.getDom(this.resource);
        }
    }
}

