/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.texteditor.ui.preferences;

import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eventb.texteditor.ui.TextDecoration;
import org.eventb.texteditor.ui.TextEditorPlugin;

public class PreferenceInitializer
extends AbstractPreferenceInitializer {
    private IPreferenceStore store;

    public void initializeDefaultPreferences() {
        this.store = TextEditorPlugin.getPlugin().getPreferenceStore();
        this.setDefaultValues(TextDecoration.ESyntaxElement.Comment, 15, 2);
        this.setDefaultValues(TextDecoration.ESyntaxElement.Label, 16, 0);
        this.setDefaultValues(TextDecoration.ESyntaxElement.Keyword, 4, 1);
        this.setDefaultValues(TextDecoration.ESyntaxElement.MathKeyword, 4, 0);
        this.setDefaultValues(TextDecoration.ESyntaxElement.GlobalVariable, 9, 0);
        this.setDefaultValues(TextDecoration.ESyntaxElement.BoundedVariable, 6, 2);
        this.setDefaultValues(TextDecoration.ESyntaxElement.Parameter, 9, 2);
        this.setDefaultValues(TextDecoration.ESyntaxElement.Constant, 9, 1);
        this.setDefaultValues(TextDecoration.ESyntaxElement.Set, 6, 1);
    }

    private void setDefaultValues(TextDecoration.ESyntaxElement element, int color, int style) {
        PreferenceConverter.setDefault((IPreferenceStore)this.store, (String)element.getColorKey(), (RGB)PreferenceInitializer.getRGB(color));
        this.store.setDefault(element.getStyleKey(), style);
    }

    private static RGB getRGB(int colorCode) {
        return Display.getDefault().getSystemColor(colorCode).getRGB();
    }
}

