/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.texteditor.ui.editor;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.MonoReconciler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;
import org.eventb.texteditor.ui.build.ReconcilingStrategy;
import org.eventb.texteditor.ui.editor.EventBTextEditor;
import org.eventb.texteditor.ui.editor.codecompletion.DefaultContentAssist;
import org.eventb.texteditor.ui.reconciler.EventBPresentationReconciler;
import org.eventb.texteditor.ui.reconciler.partitioning.PartitionScanner;

public class SourceViewerConfiguration
extends TextSourceViewerConfiguration {
    private final EventBTextEditor editor;
    private EventBPresentationReconciler presentationReconciler;

    public SourceViewerConfiguration(EventBTextEditor editor, IPreferenceStore preferenceStore) {
        super(preferenceStore);
        this.editor = editor;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        ContentAssistant assistant = new ContentAssistant();
        DefaultContentAssist processor = new DefaultContentAssist(this.editor);
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__dftl_partition_content_type");
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "content_type_structural_keyword");
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "content_type_formula_keyword");
        assistant.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
        assistant.enableAutoActivation(true);
        assistant.setAutoActivationDelay(500);
        return assistant;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        if (this.presentationReconciler == null) {
            this.presentationReconciler = new EventBPresentationReconciler();
            this.presentationReconciler.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        }
        return this.presentationReconciler;
    }

    public final IReconciler getReconciler(ISourceViewer sourceViewer) {
        ReconcilingStrategy reconcileStrategy = new ReconcilingStrategy(this.editor);
        MonoReconciler reconciler = new MonoReconciler((IReconcilingStrategy)reconcileStrategy, false);
        reconciler.setIsAllowedToModifyDocument(true);
        reconciler.setProgressMonitor((IProgressMonitor)new NullProgressMonitor());
        reconciler.setDelay(500);
        return reconciler;
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return PartitionScanner.CONTENT_TYPES;
    }
}

