/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.texteditor.ui.build.dom;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorInput;
import org.eventb.emf.core.EventBNamedCommentedComponentElement;
import org.eventb.emf.core.context.Context;
import org.eventb.emf.core.machine.Machine;
import org.eventb.texteditor.ui.TextEditorPlugin;
import org.eventb.texteditor.ui.build.IBuildPhase;
import org.eventb.texteditor.ui.build.dom.CollectingHelper;
import org.eventb.texteditor.ui.build.dom.ContextCollectingSwitch;
import org.eventb.texteditor.ui.build.dom.ContextDom;
import org.eventb.texteditor.ui.build.dom.DomManager;
import org.eventb.texteditor.ui.build.dom.FormulaCollectingSwitch;
import org.eventb.texteditor.ui.build.dom.IComponentDom;
import org.eventb.texteditor.ui.build.dom.MachineCollectingSwitch;
import org.eventb.texteditor.ui.build.dom.MachineDom;
import org.eventb.texteditor.ui.editor.EventBTextEditor;

public class DomBuilder
implements IBuildPhase {
    @Override
    public boolean isUIPhase() {
        return false;
    }

    @Override
    public boolean canFail() {
        return false;
    }

    @Override
    public boolean wasSuccessful() {
        return true;
    }

    @Override
    public void run(EventBTextEditor editor, Resource resource, IDocument document, IProgressMonitor monitor) {
        IEditorInput editorInput;
        DomManager domManager = TextEditorPlugin.getDomManager();
        DomManager.ParseResult parseResult = domManager.getLastParseResult(editorInput = editor.getEditorInput());
        if (parseResult != null) {
            EventBNamedCommentedComponentElement astRoot = (EventBNamedCommentedComponentElement)parseResult.astRoot;
            IComponentDom dom = domManager.getDom(resource, astRoot);
            if (astRoot instanceof Machine) {
                ((MachineDom)dom).setMachine((Machine)astRoot);
            } else if (astRoot instanceof Context) {
                ((ContextDom)dom).setContext((Context)astRoot);
            }
            dom.resetAndinit();
        }
    }

    public static IComponentDom getReferencedDom(EventBNamedCommentedComponentElement component, Resource referencingResource) {
        Resource resource = CollectingHelper.resolveComponentsResource(component, referencingResource);
        if (resource != null) {
            return TextEditorPlugin.getDomManager().getDom(resource, component);
        }
        return null;
    }

    public static void initializeDOM(IComponentDom dom, EventBNamedCommentedComponentElement component, Resource resource) {
        if (component instanceof Machine) {
            DomBuilder.initializeDOM((MachineDom)dom, (Machine)component, resource);
        } else if (component instanceof Context) {
            DomBuilder.initializeDOM((ContextDom)dom, (Context)component, resource);
        }
        TextEditorPlugin.getDomManager().notifyDomChangeListeners(dom);
    }

    private static void initializeDOM(MachineDom dom, Machine component, Resource resource) {
        dom.reset();
        MachineCollectingSwitch machineSwitch = new MachineCollectingSwitch(dom, resource);
        machineSwitch.doSwitch((EObject)component);
        FormulaCollectingSwitch formulaSwitch = new FormulaCollectingSwitch();
        TreeIterator<EObject> iterator = DomBuilder.getContentIterator((EventBNamedCommentedComponentElement)component, resource);
        while (iterator.hasNext()) {
            EObject next = (EObject)iterator.next();
            String nsURI = next.eClass().getEPackage().getNsURI();
            Boolean visitChildren = true;
            if ("http://emf.eventb.org/models/core/machine/2014".equals(nsURI)) {
                visitChildren = (Boolean)machineSwitch.doSwitch(next);
            } else if ("http://emf.eventb.org/models/core/formulas".equals(nsURI)) {
                formulaSwitch.setCurrentParentDom(machineSwitch.getCurrentParentDom());
                formulaSwitch.doSwitch(next);
            }
            if (visitChildren.booleanValue()) continue;
            iterator.prune();
        }
    }

    private static void initializeDOM(ContextDom dom, Context component, Resource resource) {
        dom.reset();
        ContextCollectingSwitch contextSwitch = new ContextCollectingSwitch(dom, resource);
        contextSwitch.doSwitch((EObject)component);
        FormulaCollectingSwitch formulaSwitch = new FormulaCollectingSwitch();
        TreeIterator<EObject> iterator = DomBuilder.getContentIterator((EventBNamedCommentedComponentElement)component, resource);
        while (iterator.hasNext()) {
            EObject next = (EObject)iterator.next();
            String nsURI = next.eClass().getEPackage().getNsURI();
            Boolean visitChildren = true;
            if ("http://emf.eventb.org/models/core/context/2014".equals(nsURI)) {
                visitChildren = (Boolean)contextSwitch.doSwitch(next);
            } else if ("http://emf.eventb.org/models/core/formulas".equals(nsURI)) {
                formulaSwitch.setCurrentParentDom(contextSwitch.getCurrentParentDom());
                formulaSwitch.doSwitch(next);
            }
            if (visitChildren.booleanValue()) continue;
            iterator.prune();
        }
    }

    private static TreeIterator<EObject> getContentIterator(EventBNamedCommentedComponentElement component, Resource resource) {
        if (component.eIsProxy()) {
            return EcoreUtil.getAllContents((Resource)resource, (boolean)true);
        }
        return EcoreUtil.getAllContents((EObject)component, (boolean)false);
    }
}

