/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.texteditor.ui.build.dom;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.resource.Resource;
import org.eventb.emf.core.EventBObject;
import org.eventb.emf.core.context.CarrierSet;
import org.eventb.emf.core.context.Constant;
import org.eventb.emf.core.context.Context;
import org.eventb.texteditor.ui.build.dom.AbstractComponentDom;
import org.eventb.texteditor.ui.build.dom.IComponentDom;
import org.eventb.texteditor.ui.build.dom.IDom;

public class ContextDom
extends AbstractComponentDom {
    private Context context;
    private final Map<String, Constant> constants = new HashMap<String, Constant>();
    private final Map<String, CarrierSet> sets = new HashMap<String, CarrierSet>();
    private final List<ContextDom> extendedContexts = new LinkedList<ContextDom>();

    ContextDom(Resource resource, Context context) {
        super(IDom.Type.Context, null, resource);
        this.context = context;
    }

    @Override
    protected synchronized void doReset() {
        this.constants.clear();
        this.sets.clear();
        this.extendedContexts.clear();
    }

    @Override
    protected synchronized Set<String> doGetIdentifiers() {
        HashSet<String> result = new HashSet<String>();
        result.addAll(this.getConstants(true).keySet());
        result.addAll(this.getSets(true).keySet());
        return result;
    }

    @Override
    protected synchronized IDom.IdentifierType doGetIdentifierType(String identifier) {
        if (this.getConstants(true).containsKey(identifier)) {
            return IDom.IdentifierType.Constant;
        }
        if (this.getSets(true).containsKey(identifier)) {
            return IDom.IdentifierType.Set;
        }
        return null;
    }

    @Override
    public Set<IComponentDom> getReferencedDoms(boolean transitive) {
        List<ContextDom> contexts = this.getExtendedContexts();
        HashSet<IComponentDom> result = new HashSet<IComponentDom>(contexts);
        if (transitive) {
            for (IComponentDom iComponentDom : contexts) {
                result.addAll(iComponentDom.getReferencedDoms(true));
            }
        }
        return result;
    }

    public synchronized List<ContextDom> getExtendedContexts() {
        this.checkInitialization();
        return this.extendedContexts;
    }

    public synchronized Map<String, Constant> getConstants(boolean includeInherited) {
        this.checkInitialization();
        HashMap<String, Constant> result = new HashMap<String, Constant>();
        if (includeInherited) {
            for (ContextDom dom : this.getExtendedContexts()) {
                result.putAll(dom.getConstants(includeInherited));
            }
        }
        result.putAll(this.constants);
        return result;
    }

    public synchronized Map<String, CarrierSet> getSets(boolean includeInherited) {
        this.checkInitialization();
        HashMap<String, CarrierSet> result = new HashMap<String, CarrierSet>();
        if (includeInherited) {
            for (ContextDom dom : this.getExtendedContexts()) {
                result.putAll(dom.getSets(includeInherited));
            }
        }
        result.putAll(this.sets);
        return result;
    }

    synchronized void addExtendedContext(ContextDom dom) {
        this.extendedContexts.add(dom);
    }

    synchronized void addConstant(Constant constant) {
        this.constants.put(constant.getName(), constant);
    }

    synchronized void addSet(CarrierSet set) {
        this.sets.put(set.getName(), set);
    }

    @Override
    public synchronized EventBObject getEventBElement() {
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
    }
}

