/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.texteditor.ui.build;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eventb.texteditor.ui.build.Builder;
import org.eventb.texteditor.ui.editor.EventBTextEditor;

public class ReconcilingStrategy
implements IReconcilingStrategy,
IReconcilingStrategyExtension {
    private IDocument document;
    private IProgressMonitor monitor;
    private final EventBTextEditor editor;

    public ReconcilingStrategy(EventBTextEditor editor) {
        this.editor = editor;
    }

    public void initialReconcile() {
        this.monitor.beginTask("Reconciling '" + this.editor.getEditorInput().getName() + "'", 3);
        if (this.document != null && !this.editor.isSaving() && !this.editor.isInLinkedMode()) {
            new Builder().run(this.editor, this.document, this.monitor);
        }
        this.monitor.done();
    }

    public void reconcile(IRegion partition) {
        this.initialReconcile();
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        this.initialReconcile();
    }

    public void setDocument(IDocument document) {
        this.document = document;
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        this.monitor = monitor != null ? monitor : new NullProgressMonitor();
    }
}

