/* The following code was generated by JFlex 1.4.1 on 10.03.20 14:04 */

// Alloy Analyzer 4 -- Copyright (c) 2006-2008, Felix Chang
//
// Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files
// (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify,
// merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
// OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
// LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

package edu.mit.csail.sdg.parser;

import edu.mit.csail.sdg.alloy4.Err;
import edu.mit.csail.sdg.alloy4.ErrorSyntax;
import edu.mit.csail.sdg.alloy4.Pos;
import edu.mit.csail.sdg.alloy4.Version;
import edu.mit.csail.sdg.ast.ExprConstant;
import edu.mit.csail.sdg.ast.ExprVar;
import java.util.List;
import java_cup.runtime.*;

/** Autogenerated by JFlex 1.4.1 */


public final class CompLexer implements java_cup.runtime.Scanner {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int YYINITIAL = 0;

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\75\1\77\1\64\1\0\1\77\1\76\16\75\4\0\1\77\1\1"+
    "\1\62\1\2\1\74\1\0\1\3\1\65\1\4\1\5\1\6\1\7"+
    "\1\10\1\11\1\13\1\14\1\66\1\71\10\72\1\15\1\0\1\16"+
    "\1\17\1\12\1\0\1\20\6\70\2\74\1\56\11\74\1\61\7\74"+
    "\1\21\1\63\1\22\1\23\1\67\1\0\1\30\1\31\1\35\1\40"+
    "\1\41\1\55\1\60\1\43\1\45\1\46\1\44\1\36\1\50\1\37"+
    "\1\47\1\54\1\57\1\34\1\32\1\33\1\42\1\53\1\74\1\51"+
    "\1\52\1\74\1\24\1\25\1\26\1\27\41\75\2\0\4\73\4\0"+
    "\1\73\2\0\1\75\7\0\1\73\4\0\1\73\5\0\27\73\1\0"+
    "\37\73\1\0\u01ca\73\4\0\14\73\16\0\5\73\7\0\1\73\1\0"+
    "\1\73\21\0\160\75\5\73\1\0\2\73\2\0\4\73\10\0\1\73"+
    "\1\0\3\73\1\0\1\73\1\0\24\73\1\0\123\73\1\0\213\73"+
    "\1\0\5\75\2\0\236\73\11\0\46\73\2\0\1\73\7\0\47\73"+
    "\7\0\1\73\1\0\55\75\1\0\1\75\1\0\2\75\1\0\2\75"+
    "\1\0\1\75\10\0\33\73\5\0\3\73\15\0\5\75\6\0\1\73"+
    "\4\0\13\75\5\0\53\73\37\75\4\0\2\73\1\75\143\73\1\0"+
    "\1\73\10\75\1\0\6\75\2\73\2\75\1\0\4\75\2\73\12\75"+
    "\3\73\2\0\1\73\17\0\1\75\1\73\1\75\36\73\33\75\2\0"+
    "\131\73\13\75\1\73\16\0\12\75\41\73\11\75\2\73\4\0\1\73"+
    "\5\0\26\73\4\75\1\73\11\75\1\73\3\75\1\73\5\75\22\0"+
    "\31\73\3\75\104\0\1\73\1\0\13\73\67\0\33\75\1\0\4\75"+
    "\66\73\3\75\1\73\22\75\1\73\7\75\12\73\2\75\2\0\12\75"+
    "\1\0\7\73\1\0\7\73\1\0\3\75\1\0\10\73\2\0\2\73"+
    "\2\0\26\73\1\0\7\73\1\0\1\73\3\0\4\73\2\0\1\75"+
    "\1\73\7\75\2\0\2\75\2\0\3\75\1\73\10\0\1\75\4\0"+
    "\2\73\1\0\3\73\2\75\2\0\12\75\4\73\7\0\1\73\5\0"+
    "\3\75\1\0\6\73\4\0\2\73\2\0\26\73\1\0\7\73\1\0"+
    "\2\73\1\0\2\73\1\0\2\73\2\0\1\75\1\0\5\75\4\0"+
    "\2\75\2\0\3\75\3\0\1\75\7\0\4\73\1\0\1\73\7\0"+
    "\14\75\3\73\1\75\13\0\3\75\1\0\11\73\1\0\3\73\1\0"+
    "\26\73\1\0\7\73\1\0\2\73\1\0\5\73\2\0\1\75\1\73"+
    "\10\75\1\0\3\75\1\0\3\75\2\0\1\73\17\0\2\73\2\75"+
    "\2\0\12\75\1\0\1\73\17\0\3\75\1\0\10\73\2\0\2\73"+
    "\2\0\26\73\1\0\7\73\1\0\2\73\1\0\5\73\2\0\1\75"+
    "\1\73\7\75\2\0\2\75\2\0\3\75\10\0\2\75\4\0\2\73"+
    "\1\0\3\73\2\75\2\0\12\75\1\0\1\73\20\0\1\75\1\73"+
    "\1\0\6\73\3\0\3\73\1\0\4\73\3\0\2\73\1\0\1\73"+
    "\1\0\2\73\3\0\2\73\3\0\3\73\3\0\14\73\4\0\5\75"+
    "\3\0\3\75\1\0\4\75\2\0\1\73\6\0\1\75\16\0\12\75"+
    "\11\0\1\73\7\0\3\75\1\0\10\73\1\0\3\73\1\0\27\73"+
    "\1\0\12\73\1\0\5\73\3\0\1\73\7\75\1\0\3\75\1\0"+
    "\4\75\7\0\2\75\1\0\2\73\6\0\2\73\2\75\2\0\12\75"+
    "\22\0\2\75\1\0\10\73\1\0\3\73\1\0\27\73\1\0\12\73"+
    "\1\0\5\73\2\0\1\75\1\73\7\75\1\0\3\75\1\0\4\75"+
    "\7\0\2\75\7\0\1\73\1\0\2\73\2\75\2\0\12\75\1\0"+
    "\2\73\17\0\2\75\1\0\10\73\1\0\3\73\1\0\51\73\2\0"+
    "\1\73\7\75\1\0\3\75\1\0\4\75\1\73\10\0\1\75\10\0"+
    "\2\73\2\75\2\0\12\75\12\0\6\73\2\0\2\75\1\0\22\73"+
    "\3\0\30\73\1\0\11\73\1\0\1\73\2\0\7\73\3\0\1\75"+
    "\4\0\6\75\1\0\1\75\1\0\10\75\22\0\2\75\15\0\60\73"+
    "\1\75\2\73\7\75\4\0\10\73\10\75\1\0\12\75\47\0\2\73"+
    "\1\0\1\73\2\0\2\73\1\0\1\73\2\0\1\73\6\0\4\73"+
    "\1\0\7\73\1\0\3\73\1\0\1\73\1\0\1\73\2\0\2\73"+
    "\1\0\4\73\1\75\2\73\6\75\1\0\2\75\1\73\2\0\5\73"+
    "\1\0\1\73\1\0\6\75\2\0\12\75\2\0\4\73\40\0\1\73"+
    "\27\0\2\75\6\0\12\75\13\0\1\75\1\0\1\75\1\0\1\75"+
    "\4\0\2\75\10\73\1\0\44\73\4\0\24\75\1\0\2\75\5\73"+
    "\13\75\1\0\44\75\11\0\1\75\71\0\53\73\24\75\1\73\12\75"+
    "\6\0\6\73\4\75\4\73\3\75\1\73\3\75\2\73\7\75\3\73"+
    "\4\75\15\73\14\75\1\73\17\75\2\0\46\73\1\0\1\73\5\0"+
    "\1\73\2\0\53\73\1\0\u014d\73\1\0\4\73\2\0\7\73\1\0"+
    "\1\73\1\0\4\73\2\0\51\73\1\0\4\73\2\0\41\73\1\0"+
    "\4\73\2\0\7\73\1\0\1\73\1\0\4\73\2\0\17\73\1\0"+
    "\71\73\1\0\4\73\2\0\103\73\2\0\3\75\40\0\20\73\20\0"+
    "\125\73\14\0\u026c\73\2\0\21\73\1\0\32\73\5\0\113\73\3\0"+
    "\3\73\17\0\15\73\1\0\4\73\3\75\13\0\22\73\3\75\13\0"+
    "\22\73\2\75\14\0\15\73\1\0\3\73\1\0\2\75\14\0\64\73"+
    "\40\75\3\0\1\73\3\0\2\73\1\75\2\0\12\75\41\0\3\75"+
    "\2\0\12\75\6\0\130\73\10\0\51\73\1\75\1\73\5\0\106\73"+
    "\12\0\35\73\3\0\14\75\4\0\14\75\12\0\12\75\36\73\2\0"+
    "\5\73\13\0\54\73\4\0\21\75\7\73\2\75\6\0\12\75\46\0"+
    "\27\73\5\75\4\0\65\73\12\75\1\0\35\75\2\0\13\75\6\0"+
    "\12\75\15\0\1\73\130\0\5\75\57\73\21\75\7\73\4\0\12\75"+
    "\21\0\11\75\14\0\3\75\36\73\15\75\2\73\12\75\54\73\16\75"+
    "\14\0\44\73\24\75\10\0\12\75\3\0\3\73\12\75\44\73\122\0"+
    "\3\75\1\0\25\75\4\73\1\75\4\73\3\75\2\73\11\0\300\73"+
    "\47\75\25\0\4\75\u0116\73\2\0\6\73\2\0\46\73\2\0\6\73"+
    "\2\0\10\73\1\0\1\73\1\0\1\73\1\0\1\73\1\0\37\73"+
    "\2\0\65\73\1\0\7\73\1\0\1\73\3\0\3\73\1\0\7\73"+
    "\3\0\4\73\2\0\6\73\4\0\15\73\5\0\3\73\1\0\7\73"+
    "\16\0\5\75\32\0\5\75\20\0\2\73\23\0\1\73\13\0\5\75"+
    "\5\0\6\75\1\0\1\73\15\0\1\73\20\0\15\73\3\0\33\73"+
    "\25\0\15\75\4\0\1\75\3\0\14\75\21\0\1\73\4\0\1\73"+
    "\2\0\12\73\1\0\1\73\3\0\5\73\6\0\1\73\1\0\1\73"+
    "\1\0\1\73\1\0\4\73\1\0\13\73\2\0\4\73\5\0\5\73"+
    "\4\0\1\73\21\0\51\73\u0a77\0\57\73\1\0\57\73\1\0\205\73"+
    "\6\0\4\73\3\75\2\73\14\0\46\73\1\0\1\73\5\0\1\73"+
    "\2\0\70\73\7\0\1\73\17\0\1\75\27\73\11\0\7\73\1\0"+
    "\7\73\1\0\7\73\1\0\7\73\1\0\7\73\1\0\7\73\1\0"+
    "\7\73\1\0\7\73\1\0\40\75\57\0\1\73\u01d5\0\3\73\31\0"+
    "\11\73\6\75\1\0\5\73\2\0\5\73\4\0\126\73\2\0\2\75"+
    "\2\0\3\73\1\0\132\73\1\0\4\73\5\0\51\73\3\0\136\73"+
    "\21\0\33\73\65\0\20\73\u0200\0\u19b6\73\112\0\u51cd\73\63\0\u048d\73"+
    "\103\0\56\73\2\0\u010d\73\3\0\20\73\12\75\2\73\24\0\57\73"+
    "\1\75\4\0\12\75\1\0\31\73\7\0\1\75\120\73\2\75\45\0"+
    "\11\73\2\0\147\73\2\0\4\73\1\0\4\73\14\0\13\73\115\0"+
    "\12\73\1\75\3\73\1\75\4\73\1\75\27\73\5\75\20\0\1\73"+
    "\7\0\64\73\14\0\2\75\62\73\21\75\13\0\12\75\6\0\22\75"+
    "\6\73\3\0\1\73\4\0\12\75\34\73\10\75\2\0\27\73\15\75"+
    "\14\0\35\73\3\0\4\75\57\73\16\75\16\0\1\73\12\75\46\0"+
    "\51\73\16\75\11\0\3\73\1\75\10\73\2\75\2\0\12\75\6\0"+
    "\27\73\3\0\1\73\1\75\4\0\60\73\1\75\1\73\3\75\2\73"+
    "\2\75\5\73\2\75\1\73\1\75\1\73\30\0\3\73\2\0\13\73"+
    "\5\75\2\0\3\73\2\75\12\0\6\73\2\0\6\73\2\0\6\73"+
    "\11\0\7\73\1\0\7\73\221\0\43\73\10\75\1\0\2\75\2\0"+
    "\12\75\6\0\u2ba4\73\14\0\27\73\4\0\61\73\u2104\0\u016e\73\2\0"+
    "\152\73\46\0\7\73\14\0\5\73\5\0\1\73\1\75\12\73\1\0"+
    "\15\73\1\0\5\73\1\0\1\73\1\0\2\73\1\0\2\73\1\0"+
    "\154\73\41\0\u016b\73\22\0\100\73\2\0\66\73\50\0\15\73\3\0"+
    "\20\75\20\0\7\75\14\0\2\73\30\0\3\73\31\0\1\73\6\0"+
    "\5\73\1\0\207\73\2\0\1\75\4\0\1\73\13\0\12\75\7\0"+
    "\32\73\4\0\1\73\1\0\32\73\13\0\131\73\3\0\6\73\2\0"+
    "\6\73\2\0\6\73\2\0\3\73\3\0\2\73\3\0\2\73\22\0"+
    "\3\75\4\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\1\0\1\1\1\2\1\3\1\4\1\5\1\6\1\7"+
    "\1\10\1\11\1\12\1\13\1\14\1\15\1\16\1\17"+
    "\1\20\1\21\1\22\1\23\1\24\1\25\1\26\1\27"+
    "\1\30\23\31\1\32\1\33\2\34\1\35\1\36\1\33"+
    "\1\37\1\40\1\41\1\0\1\42\1\43\1\44\1\45"+
    "\1\46\1\45\1\47\1\31\1\50\14\31\1\51\5\31"+
    "\1\52\3\31\1\47\12\31\1\53\1\0\3\54\1\55"+
    "\2\0\1\56\2\31\1\57\1\35\1\60\1\61\1\62"+
    "\1\63\1\64\2\31\1\65\1\31\1\66\1\31\1\2"+
    "\6\31\1\67\2\31\1\70\2\31\1\56\1\71\6\31"+
    "\1\72\1\73\1\74\1\31\1\75\1\76\1\54\1\77"+
    "\1\0\1\33\2\31\1\100\1\101\1\31\1\102\1\103"+
    "\1\104\1\105\1\106\4\31\1\107\1\110\1\31\1\111"+
    "\1\31\1\112\1\113\1\31\1\114\3\31\1\115\13\31"+
    "\1\116\4\31\1\117\1\31\1\120\2\31\1\121\2\31"+
    "\1\122\1\123\1\31\1\46\1\31\1\124\1\125\1\104"+
    "\3\31\1\112\1\67";

  private static int [] zzUnpackAction() {
    int [] result = new int[216];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\100\0\100\0\100\0\200\0\100\0\100\0\100"+
    "\0\300\0\100\0\u0100\0\u0140\0\100\0\u0180\0\u01c0\0\u0200"+
    "\0\u0240\0\100\0\100\0\100\0\100\0\100\0\u0280\0\100"+
    "\0\100\0\u02c0\0\u0300\0\u0340\0\u0380\0\u03c0\0\u0400\0\u0440"+
    "\0\u0480\0\u04c0\0\u0500\0\u0540\0\u0580\0\u05c0\0\u0600\0\u0640"+
    "\0\u0680\0\u06c0\0\u0700\0\u0740\0\u0780\0\100\0\u07c0\0\u0800"+
    "\0\100\0\100\0\u0840\0\100\0\u0880\0\100\0\u08c0\0\100"+
    "\0\100\0\100\0\u0900\0\100\0\100\0\100\0\u0940\0\u0980"+
    "\0\u09c0\0\u0a00\0\u0a40\0\u0a80\0\u0ac0\0\u0b00\0\u0b40\0\u0b80"+
    "\0\u0bc0\0\u0c00\0\u0c40\0\u0c80\0\u0cc0\0\u0d00\0\u0d40\0\u0d80"+
    "\0\u0dc0\0\u0e00\0\u0e40\0\u0e80\0\u0ec0\0\u0f00\0\u0580\0\u0f40"+
    "\0\u0f80\0\u0fc0\0\u1000\0\u1040\0\u1080\0\u10c0\0\u1100\0\u1140"+
    "\0\u1180\0\u11c0\0\u1200\0\u1240\0\u1280\0\u12c0\0\100\0\u1300"+
    "\0\u1340\0\100\0\u1380\0\u13c0\0\u0580\0\u0580\0\u0580\0\u0580"+
    "\0\u0580\0\u0580\0\u0580\0\u1400\0\u1440\0\u0580\0\u1480\0\u0580"+
    "\0\u14c0\0\u0580\0\u1500\0\u1540\0\u1580\0\u15c0\0\u1600\0\u1640"+
    "\0\u1680\0\u16c0\0\u1700\0\u0580\0\u1740\0\u1780\0\u0580\0\u0580"+
    "\0\u17c0\0\u1800\0\u1840\0\u1880\0\u18c0\0\u1900\0\u0580\0\u0580"+
    "\0\u0580\0\u1940\0\u11c0\0\u1280\0\u1980\0\u12c0\0\u19c0\0\u1300"+
    "\0\u1a00\0\u1a40\0\u0580\0\u0580\0\u1a80\0\u0580\0\u0580\0\u1ac0"+
    "\0\u0580\0\u0580\0\u1b00\0\u1b40\0\u1b80\0\u1bc0\0\u0580\0\u0580"+
    "\0\u1c00\0\u0580\0\u1c40\0\u1c80\0\u0580\0\u1cc0\0\u0580\0\u1d00"+
    "\0\u1d40\0\u1d80\0\u0580\0\u1dc0\0\u1e00\0\u1e40\0\u1e80\0\u1ec0"+
    "\0\u1f00\0\u1f40\0\u1f80\0\u1fc0\0\u2000\0\u2040\0\u0580\0\u2080"+
    "\0\u20c0\0\u2100\0\u2140\0\u0580\0\u2180\0\u0580\0\u21c0\0\u2200"+
    "\0\u0580\0\u2240\0\u2280\0\u0580\0\u0580\0\u22c0\0\u0580\0\u2300"+
    "\0\u0580\0\u0580\0\u0580\0\u2340\0\u2380\0\u23c0\0\u0580\0\u0580";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[216];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\2\1\3\1\4\1\5\1\6\1\7\1\10\1\11"+
    "\1\12\1\13\1\14\1\15\1\16\1\17\1\20\1\21"+
    "\1\22\1\23\1\24\1\25\1\26\1\27\1\30\1\31"+
    "\1\32\1\33\1\34\1\35\1\36\1\37\1\40\1\41"+
    "\1\42\1\43\1\44\2\45\1\46\1\45\1\47\1\50"+
    "\3\45\1\51\1\52\1\53\2\45\1\54\1\55\1\2"+
    "\1\56\1\2\1\57\2\45\2\60\2\45\1\2\2\56"+
    "\103\0\1\61\103\0\1\62\101\0\1\63\1\64\77\0"+
    "\1\65\4\0\1\66\66\0\1\67\5\0\1\63\75\0"+
    "\1\70\2\0\1\15\77\0\1\71\1\72\1\73\72\0"+
    "\1\74\3\0\1\75\106\0\1\76\102\0\1\45\1\77"+
    "\1\100\3\45\1\101\1\102\23\45\2\0\11\45\32\0"+
    "\12\45\1\103\20\45\2\0\11\45\32\0\11\45\1\104"+
    "\1\105\2\45\1\106\1\45\1\107\13\45\2\0\11\45"+
    "\32\0\13\45\1\110\17\45\2\0\11\45\32\0\12\45"+
    "\1\111\20\45\2\0\11\45\32\0\13\45\1\112\17\45"+
    "\2\0\11\45\32\0\11\45\1\113\5\45\1\114\13\45"+
    "\2\0\11\45\32\0\17\45\1\115\13\45\2\0\11\45"+
    "\32\0\15\45\1\116\15\45\2\0\11\45\32\0\6\45"+
    "\1\117\1\120\11\45\1\121\11\45\2\0\11\45\32\0"+
    "\7\45\1\122\23\45\2\0\11\45\32\0\33\45\2\0"+
    "\11\45\32\0\7\45\1\123\1\124\7\45\1\125\4\45"+
    "\1\126\5\45\2\0\11\45\32\0\4\45\1\127\2\45"+
    "\1\130\14\45\1\131\6\45\2\0\11\45\32\0\17\45"+
    "\1\132\13\45\2\0\11\45\32\0\1\133\3\45\1\134"+
    "\26\45\2\0\11\45\32\0\1\135\11\45\1\136\4\45"+
    "\1\137\13\45\2\0\11\45\32\0\7\45\1\140\23\45"+
    "\2\0\11\45\32\0\3\45\1\141\27\45\2\0\11\45"+
    "\2\0\62\55\1\142\1\143\14\55\30\0\1\144\1\145"+
    "\17\144\1\146\11\144\2\0\1\144\1\60\2\144\2\60"+
    "\1\0\1\144\33\0\33\144\2\0\1\144\1\60\2\144"+
    "\2\60\1\0\1\144\3\0\64\63\1\56\11\63\1\56"+
    "\1\63\12\0\1\147\65\0\6\150\1\151\71\150\12\0"+
    "\1\152\115\0\2\45\1\153\30\45\2\0\11\45\32\0"+
    "\2\45\1\154\30\45\2\0\11\45\32\0\6\45\1\155"+
    "\24\45\2\0\11\45\32\0\10\45\1\156\22\45\2\0"+
    "\11\45\32\0\3\45\1\157\27\45\2\0\11\45\32\0"+
    "\3\45\1\160\23\45\1\161\3\45\2\0\11\45\32\0"+
    "\20\45\1\162\12\45\2\0\11\45\32\0\30\45\1\163"+
    "\2\45\2\0\11\45\32\0\20\45\1\164\12\45\2\0"+
    "\11\45\32\0\15\45\1\165\15\45\2\0\11\45\32\0"+
    "\7\45\1\166\23\45\2\0\11\45\32\0\11\45\1\167"+
    "\21\45\2\0\11\45\32\0\3\45\1\170\27\45\2\0"+
    "\11\45\32\0\7\45\1\171\23\45\2\0\11\45\32\0"+
    "\3\45\1\172\3\45\1\173\23\45\2\0\11\45\32\0"+
    "\2\45\1\174\30\45\2\0\11\45\32\0\2\45\1\175"+
    "\30\45\2\0\11\45\32\0\12\45\1\176\20\45\2\0"+
    "\11\45\32\0\1\177\2\45\1\200\7\45\1\201\10\45"+
    "\1\202\6\45\2\0\11\45\32\0\15\45\1\203\15\45"+
    "\2\0\11\45\32\0\3\45\1\204\27\45\2\0\11\45"+
    "\32\0\11\45\1\205\21\45\2\0\11\45\32\0\24\45"+
    "\1\206\6\45\2\0\11\45\32\0\25\45\1\207\5\45"+
    "\2\0\11\45\32\0\11\45\1\210\21\45\2\0\11\45"+
    "\32\0\11\45\1\211\21\45\2\0\11\45\32\0\10\45"+
    "\1\212\22\45\2\0\11\45\32\0\4\45\1\213\26\45"+
    "\2\0\11\45\32\0\11\45\1\214\3\45\1\215\15\45"+
    "\2\0\11\45\32\0\5\45\1\216\25\45\2\0\11\45"+
    "\32\0\7\45\1\217\23\45\2\0\11\45\32\0\4\45"+
    "\1\220\26\45\2\0\11\45\32\0\3\45\1\221\27\45"+
    "\2\0\11\45\32\0\4\45\1\222\26\45\2\0\11\45"+
    "\32\0\33\223\2\0\6\223\1\0\1\223\3\0\64\55"+
    "\1\0\13\55\30\0\33\144\2\0\6\144\1\0\1\144"+
    "\33\0\33\144\2\0\1\144\2\224\1\144\1\224\1\144"+
    "\1\0\1\144\33\0\2\225\3\144\1\225\2\144\2\225"+
    "\13\144\1\225\5\144\2\0\1\144\1\225\1\226\3\225"+
    "\1\0\1\144\3\0\6\150\1\227\77\150\1\227\5\150"+
    "\1\230\63\150\30\0\3\45\1\231\27\45\2\0\11\45"+
    "\32\0\11\45\1\232\21\45\2\0\11\45\32\0\11\45"+
    "\1\233\21\45\2\0\11\45\32\0\2\45\1\234\30\45"+
    "\2\0\11\45\32\0\5\45\1\235\25\45\2\0\11\45"+
    "\32\0\11\45\1\236\21\45\2\0\11\45\32\0\11\45"+
    "\1\237\21\45\2\0\11\45\32\0\16\45\1\240\14\45"+
    "\2\0\11\45\32\0\11\45\1\241\21\45\2\0\11\45"+
    "\32\0\20\45\1\242\12\45\2\0\11\45\32\0\5\45"+
    "\1\243\25\45\2\0\11\45\32\0\11\45\1\244\21\45"+
    "\2\0\11\45\32\0\1\245\32\45\2\0\11\45\32\0"+
    "\11\45\1\246\21\45\2\0\11\45\32\0\23\45\1\247"+
    "\7\45\2\0\11\45\32\0\7\45\1\250\23\45\2\0"+
    "\11\45\32\0\6\45\1\251\24\45\2\0\11\45\32\0"+
    "\7\45\1\252\23\45\2\0\11\45\32\0\12\45\1\253"+
    "\20\45\2\0\11\45\32\0\3\45\1\254\27\45\2\0"+
    "\11\45\32\0\10\45\1\255\22\45\2\0\11\45\32\0"+
    "\23\45\1\256\7\45\2\0\11\45\32\0\3\45\1\257"+
    "\27\45\2\0\11\45\32\0\15\45\1\260\15\45\2\0"+
    "\11\45\32\0\2\226\3\144\1\226\2\144\2\226\13\144"+
    "\1\226\5\144\2\0\1\144\1\226\1\144\3\226\1\0"+
    "\1\144\3\0\6\150\1\227\5\150\1\56\63\150\30\0"+
    "\4\45\1\261\26\45\2\0\11\45\32\0\4\45\1\262"+
    "\26\45\2\0\11\45\32\0\14\45\1\263\16\45\2\0"+
    "\11\45\32\0\17\45\1\264\13\45\2\0\11\45\32\0"+
    "\3\45\1\265\27\45\2\0\11\45\32\0\7\45\1\266"+
    "\23\45\2\0\11\45\32\0\12\45\1\267\20\45\2\0"+
    "\11\45\32\0\5\45\1\270\25\45\2\0\11\45\32\0"+
    "\15\45\1\271\15\45\2\0\11\45\32\0\6\45\1\272"+
    "\24\45\2\0\11\45\32\0\15\45\1\273\15\45\2\0"+
    "\11\45\32\0\1\274\32\45\2\0\11\45\32\0\7\45"+
    "\1\275\23\45\2\0\11\45\32\0\1\276\32\45\2\0"+
    "\11\45\32\0\3\45\1\277\27\45\2\0\11\45\32\0"+
    "\15\45\1\300\15\45\2\0\11\45\32\0\6\45\1\301"+
    "\24\45\2\0\11\45\32\0\10\45\1\302\22\45\2\0"+
    "\11\45\32\0\2\45\1\303\30\45\2\0\11\45\32\0"+
    "\3\45\1\304\27\45\2\0\11\45\32\0\11\45\1\305"+
    "\21\45\2\0\11\45\32\0\11\45\1\306\21\45\2\0"+
    "\11\45\32\0\3\45\1\307\27\45\2\0\11\45\32\0"+
    "\3\45\1\310\27\45\2\0\11\45\32\0\30\45\1\311"+
    "\2\45\2\0\11\45\32\0\5\45\1\312\25\45\2\0"+
    "\11\45\32\0\7\45\1\313\23\45\2\0\11\45\32\0"+
    "\22\45\1\314\10\45\2\0\11\45\32\0\2\45\1\315"+
    "\30\45\2\0\11\45\32\0\3\45\1\316\27\45\2\0"+
    "\11\45\32\0\2\45\1\317\30\45\2\0\11\45\32\0"+
    "\15\45\1\320\15\45\2\0\11\45\32\0\11\45\1\321"+
    "\21\45\2\0\11\45\32\0\3\45\1\322\27\45\2\0"+
    "\11\45\32\0\3\45\1\323\27\45\2\0\11\45\32\0"+
    "\15\45\1\324\15\45\2\0\11\45\32\0\17\45\1\325"+
    "\13\45\2\0\11\45\32\0\23\45\1\326\7\45\2\0"+
    "\11\45\32\0\7\45\1\327\23\45\2\0\11\45\32\0"+
    "\11\45\1\330\21\45\2\0\11\45\2\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[9216];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\1\0\3\11\1\1\3\11\1\1\1\11\2\1\1\11"+
    "\4\1\5\11\1\1\2\11\24\1\1\11\2\1\2\11"+
    "\1\1\1\11\1\1\1\11\1\0\3\11\1\1\3\11"+
    "\44\1\1\0\3\1\1\11\2\0\1\11\54\1\1\0"+
    "\101\1";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[216];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the textposition at the last state to be included in yytext */
  private int zzPushbackPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn;

  /** 
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /** denotes if the user-EOF-code has already been executed */
  private boolean zzEOFDone;

  /* user code: */
 public String alloy_filename="";
 public int alloy_lineoffset=0; // If not zero, it is added to the current LINE NUMBER
 public List<Object> alloy_seenDollar;
 public CompModule alloy_module;
 private final Pos alloy_here(String txt) {
    return new Pos(alloy_filename,yycolumn+1,yyline+1+alloy_lineoffset,yycolumn+txt.length(),yyline+1);
 }
 private final Symbol alloy_sym(String txt, int type) {
    Pos p = alloy_here(txt); return new Symbol(type, p, p);
 }
 private final Symbol alloy_string(String txt) throws Err {
    Pos p = alloy_here(txt);
    if (!Version.experimental) throw new ErrorSyntax(p, "String literal is not currently supported.");
    StringBuilder sb = new StringBuilder(txt.length());
    for(int i=0; i<txt.length(); i++) {
       char c = txt.charAt(i);
       if (c=='\r' || c=='\n') throw new ErrorSyntax(p, "String literal cannot span multiple lines; use \\n instead.");
       if (c=='\\') {
          i++;
          if (i>=txt.length()) throw new ErrorSyntax(p, "String literal cannot end with a single \\");
          c = txt.charAt(i);
          if (c=='n') c='\n'; else if (c!='\'' && c!='\"' && c!='\\') throw new ErrorSyntax(p, "String literal currenty only supports\nfour escape sequences: \\\\, \\n, \\\', and \\\"");
       }
       sb.append(c);
    }
    txt = sb.toString();
    if (txt.length()==2) throw new ErrorSyntax(p, "Empty string is not allowed; try rewriting your model to use an empty set instead.");
    return new Symbol(CompSym.STR, p, ExprConstant.Op.STRING.make(p, txt));
 }
 private final Symbol alloy_id(String txt) throws Err {
    Pos p=alloy_here(txt);
    if (alloy_seenDollar.size()==0 && txt.indexOf('$')>=0) alloy_seenDollar.add(null);
    return new Symbol(CompSym.ID, p, ExprVar.make(p,txt));
 }
 private final Symbol alloy_num(String txt) throws Err {
    Pos p=alloy_here(txt);
    int n=0;
    try {
        txt = txt.replaceAll("_","");
        n=Integer.parseInt(txt);
    } catch(NumberFormatException ex) {
       throw new ErrorSyntax(p, "The number "+txt+" " + ex);
    }
    return new Symbol(CompSym.NUMBER, p, ExprConstant.Op.NUMBER.make(p, n));
 }
 private final Symbol alloy_hexnum(String txt) throws Err {
    Pos p=alloy_here(txt);
    int n=0;
    try {
        txt = txt.substring(2).replaceAll("_","");
        n=Integer.parseInt(txt, 16);
    } catch(NumberFormatException ex) {
       throw new ErrorSyntax(p, "The hex number "+txt+" " + ex);
    }
    return new Symbol(CompSym.NUMBER, p, ExprConstant.Op.NUMBER.make(p, n));
 }
 private final Symbol alloy_binarynum(String txt) throws Err {
    Pos p=alloy_here(txt);
    int n=0;
    try {
        txt = txt.substring(2).replaceAll("_","");
        n=Integer.parseInt(txt, 2);
    } catch(NumberFormatException ex) {
       throw new ErrorSyntax(p, "The binary number "+txt+" " + ex);
    }
    return new Symbol(CompSym.NUMBER, p, ExprConstant.Op.NUMBER.make(p, n));
 }


  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public CompLexer(java.io.Reader in) {
    this.zzReader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  public CompLexer(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 2264) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead-zzStartRead);

      /* translate stored positions */
      zzEndRead-= zzStartRead;
      zzCurrentPos-= zzStartRead;
      zzMarkedPos-= zzStartRead;
      zzPushbackPos-= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzCurrentPos*2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
    }

    /* finally: fill the buffer with new input */
    int numRead = zzReader.read(zzBuffer, zzEndRead,
                                            zzBuffer.length-zzEndRead);

    if (numRead < 0) {
      return true;
    }
    else {
      zzEndRead+= numRead;
      return false;
    }
  }

    
  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>ZZ_INITIAL</tt>.
   *
   * @param reader   the new input stream 
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzAtBOL  = true;
    zzAtEOF  = false;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = zzPushbackPos = 0;
    yyline = yychar = yycolumn = 0;
    zzLexicalState = YYINITIAL;
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Contains user EOF-code, which will be executed exactly once,
   * when the end of file is reached
   */
  private void zzDoEOF() throws java.io.IOException {
    if (!zzEOFDone) {
      zzEOFDone = true;
      yyclose();
    }
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public java_cup.runtime.Symbol next_token() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      boolean zzR = false;
      for (zzCurrentPosL = zzStartRead; zzCurrentPosL < zzMarkedPosL;
                                                             zzCurrentPosL++) {
        switch (zzBufferL[zzCurrentPosL]) {
        case '\u000B':
        case '\u000C':
        case '\u0085':
        case '\u2028':
        case '\u2029':
          yyline++;
          yycolumn = 0;
          zzR = false;
          break;
        case '\r':
          yyline++;
          yycolumn = 0;
          zzR = true;
          break;
        case '\n':
          if (zzR)
            zzR = false;
          else {
            yyline++;
            yycolumn = 0;
          }
          break;
        default:
          zzR = false;
          yycolumn++;
        }
      }

      if (zzR) {
        // peek one character ahead if it is \n (if we have counted one line too much)
        boolean zzPeek;
        if (zzMarkedPosL < zzEndReadL)
          zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        else if (zzAtEOF)
          zzPeek = false;
        else {
          boolean eof = zzRefill();
          zzEndReadL = zzEndRead;
          zzMarkedPosL = zzMarkedPos;
          zzBufferL = zzBuffer;
          if (eof) 
            zzPeek = false;
          else 
            zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        }
        if (zzPeek) yyline--;
      }
      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      zzState = zzLexicalState;


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          int zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 4: 
          { return alloy_sym(yytext(), CompSym.AMPERSAND   );
          }
        case 86: break;
        case 50: 
          { return alloy_sym(yytext(), CompSym.SEQ         );
          }
        case 87: break;
        case 62: 
          { return alloy_binarynum (yytext());
          }
        case 88: break;
        case 38: 
          { return alloy_sym(yytext(), CompSym.IMPLIES     );
          }
        case 89: break;
        case 23: 
          { return alloy_sym(yytext(), CompSym.RBRACE      );
          }
        case 90: break;
        case 82: 
          { return alloy_sym(yytext(), CompSym.EXACTLY     );
          }
        case 91: break;
        case 1: 
          { throw new ErrorSyntax(alloy_here(" "), "Syntax error at the "+yytext()+" character. HEX: \\u"+Integer.toString(yytext().charAt(0),16)+")");
          }
        case 92: break;
        case 53: 
          { return alloy_sym(yytext(), CompSym.RUN         );
          }
        case 93: break;
        case 36: 
          { return alloy_sym(yytext(), CompSym.SHL         );
          }
        case 94: break;
        case 35: 
          { return alloy_sym(yytext(), CompSym.DOMAIN      );
          }
        case 95: break;
        case 60: 
          { return alloy_sym(yytext(), CompSym.SIGINT      );
          }
        case 96: break;
        case 24: 
          { return alloy_sym(yytext(), CompSym.TILDE       );
          }
        case 97: break;
        case 21: 
          { return alloy_sym(yytext(), CompSym.LBRACE      );
          }
        case 98: break;
        case 7: 
          { return alloy_sym(yytext(), CompSym.STAR        );
          }
        case 99: break;
        case 30: 
          { return alloy_sym(yytext(), CompSym.PLUSPLUS    );
          }
        case 100: break;
        case 58: 
          { return alloy_sym(yytext(), CompSym.FUN         );
          }
        case 101: break;
        case 81: 
          { return alloy_sym(yytext(), CompSym.STRING      );
          }
        case 102: break;
        case 55: 
          { return alloy_sym(yytext(), CompSym.EXH         );
          }
        case 103: break;
        case 56: 
          { return alloy_sym(yytext(), CompSym.INT         );
          }
        case 104: break;
        case 52: 
          { return alloy_sym(yytext(), CompSym.SIG         );
          }
        case 105: break;
        case 75: 
          { return alloy_sym(yytext(), CompSym.PRED        );
          }
        case 106: break;
        case 25: 
          { return alloy_id  (yytext());
          }
        case 107: break;
        case 66: 
          { return alloy_sym(yytext(), CompSym.LONE        );
          }
        case 108: break;
        case 41: 
          { return alloy_sym(yytext(), CompSym.NO          );
          }
        case 109: break;
        case 9: 
          { return alloy_sym(yytext(), CompSym.COMMA       );
          }
        case 110: break;
        case 40: 
          { return alloy_sym(yytext(), CompSym.AS          );
          }
        case 111: break;
        case 65: 
          { return alloy_sym(yytext(), CompSym.THIS        );
          }
        case 112: break;
        case 13: 
          { return alloy_sym(yytext(), CompSym.SLASH       );
          }
        case 113: break;
        case 48: 
          { return alloy_sym(yytext(), CompSym.BUT         );
          }
        case 114: break;
        case 43: 
          { return alloy_string(yytext());
          }
        case 115: break;
        case 68: 
          { return alloy_sym(yytext(), CompSym.DISJ        );
          }
        case 116: break;
        case 32: 
          { return alloy_sym(yytext(), CompSym.SHA         );
          }
        case 117: break;
        case 39: 
          { return alloy_sym(yytext(), CompSym.OR          );
          }
        case 118: break;
        case 45: 
          { return alloy_sym(yytext(), CompSym.SHR         );
          }
        case 119: break;
        case 84: 
          { return alloy_sym(yytext(), CompSym.PRIVATE     );
          }
        case 120: break;
        case 31: 
          { return alloy_sym(yytext(), CompSym.ARROW       );
          }
        case 121: break;
        case 33: 
          { return alloy_sym(yytext(), CompSym.GTE         );
          }
        case 122: break;
        case 20: 
          { return alloy_sym(yytext(), CompSym.CARET       );
          }
        case 123: break;
        case 46: 
          { return alloy_sym(yytext(), CompSym.IFF         );
          }
        case 124: break;
        case 69: 
          { return alloy_sym(yytext(), CompSym.ELSE        );
          }
        case 125: break;
        case 3: 
          { return alloy_sym(yytext(), CompSym.HASH        );
          }
        case 126: break;
        case 12: 
          { return alloy_sym(yytext(), CompSym.DOT         );
          }
        case 127: break;
        case 22: 
          { return alloy_sym(yytext(), CompSym.BAR         );
          }
        case 128: break;
        case 79: 
          { return alloy_sym(yytext(), CompSym.EXPECT      );
          }
        case 129: break;
        case 8: 
          { return alloy_sym(yytext(), CompSym.PLUS        );
          }
        case 130: break;
        case 37: 
          { return alloy_sym(yytext(), CompSym.LTE         );
          }
        case 131: break;
        case 57: 
          { return alloy_sym(yytext(), CompSym.ONE         );
          }
        case 132: break;
        case 73: 
          { return alloy_sym(yytext(), CompSym.OPEN        );
          }
        case 133: break;
        case 63: 
          { return alloy_hexnum (yytext());
          }
        case 134: break;
        case 11: 
          { return alloy_sym(yytext(), CompSym.GT          );
          }
        case 135: break;
        case 80: 
          { return alloy_sym(yytext(), CompSym.MODULE      );
          }
        case 136: break;
        case 14: 
          { return alloy_sym(yytext(), CompSym.COLON       );
          }
        case 137: break;
        case 51: 
          { return alloy_sym(yytext(), CompSym.SUM         );
          }
        case 138: break;
        case 74: 
          { return alloy_sym(yytext(), CompSym.PART        );
          }
        case 139: break;
        case 16: 
          { return alloy_sym(yytext(), CompSym.EQUALS      );
          }
        case 140: break;
        case 83: 
          { return alloy_sym(yytext(), CompSym.EXTENDS     );
          }
        case 141: break;
        case 26: 
          { throw new ErrorSyntax(alloy_here(yytext()),"String literal is missing its closing \" character");
          }
        case 142: break;
        case 59: 
          { return alloy_sym(yytext(), CompSym.FOR         );
          }
        case 143: break;
        case 28: 
          { return alloy_num (yytext());
          }
        case 144: break;
        case 72: 
          { return alloy_sym(yytext(), CompSym.IDEN        );
          }
        case 145: break;
        case 15: 
          { return alloy_sym(yytext(), CompSym.LT          );
          }
        case 146: break;
        case 17: 
          { return alloy_sym(yytext(), CompSym.AT          );
          }
        case 147: break;
        case 34: 
          { return alloy_sym(yytext(), CompSym.RANGE       );
          }
        case 148: break;
        case 71: 
          { return alloy_sym(yytext(), CompSym.UNIV        );
          }
        case 149: break;
        case 2: 
          { return alloy_sym(yytext(), CompSym.NOT         );
          }
        case 150: break;
        case 49: 
          { return alloy_sym(yytext(), CompSym.SET         );
          }
        case 151: break;
        case 6: 
          { return alloy_sym(yytext(), CompSym.RPAREN      );
          }
        case 152: break;
        case 42: 
          { return alloy_sym(yytext(), CompSym.IN          );
          }
        case 153: break;
        case 77: 
          { return alloy_sym(yytext(), CompSym.CHECK       );
          }
        case 154: break;
        case 29: 
          { return alloy_sym(yytext(), CompSym.AND         );
          }
        case 155: break;
        case 64: 
          { return alloy_sym(yytext(), CompSym.SOME        );
          }
        case 156: break;
        case 76: 
          { return alloy_sym(yytext(), CompSym.FACT        );
          }
        case 157: break;
        case 10: 
          { return alloy_sym(yytext(), CompSym.MINUS       );
          }
        case 158: break;
        case 5: 
          { return alloy_sym(yytext(), CompSym.LPAREN      );
          }
        case 159: break;
        case 67: 
          { return alloy_sym(yytext(), CompSym.NONE        );
          }
        case 160: break;
        case 18: 
          { return alloy_sym(yytext(), CompSym.LBRACKET    );
          }
        case 161: break;
        case 19: 
          { return alloy_sym(yytext(), CompSym.RBRACKET    );
          }
        case 162: break;
        case 70: 
          { return alloy_sym(yytext(), CompSym.ENUM        );
          }
        case 163: break;
        case 47: 
          { return alloy_sym(yytext(), CompSym.ALL         );
          }
        case 164: break;
        case 85: 
          { return alloy_sym(yytext(), CompSym.ABSTRACT    );
          }
        case 165: break;
        case 78: 
          { return alloy_sym(yytext(), CompSym.ASSERT      );
          }
        case 166: break;
        case 61: 
          { throw new ErrorSyntax(alloy_here(yytext()),"String literal cannot be followed by a legal identifier character.");
          }
        case 167: break;
        case 54: 
          { return alloy_sym(yytext(), CompSym.LET         );
          }
        case 168: break;
        case 27: 
          { 
          }
        case 169: break;
        case 44: 
          { throw new ErrorSyntax(alloy_here(yytext()),"Name cannot start with a number.");
          }
        case 170: break;
        default: 
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
            zzDoEOF();
              {   return new Symbol(CompSym.EOF, alloy_here(" "), alloy_here(" "));
 }
          } 
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
