/*
 * Decompiled with CFR 0.152.
 */
package util;

import jdk.jfr.Category;
import jdk.jfr.Event;
import jdk.jfr.Label;
import jdk.jfr.StackTrace;
import jdk.jfr.Unsigned;

public class TLAFlightRecorder {
    public static void progress(boolean isFinal, int diameter, long states, long distinctStates, long unseen, long statesPerMinute, long distinctStatesPerMinute) {
        try {
            ProgressEvent e = new ProgressEvent();
            e.isFinal = isFinal;
            e.spm = statesPerMinute;
            e.dspm = distinctStatesPerMinute;
            e.diameter = diameter;
            e.unseen = unseen;
            e.states = states;
            e.distStates = distinctStates;
            e.commit();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    public static String message(String message) {
        try {
            MessageEvent e = new MessageEvent();
            e.message = message;
            e.commit();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        return message;
    }

    @Label(value="Message")
    @Category(value={"TLC"})
    @StackTrace(value=false)
    private static class MessageEvent
    extends Event {
        @Label(value="Message")
        public String message;

        private MessageEvent() {
        }
    }

    @Label(value="Progress")
    @Category(value={"TLC", "Progress"})
    @StackTrace(value=false)
    private static class ProgressEvent
    extends Event {
        @Label(value="States generated per minute")
        @Unsigned
        private long spm;
        @Label(value="Distinct states generated per minute")
        @Unsigned
        private long dspm;
        @Label(value="Unseen States")
        @Unsigned
        private long unseen;
        @Label(value="Diameter")
        @Unsigned
        private int diameter;
        @Label(value="States Generated")
        @Unsigned
        private long states;
        @Label(value="Distinct States Generated")
        @Unsigned
        private long distStates;
        @Label(value="Model Checking done")
        private boolean isFinal;

        private ProgressEvent() {
        }
    }
}

