/*
 * Decompiled with CFR 0.152.
 */
package tla2sany.xml;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import tla2sany.semantic.AssumeNode;
import tla2sany.semantic.SymbolNode;
import tla2sany.semantic.TheoremNode;

public class SymbolContext {
    private Map<Integer, Element> context;
    private Set<Integer> keys;
    private boolean top_level_entry;
    public static final int OTHER_BUG = 0;
    private boolean[] flagArray;

    public SymbolContext() {
        this.context = new HashMap<Integer, Element>();
        this.keys = new HashSet<Integer>();
        this.flagArray = new boolean[1];
        this.top_level_entry = false;
    }

    public SymbolContext(SymbolContext other) {
        this.context = other.context;
        this.keys = other.keys;
        this.flagArray = other.flagArray;
        this.top_level_entry = other.top_level_entry;
    }

    public void setFlag(int flag) {
        this.flagArray[flag] = true;
    }

    public boolean hasFlag(int flag) {
        return this.flagArray[flag];
    }

    public void put(SymbolNode nd, Document doc) {
        Integer k = new Integer(nd.myUID);
        if (!this.keys.contains(k)) {
            this.keys.add(k);
            this.setTop_level_entry();
            this.context.put(k, nd.exportDefinition(doc, this));
        }
    }

    public void put(TheoremNode nd, Document doc) {
        Integer k = new Integer(nd.myUID);
        if (!this.keys.contains(k)) {
            this.keys.add(k);
            this.setTop_level_entry();
            this.context.put(k, nd.exportDefinition(doc, this));
        }
    }

    public void put(AssumeNode nd, Document doc) {
        Integer k = new Integer(nd.myUID);
        if (!this.keys.contains(k)) {
            this.keys.add(k);
            this.setTop_level_entry();
            this.context.put(k, nd.exportDefinition(doc, this));
        }
    }

    public Element getContextElement(Document doc) {
        Element ret = doc.createElement("context");
        for (Map.Entry<Integer, Element> entry : this.context.entrySet()) {
            Element e = doc.createElement("entry");
            Element id = doc.createElement("UID");
            id.appendChild(doc.createTextNode(entry.getKey().toString()));
            e.appendChild(id);
            e.appendChild(entry.getValue());
            ret.appendChild(e);
        }
        return ret;
    }

    public int getContextSize() {
        return this.context.size();
    }

    public boolean isTop_level_entry() {
        return this.top_level_entry;
    }

    public void setTop_level_entry() {
        this.top_level_entry = true;
    }

    public void resetTop_level_entry() {
        this.top_level_entry = false;
    }
}

