/*
 * Decompiled with CFR 0.152.
 */
package de.tla2bAst;

import de.be4.classicalb.core.parser.node.Start;
import de.tla2b.analysis.SpecAnalyser;
import de.tla2b.analysis.SymbolRenamer;
import de.tla2b.analysis.TypeChecker;
import de.tla2b.exceptions.ExpressionTranslationException;
import de.tla2b.exceptions.TLA2BException;
import de.tla2b.exceptions.TLA2BFrontEndException;
import de.tla2b.global.BBuiltInOPs;
import de.tla2b.util.TlaUtils;
import de.tla2bAst.BAstCreator;
import de.tla2bAst.Translator;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import tla2sany.drivers.FrontEndException;
import tla2sany.drivers.InitException;
import tla2sany.drivers.SANY;
import tla2sany.modanalyzer.ParseUnit;
import tla2sany.modanalyzer.SpecObj;
import tla2sany.parser.ParseException;
import tla2sany.semantic.FormalParamNode;
import tla2sany.semantic.ModuleNode;
import tla2sany.semantic.OpDeclNode;
import tla2sany.semantic.OpDefNode;
import tla2sany.semantic.OpDefOrDeclNode;
import tla2sany.semantic.SymbolNode;
import tla2sany.st.SyntaxTreeConstants;
import tla2sany.st.TreeNode;
import util.ToolIO;

public class ExpressionTranslator
implements SyntaxTreeConstants {
    private final String tlaExpression;
    private final List<String> variables = new ArrayList<String>();
    private final List<String> noVariables = new ArrayList<String>();
    private final Map<String, FormalParamNode[]> definitions = new HashMap<String, FormalParamNode[]>();
    private final Map<String, SymbolNode> namingMap = new HashMap<String, SymbolNode>();
    private ModuleNode moduleNode;
    private String expr;
    private Translator translator;
    private static final Set<String> KEYWORDS = new HashSet<String>();

    @Deprecated
    public ExpressionTranslator(String tlaExpression) {
        this.tlaExpression = tlaExpression;
    }

    @Deprecated
    public ExpressionTranslator(String tlaExpression, Translator translator) {
        this.tlaExpression = tlaExpression;
        this.translator = translator;
        ModuleNode moduleContext = translator.getSpecAnalyser().getModuleNode();
        this.namingMap.putAll(TlaUtils.getDeclarationsMap(moduleContext.getVariableDecls()));
        this.namingMap.putAll(TlaUtils.getDeclarationsMap(moduleContext.getConstantDecls()));
        this.namingMap.putAll(TlaUtils.getOpDefsMap(moduleContext.getOpDefs()));
    }

    @Deprecated
    public void parse() {
        File tempFile;
        String dir = System.getProperty("java.io.tmpdir");
        ToolIO.setUserDir(dir);
        try {
            tempFile = File.createTempFile("Expression", ".tla");
        }
        catch (IOException e) {
            throw new ExpressionTranslationException("Can not create temporary file in directory '" + dir + "'");
        }
        String moduleName = tempFile.getName().substring(0, tempFile.getName().indexOf("."));
        String module = "----MODULE " + moduleName + " ----\nExpression == " + this.tlaExpression + "\n====";
        try (FileWriter fw = new FileWriter(tempFile);){
            fw.write(module);
        }
        catch (IOException e) {
            throw new ExpressionTranslationException("Can not write module to temporary file " + tempFile.getAbsolutePath());
        }
        SpecObj spec = this.parseModuleWithoutSemanticAnalyse(moduleName, module);
        this.evalVariables(spec, moduleName);
        StringBuilder sb = new StringBuilder();
        sb.append("----MODULE ").append(moduleName).append(" ----\n");
        sb.append("EXTENDS Naturals, Integers, Reals, Sequences, FiniteSets \n");
        if (!this.variables.isEmpty()) {
            sb.append("VARIABLES ");
            sb.append(String.join((CharSequence)", ", this.variables));
            sb.append("\n");
        }
        if (!this.definitions.isEmpty()) {
            this.definitions.forEach((name, params) -> {
                List paramNames = Arrays.stream((Object[])this.definitions.getOrDefault(name, new FormalParamNode[0])).map(p -> p.getName().toString()).collect(Collectors.toList());
                sb.append((String)name);
                if (!paramNames.isEmpty()) {
                    sb.append("(");
                    sb.append(String.join((CharSequence)", ", paramNames));
                    sb.append(")");
                }
                sb.append(" == <<");
                if (!paramNames.isEmpty()) {
                    sb.append(String.join((CharSequence)", ", paramNames));
                }
                sb.append(">>\n");
            });
        }
        sb.append("Expression");
        sb.append(" == ");
        sb.append(this.tlaExpression);
        sb.append("\n====================");
        this.expr = sb.toString();
        try (FileWriter fw = new FileWriter(tempFile);){
            fw.write(this.expr);
            tempFile.deleteOnExit();
        }
        catch (IOException e) {
            throw new ExpressionTranslationException(e.getMessage());
        }
        ToolIO.reset();
        this.moduleNode = null;
        try {
            this.moduleNode = this.parseModule(moduleName, sb.toString());
        }
        catch (TLA2BFrontEndException e) {
            throw new ExpressionTranslationException(e.getLocalizedMessage());
        }
    }

    public static Start translate(String tlaExpression) {
        ExpressionTranslator expressionTranslator = new ExpressionTranslator(tlaExpression);
        expressionTranslator.parse();
        return expressionTranslator.translate();
    }

    public static Start translate(String tlaExpression, Translator translator) {
        ExpressionTranslator expressionTranslator = new ExpressionTranslator(tlaExpression, translator);
        expressionTranslator.parse();
        expressionTranslator.setTypesOfExistingNodes();
        return expressionTranslator.translate();
    }

    @Deprecated
    public Start translate() {
        SpecAnalyser specAnalyser = SpecAnalyser.createSpecAnalyserForTlaExpression(this.moduleNode);
        TypeChecker tc = new TypeChecker(this.moduleNode, specAnalyser);
        try {
            tc.start();
        }
        catch (TLA2BException e) {
            String message = "****TypeError****\n" + e.getLocalizedMessage() + "\n" + this.expr + "\n";
            throw new ExpressionTranslationException(message);
        }
        SymbolRenamer.run(this.moduleNode, specAnalyser);
        return new BAstCreator(this.moduleNode, specAnalyser).getStartNode();
    }

    @Deprecated
    public Start translateIncludingModel() {
        this.setTypesOfExistingNodes();
        return this.translate();
    }

    @Deprecated
    public Start translateWithoutModel() {
        return this.translate();
    }

    private ModuleNode parseModule(String moduleName, String module) throws TLA2BFrontEndException {
        SpecObj spec = new SpecObj(moduleName, null);
        try {
            SANY.frontEndMain(spec, moduleName, ToolIO.out);
        }
        catch (FrontEndException e) {
            throw new TLA2BFrontEndException("Frontend error! This should never happen.", spec);
        }
        if (spec.parseErrors.isFailure()) {
            String message = module + "\n\n" + spec.parseErrors + ExpressionTranslator.allMessagesToString(ToolIO.getAllMessages());
            throw new TLA2BFrontEndException(message, spec);
        }
        if (spec.semanticErrors.isFailure()) {
            String message = module + "\n\n" + spec.semanticErrors + ExpressionTranslator.allMessagesToString(ToolIO.getAllMessages());
            throw new TLA2BFrontEndException(message, spec);
        }
        ModuleNode n = spec.getExternalModuleTable().rootModule;
        if (spec.getInitErrors().isFailure()) {
            System.err.println(spec.getInitErrors());
            throw new TLA2BFrontEndException(ExpressionTranslator.allMessagesToString(ToolIO.getAllMessages()), spec);
        }
        if (n == null) {
            throw new TLA2BFrontEndException(ExpressionTranslator.allMessagesToString(ToolIO.getAllMessages()), spec);
        }
        return n;
    }

    private SpecObj parseModuleWithoutSemanticAnalyse(String moduleFileName, String module) {
        SpecObj spec = new SpecObj(moduleFileName, null);
        try {
            SANY.frontEndInitialize(spec, ToolIO.err);
            SANY.frontEndParse(spec, ToolIO.err);
        }
        catch (InitException | ParseException e) {
            throw new ExpressionTranslationException(e.getLocalizedMessage());
        }
        if (spec.parseErrors.isFailure()) {
            throw new ExpressionTranslationException(module + "\n\n" + ExpressionTranslator.allMessagesToString(ToolIO.getAllMessages()));
        }
        return spec;
    }

    private void evalVariables(SpecObj spec, String moduleName) {
        ParseUnit p = spec.parseUnitContext.get(moduleName);
        TreeNode n_module = p.getParseTree();
        TreeNode n_body = n_module.heirs()[2];
        TreeNode n_operatorDefinition = n_body.heirs()[0];
        TreeNode expr = n_operatorDefinition.heirs()[2];
        this.searchVarInSyntaxTree(expr);
        for (String noVariable : this.noVariables) {
            this.variables.remove(noVariable);
        }
    }

    private void searchVarInSyntaxTree(TreeNode treeNode) {
        switch (treeNode.getKind()) {
            case 358: {
                String con = treeNode.heirs()[1].getImage();
                if (this.variables.contains(con) || KEYWORDS.contains(con)) break;
                SymbolNode existingNode = this.namingMap.get(con);
                if (existingNode instanceof OpDefNode) {
                    this.definitions.put(con, ((OpDefNode)existingNode).getParams());
                    break;
                }
                this.variables.add(con);
                break;
            }
            case 366: {
                TreeNode[] children = treeNode.heirs();
                this.noVariables.add(children[0].getImage());
                break;
            }
            case 363: {
                this.noVariables.add(treeNode.heirs()[0].getImage());
                break;
            }
            case 356: {
                this.noVariables.add(treeNode.heirs()[0].getImage());
                break;
            }
            case 425: {
                TreeNode[] children = treeNode.heirs();
                this.searchVarInSyntaxTree(treeNode.heirs()[children.length - 1]);
                break;
            }
            case 424: {
                String boundedVar;
                TreeNode[] children = treeNode.heirs();
                for (int i = 1; i < children.length - 2; i += 2) {
                    boundedVar = children[i].getImage();
                    if (this.noVariables.contains(boundedVar)) continue;
                    this.noVariables.add(boundedVar);
                }
                this.searchVarInSyntaxTree(treeNode.heirs()[children.length - 1]);
                break;
            }
            case 408: {
                String boundedVar;
                TreeNode[] children = treeNode.heirs();
                for (int i = 0; i < children.length - 2; i += 2) {
                    boundedVar = children[i].getImage();
                    if (this.noVariables.contains(boundedVar)) continue;
                    this.noVariables.add(boundedVar);
                }
                this.searchVarInSyntaxTree(treeNode.heirs()[children.length - 1]);
                break;
            }
            case 419: {
                TreeNode[] children = treeNode.heirs();
                String boundedVar = children[1].getImage();
                if (!this.noVariables.contains(boundedVar)) {
                    this.noVariables.add(boundedVar);
                }
                this.searchVarInSyntaxTree(treeNode.heirs()[3]);
                this.searchVarInSyntaxTree(treeNode.heirs()[5]);
                break;
            }
        }
        for (TreeNode heir : treeNode.heirs()) {
            this.searchVarInSyntaxTree(heir);
        }
    }

    private void setTypesOfExistingNodes() {
        if (this.translator != null) {
            for (OpDeclNode opDeclNode : this.moduleNode.getConstantDecls()) {
                this.setTypeExistingDeclNode(opDeclNode);
            }
            for (OpDeclNode opDeclNode : this.moduleNode.getVariableDecls()) {
                this.setTypeExistingDeclNode(opDeclNode);
            }
            for (OpDefOrDeclNode opDefOrDeclNode : this.moduleNode.getOpDefs()) {
                SymbolNode fromSpec = this.namingMap.get(opDefOrDeclNode.getName().toString());
                if (fromSpec == null) continue;
                if (this.translator.getSpecAnalyser().getBDefinitions().contains((OpDefNode)fromSpec)) {
                    ((OpDefNode)opDefOrDeclNode).setBody(((OpDefNode)fromSpec).getBody());
                    continue;
                }
                if (BBuiltInOPs.isBBuiltInOp((OpDefNode)opDefOrDeclNode)) continue;
                throw new ExpressionTranslationException("Evaluation error:\nDefinition '" + fromSpec.getName() + "' is not included in the B translation.\n");
            }
        }
    }

    private void setTypeExistingDeclNode(OpDeclNode node) {
        SymbolNode fromSpec = this.namingMap.get(node.getName().toString());
        if (fromSpec != null) {
            TypeChecker.setType(node, TypeChecker.getType(fromSpec));
        }
    }

    public static String allMessagesToString(String[] allMessages) {
        return Translator.allMessagesToString(allMessages);
    }

    static {
        KEYWORDS.add("BOOLEAN");
        KEYWORDS.add("TRUE");
        KEYWORDS.add("FALSE");
        KEYWORDS.add("Nat");
        KEYWORDS.add("Int");
        KEYWORDS.add("Real");
        KEYWORDS.add("Infinity");
        KEYWORDS.add("Cardinality");
        KEYWORDS.add("IsFiniteSet");
        KEYWORDS.add("Append");
        KEYWORDS.add("Head");
        KEYWORDS.add("Tail");
        KEYWORDS.add("Len");
        KEYWORDS.add("Seq");
        KEYWORDS.add("SubSeq");
        KEYWORDS.add("SelectSeq");
        KEYWORDS.add("MinOfSet");
        KEYWORDS.add("MaxOfSet");
        KEYWORDS.add("SetProduct");
        KEYWORDS.add("SetSummation");
        KEYWORDS.add("PermutedSequences");
        KEYWORDS.add("@");
    }
}

