/*
 * Decompiled with CFR 0.152.
 */
package de.tla2b.types;

import de.be4.classicalb.core.parser.node.ABoolSetExpression;
import de.be4.classicalb.core.parser.node.AMultOrCartExpression;
import de.be4.classicalb.core.parser.node.APowSubsetExpression;
import de.be4.classicalb.core.parser.node.ARecEntry;
import de.be4.classicalb.core.parser.node.AStructExpression;
import de.be4.classicalb.core.parser.node.PExpression;
import de.be4.classicalb.core.parser.node.PRecEntry;
import de.be4.classicalb.core.parser.node.TIdentifierLiteral;
import de.tla2b.exceptions.UnificationException;
import de.tla2b.output.TypeVisitorInterface;
import de.tla2b.types.AbstractHasFollowers;
import de.tla2b.types.StructOrFunctionType;
import de.tla2b.types.TLAType;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class StructType
extends AbstractHasFollowers {
    private final Map<String, TLAType> types = new LinkedHashMap<String, TLAType>();
    private boolean extensible = false;
    private boolean incompleteStruct = false;

    public StructType() {
        super(STRUCT);
    }

    public static StructType getIncompleteStruct() {
        StructType s = new StructType();
        s.incompleteStruct = true;
        return s;
    }

    public boolean isExtensible() {
        return this.extensible;
    }

    public TLAType getType(String fieldName) {
        return this.types.get(fieldName);
    }

    public void add(String name, TLAType type) {
        this.types.put(name, type);
        if (type instanceof AbstractHasFollowers) {
            ((AbstractHasFollowers)type).addFollower(this);
        }
    }

    public void setNewType(TLAType old, TLAType newType) {
        this.types.forEach((name, type) -> {
            if (type == old) {
                this.add((String)name, newType);
            }
        });
    }

    @Override
    public boolean isUntyped() {
        for (TLAType bType : this.types.values()) {
            if (!bType.isUntyped()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean compare(TLAType o) {
        if (this.contains(o) || o.contains(this)) {
            return false;
        }
        if (o.getKind() == UNTYPED) {
            return true;
        }
        if (o instanceof StructOrFunctionType) {
            return o.compare(this);
        }
        if (o instanceof StructType) {
            StructType s = (StructType)o;
            return this.types.keySet().stream().filter(s.types::containsKey).allMatch(fieldName -> this.types.get(fieldName).compare(s.types.get(fieldName)));
        }
        return false;
    }

    @Override
    public StructType unify(TLAType o) throws UnificationException {
        if (!this.compare(o)) {
            throw new UnificationException();
        }
        if (o instanceof AbstractHasFollowers) {
            ((AbstractHasFollowers)o).setFollowersTo(this);
        }
        if (o instanceof StructOrFunctionType) {
            return (StructType)o.unify(this);
        }
        if (o instanceof StructType) {
            StructType otherStruct = (StructType)o;
            boolean extendStruct = this.incompleteStruct && otherStruct.incompleteStruct ? false : (this.incompleteStruct ? !otherStruct.types.keySet().containsAll(this.types.keySet()) : (otherStruct.incompleteStruct ? !this.types.keySet().containsAll(otherStruct.types.keySet()) : !otherStruct.types.keySet().equals(this.types.keySet())));
            this.extensible = this.extensible || otherStruct.extensible || extendStruct;
            for (String fieldName : otherStruct.types.keySet()) {
                TLAType sType = otherStruct.types.get(fieldName);
                if (this.types.containsKey(fieldName)) {
                    TLAType res = this.types.get(fieldName).unify(sType);
                    this.types.put(fieldName, res);
                } else {
                    this.add(fieldName, sType);
                }
                this.incompleteStruct = false;
            }
            return this;
        }
        return this;
    }

    @Override
    public StructType cloneTLAType() {
        StructType clone = new StructType();
        this.types.forEach((field, type) -> clone.add((String)field, type.cloneTLAType()));
        return clone;
    }

    public List<String> getFields() {
        return new ArrayList<String>(this.types.keySet());
    }

    @Override
    public boolean contains(TLAType o) {
        return this.types.values().stream().anyMatch(bType -> bType.equals(o) || bType.contains(o));
    }

    public String toString() {
        if (this.types.isEmpty()) {
            return "struct(...)";
        }
        return "struct(" + this.types.entrySet().stream().map(entry -> (String)entry.getKey() + ":" + entry.getValue()).collect(Collectors.joining(",")) + ")";
    }

    @Override
    public PExpression getBNode() {
        ArrayList<PRecEntry> recList = new ArrayList<PRecEntry>();
        this.types.forEach((id, type) -> {
            PExpression value = this.extensible ? new APowSubsetExpression(new AMultOrCartExpression(new ABoolSetExpression(), type.getBNode())) : type.getBNode();
            recList.add(new ARecEntry(new TIdentifierLiteral((String)id), value));
        });
        return new AStructExpression(recList);
    }

    @Override
    public void apply(TypeVisitorInterface visitor) {
        visitor.caseStructType(this);
    }

    public Map<String, TLAType> getTypes() {
        return this.types;
    }
}

