/*
 * Decompiled with CFR 0.152.
 */
package de.tla2b.translation;

import de.tla2b.analysis.AbstractASTVisitor;
import de.tla2b.analysis.SpecAnalyser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import tla2sany.semantic.ExprNode;
import tla2sany.semantic.ExprOrOpArgNode;
import tla2sany.semantic.FormalParamNode;
import tla2sany.semantic.OpApplNode;
import tla2sany.semantic.OpDefNode;
import tla2sany.semantic.SemanticNode;
import tla2sany.semantic.SymbolNode;

public class RecursiveFunctionHandler
extends AbstractASTVisitor {
    private List<FormalParamNode> paramList;
    private List<FormalParamNode> ignoreParamList;
    private List<SymbolNode> externParams;
    private final Set<OpApplNode> recursiveFunctions = new HashSet<OpApplNode>();
    private final Map<SemanticNode, List<SymbolNode>> additionalParamsTable = new HashMap<SemanticNode, List<SymbolNode>>();

    public RecursiveFunctionHandler(SpecAnalyser specAnalyser) {
        for (OpDefNode recFunc : specAnalyser.getRecursiveFunctions()) {
            OpApplNode body = (OpApplNode)recFunc.getBody();
            this.recursiveFunctions.add(body);
            FormalParamNode[][] params = body.getBdedQuantSymbolLists();
            this.paramList = new ArrayList<FormalParamNode>();
            FormalParamNode self = body.getUnbdedQuantSymbols()[0];
            this.paramList.add(self);
            for (FormalParamNode[] param : params) {
                Collections.addAll(this.paramList, param);
            }
            this.externParams = new ArrayList<SymbolNode>();
            this.ignoreParamList = new ArrayList<FormalParamNode>();
            this.visitExprNode(recFunc.getBody());
            this.paramList = null;
            this.additionalParamsTable.put(body, this.externParams);
            this.additionalParamsTable.put(recFunc, this.externParams);
            this.additionalParamsTable.put(self, this.externParams);
        }
    }

    @Override
    public void visitFormalParamNode(OpApplNode n) {
        FormalParamNode param = (FormalParamNode)n.getOperator();
        if (!this.paramList.contains(param) && !this.ignoreParamList.contains(param)) {
            this.externParams.add(param);
        }
    }

    @Override
    public void visitVariableNode(OpApplNode n) {
        this.externParams.add(n.getOperator());
    }

    public List<SymbolNode> getAdditionalParams(SemanticNode n) {
        return this.additionalParamsTable.get(n);
    }

    public boolean isRecursiveFunction(SemanticNode n) {
        return this.additionalParamsTable.containsKey(n);
    }

    @Override
    public void visitBuiltInNode(OpApplNode n) {
        switch (RecursiveFunctionHandler.getOpCode(n.getOperator().getName())) {
            case 1: 
            case 2: 
            case 3: 
            case 10: 
            case 12: 
            case 16: 
            case 19: 
            case 22: {
                HashSet set = new HashSet();
                for (FormalParamNode[] formalParamNodeArray : n.getBdedQuantSymbolLists()) {
                    Collections.addAll(set, formalParamNodeArray);
                }
                this.ignoreParamList.addAll(set);
                for (FormalParamNode[] formalParamNodeArray : n.getBdedQuantBounds()) {
                    this.visitExprNode((ExprNode)formalParamNodeArray);
                }
                for (FormalParamNode[] formalParamNodeArray : n.getArgs()) {
                    this.visitExprOrOpArgNode((ExprOrOpArgNode)formalParamNodeArray);
                }
                return;
            }
        }
        super.visitBuiltInNode(n);
    }
}

