/*
 * Decompiled with CFR 0.152.
 */
package de.tla2b.translation;

import de.tla2b.analysis.AbstractASTVisitor;
import de.tla2b.analysis.BOperation;
import de.tla2b.analysis.SpecAnalyser;
import de.tla2b.global.BBuildIns;
import de.tla2b.global.BBuiltInOPs;
import de.tla2b.util.DebugUtils;
import java.util.ArrayList;
import java.util.List;
import tla2sany.semantic.ExprNode;
import tla2sany.semantic.LetInNode;
import tla2sany.semantic.OpApplNode;
import tla2sany.semantic.OpDefNode;
import tlc2.tool.BuiltInOPs;
import util.UniqueString;

public class OperationsFinder
extends AbstractASTVisitor {
    private final SpecAnalyser specAnalyser;
    private String currentName;
    private List<OpApplNode> exists;
    private final List<BOperation> bOperations;
    private final List<String> generatedOperations = new ArrayList<String>();

    public OperationsFinder(SpecAnalyser specAnalyser) {
        this.specAnalyser = specAnalyser;
        this.bOperations = new ArrayList<BOperation>();
        if (specAnalyser.getNext() != null) {
            this.currentName = "Next";
            this.exists = new ArrayList<OpApplNode>();
            this.visitExprNode(specAnalyser.getNext());
        }
    }

    @Override
    public void visitExprNode(ExprNode n) {
        switch (n.getKind()) {
            case 9: {
                this.visitOpApplNode((OpApplNode)n);
                return;
            }
            case 16: 
            case 17: {
                throw new RuntimeException(String.format("Expected an action (instead of a number).%n%s", n.getLocation().toString()));
            }
            case 18: {
                throw new RuntimeException(String.format("Expected an action (instead of a string).%n%s", n.getLocation().toString()));
            }
            case 13: 
            case 19: {
                throw new RuntimeException(String.format("Expected an action.%n%s", n.getLocation().toString()));
            }
            case 10: {
                this.visitExprNode(((LetInNode)n).getBody());
            }
        }
    }

    @Override
    public void visitUserDefinedNode(OpApplNode n) {
        OpDefNode def = (OpDefNode)n.getOperator();
        if (BBuiltInOPs.contains(def.getName())) {
            this.addOperation(def.getName().toString(), n, this.exists, this.specAnalyser);
            return;
        }
        for (int i = 0; i < def.getParams().length; ++i) {
            def.getParams()[i].setToolObject(29, n.getArgs()[i]);
        }
        this.currentName = def.getName().toString();
        this.visitExprNode(def.getBody());
    }

    @Override
    public void visitBuiltInNode(OpApplNode n) {
        UniqueString opname = n.getOperator().getName();
        int opcode = BuiltInOPs.getOpCode(opname);
        DebugUtils.printDebugMsg("OPCODE of " + opname + " = " + opcode);
        switch (opcode) {
            case 7: {
                if (n.getArgs().length == 1) {
                    this.visitExprOrOpArgNode(n.getArgs()[0]);
                } else {
                    this.visitArgs(n);
                }
                return;
            }
            case 37: {
                this.visitArgs(n);
                return;
            }
            case 2: {
                this.exists.add(n);
                this.visitExprOrOpArgNode(n.getArgs()[0]);
                return;
            }
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 11: 
            case 27: 
            case 28: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 49: {
                this.addOperation(this.currentName, n, this.exists, this.specAnalyser);
                return;
            }
        }
        if (opname == BBuildIns.OP_false || opname == BBuildIns.OP_true) {
            this.addOperation(this.currentName, n, this.exists, this.specAnalyser);
            return;
        }
        throw new RuntimeException(String.format("Expected an action at '%s':%n%s", opname, n.getLocation()));
    }

    private void visitArgs(OpApplNode n) {
        String oldName = this.currentName;
        ArrayList<OpApplNode> oldExists = new ArrayList<OpApplNode>(this.exists);
        for (int i = 0; i < n.getArgs().length; ++i) {
            this.exists = new ArrayList<OpApplNode>(oldExists);
            this.currentName = oldName + i;
            this.visitExprOrOpArgNode(n.getArgs()[i]);
        }
    }

    private void addOperation(String name, OpApplNode node, List<OpApplNode> exists, SpecAnalyser specAnalyser) {
        if (!this.generatedOperations.contains(name)) {
            this.bOperations.add(new BOperation(name, node, exists, specAnalyser));
            this.generatedOperations.add(name);
            return;
        }
        DebugUtils.printMsg("Duplicate operation not translated: " + name);
    }

    public List<BOperation> getBOperations() {
        return this.bOperations;
    }
}

