/*
 * Decompiled with CFR 0.152.
 */
package de.prob.prolog.term;

import de.prob.prolog.output.IPrologTermOutput;
import de.prob.prolog.term.PrologTerm;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;

public final class ListPrologTerm
extends PrologTerm
implements List<PrologTerm> {
    private static final ListPrologTerm EMPTY_LIST = new ListPrologTerm(null, 0, 0);
    private final PrologTerm[] elements;
    private final int start;
    private final int end;

    public ListPrologTerm(PrologTerm ... elements) {
        this.elements = elements != null && elements.length > 0 ? elements : null;
        this.start = 0;
        this.end = elements != null ? elements.length : 0;
    }

    private ListPrologTerm(PrologTerm[] elements, int start, int end) {
        this.elements = elements;
        this.start = start;
        this.end = end;
    }

    public static ListPrologTerm fromCollection(Collection<? extends PrologTerm> elements) {
        if (elements == null || elements.isEmpty()) {
            return EMPTY_LIST;
        }
        return new ListPrologTerm(elements.toArray(new PrologTerm[0]));
    }

    public static ListPrologTerm emptyList() {
        return EMPTY_LIST;
    }

    @Override
    public String getFunctor() {
        return this.isEmpty() ? "[]" : ".";
    }

    @Override
    public int getArity() {
        return this.isEmpty() ? 0 : 2;
    }

    @Override
    public boolean isAtom() {
        return this.isEmpty();
    }

    @Override
    public boolean isCompound() {
        return !this.isAtom();
    }

    @Override
    public boolean isList() {
        return true;
    }

    @Override
    public PrologTerm getArgument(int index) {
        if (this.isEmpty()) {
            throw new IndexOutOfBoundsException("List has no arguments");
        }
        if (index == 1) {
            return this.head();
        }
        if (index == 2) {
            return this.tail();
        }
        throw new IndexOutOfBoundsException("Argument index out of bounds");
    }

    @Override
    public boolean hasFunctor(String functor) {
        return this.isEmpty() ? "[]".equals(functor) : ".".equals(functor) || "[|]".equals(functor);
    }

    @Override
    public int size() {
        return this.end - this.start;
    }

    @Override
    public PrologTerm get(int index) {
        int i = index + this.start;
        if (i < this.start || i >= this.end) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.elements[i];
    }

    @Override
    public void toTermOutput(IPrologTermOutput pto) {
        if (this.isEmpty()) {
            pto.emptyList();
        } else {
            pto.openList();
            for (PrologTerm t : this) {
                t.toTermOutput(pto);
            }
            pto.closeList();
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof List)) {
            return false;
        }
        List other = (List)obj;
        if (this.size() != other.size()) {
            return false;
        }
        Iterator<PrologTerm> e1 = this.iterator();
        Iterator e2 = other.iterator();
        while (e1.hasNext() && e2.hasNext()) {
            Object o2;
            PrologTerm o1 = e1.next();
            if (Objects.equals(o1, o2 = e2.next())) continue;
            return false;
        }
        return !e1.hasNext() && !e2.hasNext();
    }

    @Override
    public int hashCode() {
        int result = 1;
        for (int i = this.start; i < this.end; ++i) {
            result = 31 * result + this.elements[i].hashCode();
        }
        return result;
    }

    @Override
    public Iterator<PrologTerm> iterator() {
        return this.listIterator();
    }

    @Override
    public boolean add(PrologTerm o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends PrologTerm> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Object o) {
        for (PrologTerm t : this) {
            if (!Objects.equals(t, o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toArray() {
        if (this.isEmpty()) {
            return new PrologTerm[0];
        }
        return Arrays.copyOfRange(this.elements, this.start, this.end);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        int size = this.size();
        if (a.length < size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        }
        if (size > 0) {
            System.arraycopy(this.elements, 0, a, 0, size);
        }
        if (a.length > size) {
            a[size] = null;
        }
        return a;
    }

    @Override
    public void add(int index, PrologTerm element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends PrologTerm> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int indexOf(Object object) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (!Objects.equals(this.get(i), object)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object object) {
        for (int i = this.size() - 1; i >= 0; --i) {
            if (!Objects.equals(this.get(i), object)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public ListIterator<PrologTerm> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<PrologTerm> listIterator(int index) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        return new PrologTermListIterator(index);
    }

    @Override
    public PrologTerm remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public PrologTerm set(int index, PrologTerm element) {
        throw new UnsupportedOperationException();
    }

    public ListPrologTerm subList(int fromIndex, int toIndex) {
        if (fromIndex < 0 || toIndex > this.size() || fromIndex > toIndex) {
            throw new IndexOutOfBoundsException();
        }
        if (fromIndex == toIndex) {
            return EMPTY_LIST;
        }
        return new ListPrologTerm(this.elements, this.start + fromIndex, this.start + toIndex);
    }

    public ListPrologTerm tail() {
        return this.tail(1);
    }

    public ListPrologTerm tail(int start) {
        if (start == 0) {
            return this;
        }
        if (start < 0) {
            throw new IllegalArgumentException("start must be non-negative");
        }
        int size = this.size();
        if (size < start) {
            throw new IllegalStateException("Cannot call tail on an empty list");
        }
        if (size == start) {
            return EMPTY_LIST;
        }
        return new ListPrologTerm(this.elements, this.start + start, this.end);
    }

    public PrologTerm head() {
        if (this.isEmpty()) {
            throw new IllegalStateException("Cannot call head on an empty list");
        }
        return this.get(0);
    }

    private final class PrologTermListIterator
    implements ListIterator<PrologTerm> {
        private int cursor;

        PrologTermListIterator(int cursor) {
            this.cursor = cursor;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < ListPrologTerm.this.size();
        }

        @Override
        public PrologTerm next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            PrologTerm term = ListPrologTerm.this.get(this.cursor);
            ++this.cursor;
            return term;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor > 0;
        }

        @Override
        public PrologTerm previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            --this.cursor;
            return ListPrologTerm.this.get(this.cursor);
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(PrologTerm t) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(PrologTerm t) {
            throw new UnsupportedOperationException();
        }
    }
}

