/*
 * Decompiled with CFR 0.152.
 */
package de.prob.prolog.term;

import de.prob.prolog.output.IPrologTermOutput;
import de.prob.prolog.term.AIntegerPrologTerm;
import java.math.BigInteger;

public final class IntegerLongPrologTerm
extends AIntegerPrologTerm {
    private final long value;

    @Deprecated
    public IntegerLongPrologTerm(long value) {
        this.value = value;
    }

    @Override
    public String getFunctor() {
        return Long.toString(this.value);
    }

    @Override
    public BigInteger getValue() {
        return BigInteger.valueOf(this.value);
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public int intValueExact() {
        return Math.toIntExact(this.value);
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public long longValueExact() {
        return this.value;
    }

    @Override
    public void toTermOutput(IPrologTermOutput pto) {
        pto.printNumber(this.value);
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof IntegerLongPrologTerm) {
            return this.value == ((IntegerLongPrologTerm)other).value;
        }
        return super.equals(other);
    }

    @Override
    public int hashCode() {
        boolean neg;
        long v = this.value;
        boolean bl = neg = v < 0L;
        if (neg) {
            v = -v;
        }
        int h = (int)(v >>> 32);
        int hash = (int)((long)(31 * h) + (v & 0xFFFFFFFFL));
        return neg ? -hash : hash;
    }
}

