/*
 * Decompiled with CFR 0.152.
 */
package de.prob.prolog.term;

import de.prob.prolog.output.IPrologTermOutput;
import de.prob.prolog.term.PrologTerm;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;

public final class CompoundPrologTerm
extends PrologTerm {
    private final String functor;
    private final PrologTerm[] arguments;

    public CompoundPrologTerm(String functor, PrologTerm ... arguments) {
        this.functor = Objects.requireNonNull(functor, "functor");
        this.arguments = arguments != null && arguments.length > 0 ? arguments : null;
    }

    public CompoundPrologTerm(String atom) {
        this(atom, null);
    }

    public static CompoundPrologTerm fromCollection(String functor, Collection<? extends PrologTerm> arguments) {
        PrologTerm[] arr = arguments != null && !arguments.isEmpty() ? arguments.toArray(new PrologTerm[0]) : null;
        return new CompoundPrologTerm(functor, arr);
    }

    @Override
    public String getFunctor() {
        return this.functor;
    }

    @Override
    public int getArity() {
        return this.arguments == null ? 0 : this.arguments.length;
    }

    @Override
    public boolean isAtom() {
        return this.arguments == null || this.arguments.length == 0;
    }

    @Override
    @Deprecated
    public boolean isTerm() {
        return true;
    }

    @Override
    public boolean isCompound() {
        return !this.isAtom();
    }

    @Override
    public PrologTerm getArgument(int index) {
        if (this.isAtom()) {
            throw new IndexOutOfBoundsException("Atom " + this.functor + " has no arguments");
        }
        return this.arguments[index - 1];
    }

    @Override
    public void toTermOutput(IPrologTermOutput pto) {
        if (this.isAtom()) {
            pto.printAtom(this.functor);
        } else {
            pto.openTerm(this.functor);
            for (PrologTerm argument : this.arguments) {
                argument.toTermOutput(pto);
            }
            pto.closeTerm();
        }
    }

    @Override
    public boolean hasFunctor(String functor) {
        return this.functor.equals(functor);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CompoundPrologTerm)) {
            return false;
        }
        CompoundPrologTerm other = (CompoundPrologTerm)obj;
        return this.functor.equals(other.functor) && (Arrays.equals(this.arguments, other.arguments) || this.arguments == null && other.arguments.length == 0 || this.arguments != null && this.arguments.length == 0 && other.arguments == null);
    }

    public int hashCode() {
        return 31 * this.functor.hashCode() + Arrays.hashCode(this.arguments);
    }
}

