/*
 * Decompiled with CFR 0.152.
 */
package de.prob.prolog.output;

import de.prob.prolog.output.FastSicstusTermOutput;
import de.prob.prolog.output.FastSwiTermOutput;
import de.prob.prolog.term.PrologTerm;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.Objects;

@Deprecated
public final class FastReadWriter {
    private final PrologSystem flavor;
    private final OutputStream out;
    private int wordBytes;
    private ByteOrder endianness;
    private boolean windows;
    private boolean allowWAtom;
    private Charset cachedWAtomCharset;

    public FastReadWriter(PrologSystem flavor, OutputStream out) {
        this.flavor = Objects.requireNonNull(flavor, "flavor");
        this.out = Objects.requireNonNull(out, "out");
        this.wordBytes = FastReadWriter.is64Bit() ? 8 : 4;
        this.endianness = ByteOrder.nativeOrder();
        this.windows = System.getProperty("os.name", "").toLowerCase(Locale.ROOT).contains("windows");
        this.allowWAtom = true;
        this.cachedWAtomCharset = null;
    }

    public FastReadWriter(OutputStream out) {
        this(PrologSystem.SICSTUS, out);
    }

    public FastReadWriter withWAtomSupport() {
        this.allowWAtom = true;
        this.cachedWAtomCharset = null;
        return this;
    }

    public FastReadWriter withoutWAtomSupport() {
        this.allowWAtom = false;
        this.cachedWAtomCharset = null;
        return this;
    }

    public FastReadWriter withWAtomCharset(Charset charset) {
        this.cachedWAtomCharset = charset;
        return this;
    }

    public FastReadWriter withTarget64bit() {
        this.wordBytes = 8;
        this.cachedWAtomCharset = null;
        return this;
    }

    public FastReadWriter withTarget32bit() {
        this.wordBytes = 4;
        this.cachedWAtomCharset = null;
        return this;
    }

    public FastReadWriter withTargetBigEndian() {
        this.endianness = ByteOrder.BIG_ENDIAN;
        this.cachedWAtomCharset = null;
        return this;
    }

    public FastReadWriter withTargetLittleEndian() {
        this.endianness = ByteOrder.LITTLE_ENDIAN;
        this.cachedWAtomCharset = null;
        return this;
    }

    public FastReadWriter withTargetWindows() {
        this.windows = true;
        return this;
    }

    public FastReadWriter withTargetNoWindows() {
        this.windows = false;
        return this;
    }

    public void fastwrite(PrologTerm term) throws IOException {
        switch (this.flavor) {
            case SICSTUS: {
                this.writeTermSicstus(term);
                break;
            }
            case SWI: {
                this.writeTermSWI(term);
                break;
            }
            default: {
                throw new AssertionError((Object)("unknown prolog system: " + (Object)((Object)this.flavor)));
            }
        }
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    private void writeTermSicstus(PrologTerm term) {
        FastSicstusTermOutput to = new FastSicstusTermOutput(this.out);
        to.printTerm(term);
        to.fullstop();
    }

    private void writeTermSWI(PrologTerm term) {
        FastSwiTermOutput to = new FastSwiTermOutput(this.out);
        if (this.wordBytes == 4) {
            to.withTarget32bit();
        } else if (this.wordBytes == 8) {
            to.withTarget64bit();
        } else {
            throw new AssertionError();
        }
        if (this.endianness == ByteOrder.BIG_ENDIAN) {
            to.withTargetBigEndian();
        } else if (this.endianness == ByteOrder.LITTLE_ENDIAN) {
            to.withTargetLittleEndian();
        } else {
            throw new AssertionError();
        }
        if (this.windows) {
            to.withTargetWindows();
        } else {
            to.withTargetNoWindows();
        }
        if (this.allowWAtom) {
            to.withWAtomSupport();
        } else {
            to.withoutWAtomSupport();
        }
        to.withWAtomCharset(this.cachedWAtomCharset);
        to.printTerm(term);
        to.fullstop();
    }

    private static boolean is64Bit() {
        String bits = System.getProperty("sun.arch.data.model", System.getProperty("com.ibm.vm.bitmode", System.getProperty("os.arch", "")));
        return bits.contains("64");
    }

    @Deprecated
    public static enum PrologSystem {
        SICSTUS,
        SWI;

    }
}

