/*
 * Decompiled with CFR 0.152.
 */
package de.be4.classicalb.core.parser.util;

import de.be4.classicalb.core.parser.BParser;
import de.be4.classicalb.core.parser.exceptions.BCompoundException;
import de.be4.classicalb.core.parser.node.AAbstractMachineParseUnit;
import de.be4.classicalb.core.parser.node.AExpressionParseUnit;
import de.be4.classicalb.core.parser.node.AIdentifierExpression;
import de.be4.classicalb.core.parser.node.AImplementationMachineParseUnit;
import de.be4.classicalb.core.parser.node.APackageParseUnit;
import de.be4.classicalb.core.parser.node.ARefinementMachineParseUnit;
import de.be4.classicalb.core.parser.node.PExpression;
import de.be4.classicalb.core.parser.node.PParseUnit;
import de.be4.classicalb.core.parser.node.Start;
import de.be4.classicalb.core.parser.node.TIdentifierLiteral;
import de.be4.classicalb.core.parser.node.Token;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public final class Utils {
    private static final Set<String> AMBIGUOUS_KEYWORDS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("tree", "btree", "const", "top", "sons", "prefix", "postfix", "sizet", "mirror", "rank", "father", "son", "subtree", "arity", "bin", "left", "right", "infix")));
    private static final Map<Character, Character> STRING_ESCAPE_REPLACEMENTS;
    private static final Map<Character, Character> STRING_ESCAPE_REPLACEMENTS_REVERSE;

    private Utils() {
    }

    public static String getAIdentifierAsString(AIdentifierExpression idExpr) {
        return Utils.getTIdentifierListAsString(idExpr.getIdentifier());
    }

    public static String getTIdentifierListAsString(List<TIdentifierLiteral> idElements) {
        if (idElements.size() == 1) {
            return idElements.get(0).getText();
        }
        return idElements.stream().map(Token::getText).collect(Collectors.joining("."));
    }

    public static boolean isAmbiguousKeyword(String identifier) {
        return AMBIGUOUS_KEYWORDS.contains(identifier);
    }

    public static boolean isPlainBIdentifier(String identifier) {
        Start ast;
        if (Utils.isAmbiguousKeyword(identifier)) {
            return false;
        }
        try {
            ast = new BParser().parseExpression(identifier);
        }
        catch (BCompoundException ignored) {
            return false;
        }
        PExpression expr = ((AExpressionParseUnit)ast.getPParseUnit()).getExpression();
        if (!(expr instanceof AIdentifierExpression)) {
            return false;
        }
        LinkedList<TIdentifierLiteral> parsedId = ((AIdentifierExpression)expr).getIdentifier();
        return parsedId.size() == 1 && identifier.equals(((TIdentifierLiteral)parsedId.get(0)).getText());
    }

    public static boolean isProBSpecialDefinitionName(String identifier) {
        return "GOAL".equals(identifier) || "SHIELD_INTERVENTION".equals(identifier) || "VISB_JSON_FILE".equals(identifier) || "VISB_DEFINITIONS_FILE".equals(identifier) || "VISB_SVG_FILE".equals(identifier) || identifier.startsWith("ANIMATION_") || identifier.startsWith("ASSERT_CTL") || identifier.startsWith("ASSERT_LTL") || identifier.equals("CUSTOM_GRAPH") || identifier.startsWith("CUSTOM_GRAPH_") || identifier.startsWith("FORCE_SYMMETRY_") || identifier.startsWith("GAME_") || identifier.startsWith("HEURISTIC_FUNCTION") || identifier.startsWith("MAX_OPERATIONS_") || identifier.startsWith("OPERATION_REUSE_OFF_") || identifier.equals("PROB_REQUIRED_VERSION") || identifier.equals("SCOPE") || identifier.startsWith("scope_") || identifier.startsWith("SET_PREF_") || identifier.startsWith("SEQUENCE_CHART_") || identifier.startsWith("VISB_SVG_");
    }

    public static boolean isCompleteMachine(Start rootNode) {
        PParseUnit parseUnit = rootNode.getPParseUnit();
        return parseUnit instanceof AAbstractMachineParseUnit || parseUnit instanceof ARefinementMachineParseUnit || parseUnit instanceof AImplementationMachineParseUnit || parseUnit instanceof APackageParseUnit;
    }

    public static <T> List<T> sortByTopologicalOrder(Map<T, Set<T>> dependencies) {
        HashSet<T> allValues = new HashSet<T>(dependencies.keySet());
        ArrayList<T> sortedList = new ArrayList<T>();
        boolean newRun = true;
        while (newRun) {
            newRun = false;
            ArrayList<T> todo = new ArrayList<T>(allValues);
            todo.removeAll(sortedList);
            for (T element : todo) {
                HashSet deps = new HashSet(dependencies.get(element));
                deps.removeAll(sortedList);
                if (!deps.isEmpty()) continue;
                sortedList.add(element);
                newRun = true;
            }
        }
        return sortedList;
    }

    public static <T> List<T> determineCycle(Set<T> remaining, Map<T, Set<T>> dependencies) {
        ArrayList cycle = new ArrayList();
        HashSet<Object> set = new HashSet<T>(remaining);
        boolean newRun = true;
        block0: while (newRun) {
            for (Object next : set) {
                if (cycle.contains(next)) {
                    newRun = false;
                    cycle.add(next);
                    continue block0;
                }
                if (!remaining.contains(next)) continue;
                cycle.add(next);
                set = new HashSet(dependencies.get(next));
                continue block0;
            }
        }
        return cycle;
    }

    public static String getFileWithoutExtension(String f) {
        int i = f.lastIndexOf(46);
        if (i > 0 && i < f.length() - 1) {
            return f.substring(0, i);
        }
        return f;
    }

    public static String readFile(File filePath) throws IOException {
        return Utils.readFile(filePath.toPath());
    }

    private static String readFile(Path filePath) throws IOException {
        byte[] bytes = Files.readAllBytes(filePath);
        int length = bytes.length;
        int offset = 0;
        if (length >= 3 && bytes[0] == -17 && bytes[1] == -69 && bytes[2] == -65) {
            offset = 3;
            length -= 3;
        }
        return new String(bytes, offset, length, StandardCharsets.UTF_8);
    }

    public static boolean isQuoted(String string, char quote) {
        return string.length() >= 2 && string.charAt(0) == quote && string.charAt(string.length() - 1) == quote;
    }

    public static String removeSurroundingQuotes(String literal, char quote) {
        if (!Utils.isQuoted(literal, quote)) {
            throw new IllegalArgumentException(String.format("removeSurroundingQuotes argument must be a quoted string: %c...%c", Character.valueOf(quote), Character.valueOf(quote)));
        }
        return literal.substring(1, literal.length() - 1);
    }

    public static String unescapeStringContents(String contents) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        int len = contents.length();
        while (i < len) {
            char c = contents.charAt(i);
            if (c == '\\') {
                if (i + 1 >= len) {
                    throw new IllegalArgumentException("Unescaped backslash at end of string not allowed");
                }
                char escapedChar = contents.charAt(i + 1);
                if (STRING_ESCAPE_REPLACEMENTS.containsKey(Character.valueOf(escapedChar))) {
                    sb.append(STRING_ESCAPE_REPLACEMENTS.get(Character.valueOf(escapedChar)));
                } else {
                    sb.append('\\');
                    sb.append(escapedChar);
                }
                i += 2;
                continue;
            }
            if (c == '\r') {
                sb.append('\n');
                if (i + 1 < len && contents.charAt(i + 1) == '\n') {
                    i += 2;
                    continue;
                }
                ++i;
                continue;
            }
            sb.append(c);
            ++i;
        }
        return sb.toString();
    }

    public static String escapeStringContents(String contents) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < contents.length(); ++i) {
            char c = contents.charAt(i);
            if (STRING_ESCAPE_REPLACEMENTS_REVERSE.containsKey(Character.valueOf(c))) {
                sb.append('\\');
                sb.append(STRING_ESCAPE_REPLACEMENTS_REVERSE.get(Character.valueOf(c)));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String unquotePragmaIdentifier(String text) {
        if (Utils.isQuoted(text, '\"')) {
            return Utils.unescapeStringContents(Utils.removeSurroundingQuotes(text, '\"'));
        }
        return text;
    }

    public static String unquoteIdentifier(String name) {
        if (Utils.isQuoted(name, '`')) {
            if (name.indexOf(46) != -1) {
                String fixed = name.replace(".", "`.`");
                throw new IllegalArgumentException("A quoted identifier cannot contain a dot. Please quote only the identifiers before and after the dot, but not the dot itself, e. g.: " + fixed);
            }
            return Utils.unescapeStringContents(Utils.removeSurroundingQuotes(name, '`'));
        }
        return name;
    }

    static {
        HashMap<Character, Character> stringEscapeReplacements = new HashMap<Character, Character>();
        stringEscapeReplacements.put(Character.valueOf('\"'), Character.valueOf('\"'));
        stringEscapeReplacements.put(Character.valueOf('\''), Character.valueOf('\''));
        stringEscapeReplacements.put(Character.valueOf('n'), Character.valueOf('\n'));
        stringEscapeReplacements.put(Character.valueOf('r'), Character.valueOf('\r'));
        stringEscapeReplacements.put(Character.valueOf('t'), Character.valueOf('\t'));
        stringEscapeReplacements.put(Character.valueOf('\\'), Character.valueOf('\\'));
        STRING_ESCAPE_REPLACEMENTS = Collections.unmodifiableMap(stringEscapeReplacements);
        HashMap stringEscapeReplacementsReverse = new HashMap();
        for (Map.Entry entry : stringEscapeReplacements.entrySet()) {
            stringEscapeReplacementsReverse.put(entry.getValue(), entry.getKey());
        }
        STRING_ESCAPE_REPLACEMENTS_REVERSE = Collections.unmodifiableMap(stringEscapeReplacementsReverse);
    }
}

