/*
 * Decompiled with CFR 0.152.
 */
package de.prob.prolog.output;

import de.prob.prolog.output.IPrologTermOutput;
import de.prob.prolog.output.ModifiableByteBuffer;
import de.prob.prolog.term.PrologTerm;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;

public final class FastSicstusTermOutput
implements IPrologTermOutput {
    private static final BigInteger BI_255 = BigInteger.valueOf(255L);
    private final OutputStream out;
    private final Map<String, Integer> varCache;
    private final Deque<TermContext> termStack;
    private final ModifiableByteBuffer buffer;
    private boolean inAsciiList;

    public FastSicstusTermOutput(OutputStream out) {
        this.out = out;
        this.varCache = new HashMap<String, Integer>();
        this.termStack = new ArrayDeque<TermContext>();
        this.buffer = new ModifiableByteBuffer();
        this.inAsciiList = false;
    }

    private void handleTerm() {
        TermContext ctx;
        if (this.inAsciiList) {
            this.buffer.write(0);
            this.inAsciiList = false;
        }
        if ((ctx = this.termStack.peek()) instanceof ListContext) {
            this.buffer.write(91);
        } else if (ctx instanceof CompoundContext) {
            CompoundContext c = (CompoundContext)ctx;
            if (c.arity() == 0) {
                this.buffer.write(83);
                this.buffer.writeNullTerminatedString(c.functor());
                c.setArityPos(this.buffer.size());
                this.buffer.write(0);
            }
            ((CompoundContext)ctx).increaseArity();
        }
    }

    @Override
    public IPrologTermOutput openTerm(String functor, boolean ignoreIndentation) {
        this.handleTerm();
        this.termStack.push(new CompoundContext(functor));
        return this;
    }

    @Override
    public IPrologTermOutput closeTerm() {
        CompoundContext ctx = (CompoundContext)this.termStack.pop();
        int arity = ctx.arity();
        if (arity < 0 || arity > 255) {
            throw new IllegalArgumentException("invalid arity for compound term: " + arity);
        }
        if (arity == 0) {
            this.buffer.write(65);
            this.buffer.writeNullTerminatedString(ctx.functor());
        } else {
            this.buffer.set(ctx.arityPos(), arity);
        }
        return this;
    }

    @Override
    public IPrologTermOutput printAtom(String content) {
        this.handleTerm();
        this.buffer.write(65);
        this.buffer.writeNullTerminatedString(content);
        return this;
    }

    @Override
    public IPrologTermOutput printString(String content) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IPrologTermOutput printNumber(long number) {
        if (this.termStack.peek() instanceof ListContext && 0L < number && number <= 255L) {
            if (!this.inAsciiList) {
                this.buffer.write(34);
                this.inAsciiList = true;
            }
            this.buffer.write((byte)number);
        } else {
            this.handleTerm();
            this.buffer.write(73);
            this.buffer.writeNullTerminatedString(String.valueOf(number));
        }
        return this;
    }

    @Override
    public IPrologTermOutput printNumber(BigInteger number) {
        if (this.termStack.peek() instanceof ListContext && number.signum() > 0 && number.compareTo(BI_255) <= 0) {
            if (!this.inAsciiList) {
                this.buffer.write(34);
                this.inAsciiList = true;
            }
            this.buffer.write(number.intValue());
        } else {
            this.handleTerm();
            this.buffer.write(73);
            this.buffer.writeNullTerminatedString(number.toString());
        }
        return this;
    }

    @Override
    public IPrologTermOutput printNumber(double number) {
        this.handleTerm();
        this.buffer.write(70);
        this.buffer.writeNullTerminatedString(String.valueOf(number));
        return this;
    }

    @Override
    public IPrologTermOutput openList() {
        this.handleTerm();
        this.termStack.push(ListContext.INSTANCE);
        return this;
    }

    @Override
    public IPrologTermOutput closeList() {
        ListContext _ctx = (ListContext)this.termStack.pop();
        if (this.inAsciiList) {
            this.buffer.write(0);
            this.inAsciiList = false;
        }
        this.buffer.write(93);
        return this;
    }

    @Override
    public IPrologTermOutput tailSeparator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IPrologTermOutput printVariable(String var) {
        this.handleTerm();
        this.buffer.write(95);
        int index = this.varCache.computeIfAbsent(var, k -> this.varCache.size());
        this.buffer.writeNullTerminatedString(String.valueOf(index));
        return this;
    }

    @Override
    public IPrologTermOutput printTerm(PrologTerm term) {
        term.toTermOutput(this);
        return this;
    }

    @Override
    public IPrologTermOutput flush() {
        try {
            this.out.flush();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return this;
    }

    @Override
    public IPrologTermOutput fullstop() {
        if (!this.termStack.isEmpty()) {
            throw new IllegalStateException(this.termStack.size() + " unclosed term(s) or list(s)");
        }
        try {
            this.out.write(68);
            this.out.write(this.buffer.bytes(), 0, this.buffer.size());
            this.out.flush();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.reset();
        return this;
    }

    public void reset() {
        this.varCache.clear();
        this.buffer.reset();
        this.inAsciiList = false;
    }

    private static final class CompoundContext
    extends TermContext {
        private final String functor;
        private int arityPos;
        private int arity;

        CompoundContext(String functor) {
            this.functor = functor;
            this.arity = 0;
        }

        String functor() {
            return this.functor;
        }

        int arityPos() {
            return this.arityPos;
        }

        void setArityPos(int arityPos) {
            this.arityPos = arityPos;
        }

        void increaseArity() {
            ++this.arity;
        }

        int arity() {
            return this.arity;
        }
    }

    private static final class ListContext
    extends TermContext {
        static final ListContext INSTANCE = new ListContext();

        private ListContext() {
        }
    }

    private static abstract class TermContext {
        private TermContext() {
        }
    }
}

