/*
 * Decompiled with CFR 0.152.
 */
package de.prob.prolog.match;

import de.prob.prolog.match.PrologMatch;
import de.prob.prolog.term.CompoundPrologTerm;
import de.prob.prolog.term.PrologTerm;
import java.util.Arrays;
import java.util.Map;

public final class PrologTermMatch
extends PrologMatch {
    private final String functor;
    private final int arity;
    private final PrologMatch[] args;

    private PrologTermMatch(String name, String functor, int arity, PrologMatch[] args) {
        super(name);
        if (args != null && args.length != arity) {
            throw new IllegalArgumentException("wanted arity is inconsistent with wanted args");
        }
        this.functor = functor;
        this.arity = arity;
        this.args = args != null ? Arrays.copyOf(args, args.length) : null;
    }

    public static PrologTermMatch anonTerm() {
        return PrologTermMatch.namedTerm(null);
    }

    public static PrologTermMatch anonTerm(String functor) {
        return PrologTermMatch.namedTerm(null, functor);
    }

    public static PrologTermMatch anonTerm(String functor, PrologMatch ... args) {
        return PrologTermMatch.namedTerm(null, functor, args);
    }

    public static PrologTermMatch anonTerm(String functor, int arity) {
        return PrologTermMatch.namedTerm(null, functor, arity);
    }

    public static PrologTermMatch anonAtom(String functor) {
        return PrologTermMatch.namedAtom(null, functor);
    }

    public static PrologTermMatch namedTerm(String name) {
        return PrologTermMatch.namedTerm(name, null);
    }

    public static PrologTermMatch namedTerm(String name, String functor) {
        return PrologTermMatch.namedTerm(name, functor, -1);
    }

    public static PrologTermMatch namedTerm(String name, String functor, PrologMatch ... args) {
        return new PrologTermMatch(name, functor, args != null ? args.length : -1, args);
    }

    public static PrologTermMatch namedTerm(String name, String functor, int arity) {
        return new PrologTermMatch(name, functor, arity, null);
    }

    public static PrologTermMatch namedAtom(String name, String functor) {
        return PrologTermMatch.namedTerm(name, functor, 0);
    }

    @Override
    protected boolean isMatch(PrologTerm term, Map<String, PrologTerm> hits) {
        if (term instanceof CompoundPrologTerm) {
            CompoundPrologTerm compound = (CompoundPrologTerm)term;
            return (this.arity < 0 || compound.getArity() == this.arity) && (this.functor == null || this.functor.equals(compound.getFunctor())) && this.args == null || this.allArgsMatch(compound, hits);
        }
        return false;
    }

    private boolean allArgsMatch(CompoundPrologTerm term, Map<String, PrologTerm> hits) {
        for (int i = 0; i < this.arity; ++i) {
            PrologMatch argMatch = this.args[i];
            if (argMatch == null || argMatch.matches(term.getArgument(i + 1), hits)) continue;
            return false;
        }
        return true;
    }
}

