/*
 * Decompiled with CFR 0.152.
 */
package de.be4.classicalb.core.parser.grammars;

import de.be4.classicalb.core.parser.grammars.IGrammar;
import de.be4.classicalb.core.parser.node.TIdentifierLiteral;
import de.be4.classicalb.core.parser.node.TKwAttributeIdentifier;
import de.be4.classicalb.core.parser.node.TKwBody;
import de.be4.classicalb.core.parser.node.TKwComputation;
import de.be4.classicalb.core.parser.node.TKwCounterexample;
import de.be4.classicalb.core.parser.node.TKwDefine;
import de.be4.classicalb.core.parser.node.TKwDummyValue;
import de.be4.classicalb.core.parser.node.TKwExpect;
import de.be4.classicalb.core.parser.node.TKwExpressionOperator;
import de.be4.classicalb.core.parser.node.TKwFor;
import de.be4.classicalb.core.parser.node.TKwFunction;
import de.be4.classicalb.core.parser.node.TKwOnSuccess;
import de.be4.classicalb.core.parser.node.TKwPredicateAttribute;
import de.be4.classicalb.core.parser.node.TKwPredicateOperator;
import de.be4.classicalb.core.parser.node.TKwReferences;
import de.be4.classicalb.core.parser.node.TKwRule;
import de.be4.classicalb.core.parser.node.TKwRuleErrorType;
import de.be4.classicalb.core.parser.node.TKwRuleFail;
import de.be4.classicalb.core.parser.node.TKwRuleForAll;
import de.be4.classicalb.core.parser.node.TKwType;
import de.be4.classicalb.core.parser.node.TKwUnchecked;
import de.be4.classicalb.core.parser.node.TKwValue;
import de.be4.classicalb.core.parser.node.TMachine;
import de.be4.classicalb.core.parser.node.Token;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;

public class RulesGrammar
implements IGrammar {
    private static final String INSTANTIATION_ERROR_MESSAGE = "Cannot create an instance of class: ";
    public static final String RULES_MACHINE = "RULES_MACHINE";
    public static final String SUCCEEDED_RULE = "SUCCEEDED_RULE";
    public static final String SUCCEEDED_RULE_ERROR_TYPE = "SUCCEEDED_RULE_ERROR_TYPE";
    public static final String FAILED_RULE = "FAILED_RULE";
    public static final String FAILED_RULE_ERROR_TYPE = "FAILED_RULE_ERROR_TYPE";
    public static final String GET_RULE_COUNTEREXAMPLES = "GET_RULE_COUNTEREXAMPLES";
    public static final String FAILED_RULE_ALL_ERROR_TYPES = "FAILED_RULE_ALL_ERROR_TYPES";
    public static final String NOT_CHECKED_RULE = "NOT_CHECKED_RULE";
    public static final String DISABLED_RULE = "DISABLED_RULE";
    public static final String DEPENDS_ON_RULE = "DEPENDS_ON_RULE";
    public static final String DEPENDS_ON_COMPUTATION = "DEPENDS_ON_COMPUTATION";
    public static final String ERROR_TYPES = "ERROR_TYPES";
    public static final String RULEID = "RULEID";
    public static final String STRING_FORMAT = "STRING_FORMAT";
    public static final String ACTIVATION = "ACTIVATION";
    public static final String PRECONDITION = "PRECONDITION";
    public static final String POSTCONDITION = "POSTCONDITION";
    public static final String CLASSIFICATION = "CLASSIFICATION";
    public static final String REPLACES = "REPLACES";
    public static final String TAGS = "TAGS";
    private static RulesGrammar ruleExtension;
    private static final HashMap<String, Class<? extends Token>> map;

    public static RulesGrammar getInstance() {
        if (ruleExtension == null) {
            ruleExtension = new RulesGrammar();
        }
        return ruleExtension;
    }

    private RulesGrammar() {
    }

    private static void add(Class<? extends Token> clazz) {
        try {
            map.put(clazz.getConstructor(new Class[0]).newInstance(new Object[0]).getText(), clazz);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new AssertionError(INSTANTIATION_ERROR_MESSAGE + clazz.getName(), e);
        }
    }

    @Override
    public boolean containsAlternativeDefinitionForToken(Token token) {
        return token instanceof TIdentifierLiteral && map.containsKey(token.getText());
    }

    @Override
    public Token createNewToken(Token token) {
        Class<? extends Token> clazz = map.get(token.getText());
        try {
            Token newToken = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            newToken.setLine(token.getLine());
            newToken.setPos(token.getPos());
            return newToken;
        }
        catch (NoSuchMethodException e) {
            Class[] cArg = new Class[]{String.class};
            try {
                Token newInstance = clazz.getDeclaredConstructor(cArg).newInstance(token.getText());
                newInstance.setLine(token.getLine());
                newInstance.setPos(token.getPos());
                return newInstance;
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e1) {
                throw new AssertionError(INSTANTIATION_ERROR_MESSAGE + clazz.getName(), e1);
            }
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new AssertionError(INSTANTIATION_ERROR_MESSAGE + clazz.getName(), e);
        }
    }

    static {
        map = new HashMap();
        RulesGrammar.add(TKwRule.class);
        RulesGrammar.add(TKwExpect.class);
        RulesGrammar.add(TKwOnSuccess.class);
        RulesGrammar.add(TKwUnchecked.class);
        RulesGrammar.add(TKwCounterexample.class);
        RulesGrammar.add(TKwRuleForAll.class);
        RulesGrammar.add(TKwFor.class);
        RulesGrammar.add(TKwComputation.class);
        RulesGrammar.add(TKwDefine.class);
        RulesGrammar.add(TKwType.class);
        RulesGrammar.add(TKwValue.class);
        RulesGrammar.add(TKwDummyValue.class);
        RulesGrammar.add(TKwFunction.class);
        RulesGrammar.add(TKwReferences.class);
        RulesGrammar.add(TKwRuleFail.class);
        RulesGrammar.add(TKwRuleErrorType.class);
        RulesGrammar.add(TKwBody.class);
        map.put(RULES_MACHINE, TMachine.class);
        map.put(SUCCEEDED_RULE, TKwPredicateOperator.class);
        map.put(SUCCEEDED_RULE_ERROR_TYPE, TKwPredicateOperator.class);
        map.put(FAILED_RULE, TKwPredicateOperator.class);
        map.put(FAILED_RULE_ERROR_TYPE, TKwPredicateOperator.class);
        map.put(FAILED_RULE_ALL_ERROR_TYPES, TKwPredicateOperator.class);
        map.put(NOT_CHECKED_RULE, TKwPredicateOperator.class);
        map.put(DISABLED_RULE, TKwPredicateOperator.class);
        map.put(DEPENDS_ON_RULE, TKwAttributeIdentifier.class);
        map.put(DEPENDS_ON_COMPUTATION, TKwAttributeIdentifier.class);
        map.put(RULEID, TKwAttributeIdentifier.class);
        map.put(ERROR_TYPES, TKwAttributeIdentifier.class);
        map.put(CLASSIFICATION, TKwAttributeIdentifier.class);
        map.put(TAGS, TKwAttributeIdentifier.class);
        map.put(REPLACES, TKwAttributeIdentifier.class);
        map.put(ACTIVATION, TKwPredicateAttribute.class);
        map.put(PRECONDITION, TKwPredicateAttribute.class);
        map.put(POSTCONDITION, TKwPredicateAttribute.class);
        map.put(GET_RULE_COUNTEREXAMPLES, TKwExpressionOperator.class);
        map.put(STRING_FORMAT, TKwExpressionOperator.class);
    }
}

