/*
 * Decompiled with CFR 0.152.
 */
package de.be4.classicalb.core.parser.analysis.transforming;

import de.be4.classicalb.core.parser.analysis.OptimizedTraversingAdapter;
import de.be4.classicalb.core.parser.exceptions.CheckException;
import de.be4.classicalb.core.parser.exceptions.VisitorException;
import de.be4.classicalb.core.parser.node.AArityExpression;
import de.be4.classicalb.core.parser.node.ABinExpression;
import de.be4.classicalb.core.parser.node.ABtreeExpression;
import de.be4.classicalb.core.parser.node.AConjunctPredicate;
import de.be4.classicalb.core.parser.node.AConstExpression;
import de.be4.classicalb.core.parser.node.ADescriptionPragma;
import de.be4.classicalb.core.parser.node.AFatherExpression;
import de.be4.classicalb.core.parser.node.AFunctionExpression;
import de.be4.classicalb.core.parser.node.AHexIntegerExpression;
import de.be4.classicalb.core.parser.node.AIdentifierExpression;
import de.be4.classicalb.core.parser.node.AIfElsifPredicatePredicate;
import de.be4.classicalb.core.parser.node.AIfPredicatePredicate;
import de.be4.classicalb.core.parser.node.AImplicationPredicate;
import de.be4.classicalb.core.parser.node.AInfixExpression;
import de.be4.classicalb.core.parser.node.AIntegerExpression;
import de.be4.classicalb.core.parser.node.ALeftExpression;
import de.be4.classicalb.core.parser.node.AMirrorExpression;
import de.be4.classicalb.core.parser.node.AMultilineStringExpression;
import de.be4.classicalb.core.parser.node.ANegationPredicate;
import de.be4.classicalb.core.parser.node.APostfixExpression;
import de.be4.classicalb.core.parser.node.APrefixExpression;
import de.be4.classicalb.core.parser.node.ARankExpression;
import de.be4.classicalb.core.parser.node.ARightExpression;
import de.be4.classicalb.core.parser.node.ASizetExpression;
import de.be4.classicalb.core.parser.node.ASonExpression;
import de.be4.classicalb.core.parser.node.ASonsExpression;
import de.be4.classicalb.core.parser.node.AStringExpression;
import de.be4.classicalb.core.parser.node.ASubtreeExpression;
import de.be4.classicalb.core.parser.node.ATopExpression;
import de.be4.classicalb.core.parser.node.ATreeExpression;
import de.be4.classicalb.core.parser.node.PExpression;
import de.be4.classicalb.core.parser.node.PPredicate;
import de.be4.classicalb.core.parser.node.TDefLiteralPredicate;
import de.be4.classicalb.core.parser.node.TDefLiteralSubstitution;
import de.be4.classicalb.core.parser.node.THexLiteral;
import de.be4.classicalb.core.parser.node.TIdentifierLiteral;
import de.be4.classicalb.core.parser.node.TIntegerLiteral;
import de.be4.classicalb.core.parser.node.TMultilineStringContent;
import de.be4.classicalb.core.parser.node.TStringLiteral;
import de.be4.classicalb.core.parser.node.Token;
import de.be4.classicalb.core.parser.util.Utils;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class SyntaxExtensionTranslator
extends OptimizedTraversingAdapter {
    @Override
    public void caseADescriptionPragma(ADescriptionPragma node) {
        while (!node.getParts().isEmpty() && node.getParts().get(0).getText().trim().isEmpty()) {
            node.getParts().remove(0);
        }
        while (!node.getParts().isEmpty() && node.getParts().get(node.getParts().size() - 1).getText().trim().isEmpty()) {
            node.getParts().remove(node.getParts().size() - 1);
        }
    }

    private static void checkArgumentCount(AFunctionExpression node, int count) {
        int paramCount = node.getParameters().size();
        if (paramCount != count) {
            String funcName = Utils.getAIdentifierAsString((AIdentifierExpression)node.getIdentifier());
            throw new VisitorException(new CheckException("Built-in function " + funcName + " expects exactly " + count + " argument(s), but got " + paramCount, node));
        }
    }

    private static PExpression checkSingleArgument(AFunctionExpression node) {
        SyntaxExtensionTranslator.checkArgumentCount(node, 1);
        return node.getParameters().get(0);
    }

    private PPredicate rewriteIfPredicate(PPredicate condition, PPredicate thenBlock, List<PPredicate> elsifs, PPredicate elseBlock) {
        PPredicate realElseBlock;
        AImplicationPredicate imp1 = new AImplicationPredicate(condition.clone(), thenBlock.clone());
        imp1.setStartPos(condition.getStartPos());
        imp1.setEndPos(thenBlock.getEndPos());
        if (elsifs.isEmpty()) {
            realElseBlock = elseBlock.clone();
        } else {
            AIfElsifPredicatePredicate first = (AIfElsifPredicatePredicate)elsifs.remove(0);
            realElseBlock = this.rewriteIfPredicate(first.getCondition(), first.getThen(), elsifs, elseBlock);
        }
        AImplicationPredicate imp2 = new AImplicationPredicate(new ANegationPredicate(condition.clone()), realElseBlock);
        return new AConjunctPredicate(imp1, imp2);
    }

    @Override
    public void outAIfPredicatePredicate(AIfPredicatePredicate node) {
        PPredicate result = this.rewriteIfPredicate(node.getCondition(), node.getThen(), new ArrayList<PPredicate>(node.getElsifs()), node.getElse());
        result.setStartPos(node.getStartPos());
        result.setEndPos(node.getEndPos());
        node.replaceBy(result);
    }

    @Override
    public void outAMultilineStringExpression(AMultilineStringExpression node) {
        TMultilineStringContent content = node.getContent();
        String text = content.getText();
        String unescaped = Utils.unescapeStringContents(text);
        AStringExpression stringNode = new AStringExpression(new TStringLiteral(unescaped, content.getLine(), content.getPos()));
        stringNode.setStartPos(node.getStartPos());
        stringNode.setEndPos(node.getEndPos());
        node.replaceBy(stringNode);
    }

    @Override
    public void caseTStringLiteral(TStringLiteral node) {
        String text = node.getText();
        String unescaped = Utils.unescapeStringContents(Utils.removeSurroundingQuotes(text, '\"'));
        node.setText(unescaped);
    }

    @Override
    public void caseTIdentifierLiteral(TIdentifierLiteral node) {
        SyntaxExtensionTranslator.unquoteIdentifierToken(node);
    }

    @Override
    public void caseTDefLiteralPredicate(TDefLiteralPredicate node) {
        SyntaxExtensionTranslator.unquoteIdentifierToken(node);
    }

    @Override
    public void caseTDefLiteralSubstitution(TDefLiteralSubstitution node) {
        SyntaxExtensionTranslator.unquoteIdentifierToken(node);
    }

    private static void unquoteIdentifierToken(Token token) {
        String text = token.getText();
        if (Utils.isQuoted(text, '`')) {
            try {
                token.setText(Utils.unquoteIdentifier(text));
            }
            catch (IllegalArgumentException exc) {
                throw new VisitorException(new CheckException(exc.getMessage(), token));
            }
        }
    }

    @Override
    public void outAHexIntegerExpression(AHexIntegerExpression node) {
        THexLiteral literal = node.getLiteral();
        String text = literal.getText().substring(2);
        BigInteger value = new BigInteger(text, 16);
        TIntegerLiteral tIntLiteral = new TIntegerLiteral(value.toString(), literal.getLine(), literal.getPos());
        AIntegerExpression intNode = new AIntegerExpression(tIntLiteral);
        intNode.setStartPos(node.getStartPos());
        intNode.setEndPos(node.getEndPos());
        node.replaceBy(intNode);
    }

    @Override
    public void caseAFunctionExpression(AFunctionExpression node) {
        PExpression replacement;
        if (!(node.getIdentifier() instanceof AIdentifierExpression)) {
            super.caseAFunctionExpression(node);
            return;
        }
        String funcName = Utils.getAIdentifierAsString((AIdentifierExpression)node.getIdentifier());
        if (Utils.isQuoted(funcName, '`')) {
            super.caseAFunctionExpression(node);
            return;
        }
        switch (funcName) {
            case "tree": {
                replacement = new ATreeExpression(SyntaxExtensionTranslator.checkSingleArgument(node));
                break;
            }
            case "btree": {
                replacement = new ABtreeExpression(SyntaxExtensionTranslator.checkSingleArgument(node));
                break;
            }
            case "const": {
                SyntaxExtensionTranslator.checkArgumentCount(node, 2);
                replacement = new AConstExpression(node.getParameters().get(0), node.getParameters().get(1));
                break;
            }
            case "top": {
                replacement = new ATopExpression(SyntaxExtensionTranslator.checkSingleArgument(node));
                break;
            }
            case "sons": {
                replacement = new ASonsExpression(SyntaxExtensionTranslator.checkSingleArgument(node));
                break;
            }
            case "prefix": {
                replacement = new APrefixExpression(SyntaxExtensionTranslator.checkSingleArgument(node));
                break;
            }
            case "postfix": {
                replacement = new APostfixExpression(SyntaxExtensionTranslator.checkSingleArgument(node));
                break;
            }
            case "sizet": {
                replacement = new ASizetExpression(SyntaxExtensionTranslator.checkSingleArgument(node));
                break;
            }
            case "mirror": {
                replacement = new AMirrorExpression(SyntaxExtensionTranslator.checkSingleArgument(node));
                break;
            }
            case "rank": {
                SyntaxExtensionTranslator.checkArgumentCount(node, 2);
                replacement = new ARankExpression(node.getParameters().get(0), node.getParameters().get(1));
                break;
            }
            case "father": {
                SyntaxExtensionTranslator.checkArgumentCount(node, 2);
                replacement = new AFatherExpression(node.getParameters().get(0), node.getParameters().get(1));
                break;
            }
            case "son": {
                SyntaxExtensionTranslator.checkArgumentCount(node, 3);
                replacement = new ASonExpression(node.getParameters().get(0), node.getParameters().get(1), node.getParameters().get(2));
                break;
            }
            case "subtree": {
                SyntaxExtensionTranslator.checkArgumentCount(node, 2);
                replacement = new ASubtreeExpression(node.getParameters().get(0), node.getParameters().get(1));
                break;
            }
            case "arity": {
                SyntaxExtensionTranslator.checkArgumentCount(node, 2);
                replacement = new AArityExpression(node.getParameters().get(0), node.getParameters().get(1));
                break;
            }
            case "bin": {
                int paramCount = node.getParameters().size();
                if (paramCount == 1) {
                    replacement = new ABinExpression(node.getParameters().get(0), null, null);
                    break;
                }
                if (paramCount == 3) {
                    replacement = new ABinExpression(node.getParameters().get(0), node.getParameters().get(1), node.getParameters().get(2));
                    break;
                }
                throw new VisitorException(new CheckException("Built-in function " + funcName + " expects 1 or 3 arguments, but got " + paramCount, node));
            }
            case "left": {
                replacement = new ALeftExpression(SyntaxExtensionTranslator.checkSingleArgument(node));
                break;
            }
            case "right": {
                replacement = new ARightExpression(SyntaxExtensionTranslator.checkSingleArgument(node));
                break;
            }
            case "infix": {
                replacement = new AInfixExpression(SyntaxExtensionTranslator.checkSingleArgument(node));
                break;
            }
            default: {
                super.caseAFunctionExpression(node);
                return;
            }
        }
        replacement.setStartPos(node.getStartPos());
        replacement.setEndPos(node.getEndPos());
        node.replaceBy(replacement);
        replacement.apply(this);
    }
}

