/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.coverage;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import tla2sany.semantic.OpApplNode;
import tla2sany.semantic.SemanticNode;
import tla2sany.st.Location;
import tlc2.output.MP;
import tlc2.output.OutputCollector;
import tlc2.tool.coverage.ActionWrapper;
import tlc2.tool.coverage.CostModel;
import tlc2.tool.coverage.CostModelNode;

public class OpApplNodeWrapper
extends CostModelNode
implements Comparable<OpApplNodeWrapper>,
CostModel {
    private final Set<Long> childCounts = new HashSet<Long>();
    private final CostModelNode root;
    private final OpApplNode node;
    private long snapshotEvalCount = 0L;
    private boolean primed = false;
    private int level;
    private OpApplNodeWrapper recursive;
    protected final Map<SemanticNode, CostModelNode> lets = new LinkedHashMap<SemanticNode, CostModelNode>();
    private final Set<Integer> seen = new HashSet<Integer>();

    OpApplNodeWrapper(OpApplNode node, CostModelNode root) {
        this.node = node;
        this.root = root;
        this.level = 0;
    }

    OpApplNodeWrapper() {
        this(null, null);
    }

    OpApplNodeWrapper(OpApplNode node, long samples) {
        this(node, null);
        this.incInvocations(samples);
    }

    @Override
    public int compareTo(OpApplNodeWrapper arg0) {
        return this.getLocation().compareTo(arg0.getLocation());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.node.getLocation() == null ? 0 : this.node.getLocation().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OpApplNodeWrapper other = (OpApplNodeWrapper)obj;
        return !(this.node.getLocation() == null ? other.node.getLocation() != null : !this.node.getLocation().equals(other.node.getLocation()));
    }

    public String toString() {
        if (this.node == null) {
            return "root";
        }
        return this.node.toString();
    }

    @Override
    protected Location getLocation() {
        return this.node != null ? this.node.getLocation() : Location.nullLoc;
    }

    @Override
    public OpApplNode getNode() {
        return this.node;
    }

    @Override
    public boolean isRoot() {
        return this.node == null;
    }

    public OpApplNodeWrapper addLets(OpApplNodeWrapper lets) {
        this.lets.put(lets.getNode(), lets);
        return this;
    }

    public OpApplNodeWrapper setRecursive(OpApplNodeWrapper recursive) {
        assert (this.recursive == null);
        this.recursive = recursive;
        return this;
    }

    @Override
    public CostModelNode getRoot() {
        assert (this.root instanceof ActionWrapper);
        return this.root;
    }

    @Override
    public final CostModelNode get(SemanticNode eon) {
        if (eon == this.node || !(eon instanceof OpApplNode)) {
            return this;
        }
        CostModelNode child = (CostModelNode)this.children.get(eon);
        if (child != null) {
            return child;
        }
        if (this.recursive != null && (child = (CostModelNode)this.recursive.children.get(eon)) != null) {
            return child;
        }
        if (this.lets != null && (child = this.lets.get(eon)) != null) {
            return child;
        }
        if (this.seen.add(eon.myUID)) {
            MP.printMessage(2776, eon.toString(), this.toString());
        }
        return this;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    public OpApplNodeWrapper setLevel(int level) {
        this.level = level;
        return this;
    }

    public OpApplNodeWrapper setPrimed() {
        assert (!this.isPrimed());
        this.primed = true;
        return this;
    }

    protected boolean isPrimed() {
        return this.primed;
    }

    protected long getEvalCount(Calculate fresh) {
        if (fresh == Calculate.FRESH) {
            return super.getEvalCount();
        }
        return this.snapshotEvalCount;
    }

    @Override
    public CostModel report() {
        this.print(0, Calculate.FRESH);
        return this;
    }

    protected void print(int level, Calculate fresh) {
        HashSet<Long> collectedEvalCounts = new HashSet<Long>();
        this.collectChildren(collectedEvalCounts, fresh);
        if (collectedEvalCounts.isEmpty()) {
            if (this.getEvalCount(fresh) == 0L && !this.isPrimed()) {
                return;
            }
            this.printSelf(level++);
            return;
        }
        if (collectedEvalCounts.size() == 1) {
            long count = this.getCount(collectedEvalCounts);
            if (count < this.getEvalCount(fresh)) {
                this.printSelf(level++);
                this.printChildren(level);
                return;
            }
            if (!this.isPrimed() && this.getEvalCount(fresh) == 0L && count != 0L) {
                this.printSelf(level++, count);
                return;
            }
            if (this.getEvalCount(fresh) == count && count == 0L) {
                if (this.isPrimed()) {
                    this.printSelf(level++);
                }
                this.printChildren(level);
                return;
            }
            if (this.getEvalCount(fresh) == count) {
                this.printSelf(level++);
                return;
            }
        }
        if (this.getEvalCount(fresh) > 0L || this.isPrimed()) {
            this.printSelf(level++);
        }
        this.printChildren(level);
    }

    private long getCount(Set<Long> collectWeights) {
        assert (collectWeights.size() == 1);
        Iterator<Long> iterator = collectWeights.iterator();
        if (iterator.hasNext()) {
            Long l = iterator.next();
            return l;
        }
        return -1L;
    }

    protected void printChildren(int level) {
        for (CostModelNode cmn : this.children.values()) {
            ((OpApplNodeWrapper)cmn).print(level, Calculate.CACHED);
        }
    }

    protected void printSelf(int level, long count) {
        MP.printMessage(2221, OpApplNodeWrapper.indentBegin(level, '|', this.getLocation().toString()), String.valueOf(count));
        OutputCollector.putLineCount(this.getLocation(), count);
    }

    protected void printSelf(int level, long count, long cost) {
        MP.printMessage(2775, OpApplNodeWrapper.indentBegin(level, '|', this.getLocation().toString()), String.valueOf(count), String.valueOf(cost));
        OutputCollector.putLineCount(this.getLocation(), count);
    }

    protected void printSelf(int level) {
        if (this.getSecondary() > 0L) {
            this.printSelf(level, this.getEvalCount(), this.getSecondary());
        } else {
            this.printSelf(level, this.getEvalCount());
        }
    }

    protected static String indentBegin(int n, char c, String str) {
        assert (n >= 0);
        String whitespaces = new String(new char[n]).replace('\u0000', c);
        return whitespaces + str;
    }

    protected void collectChildren(Set<Long> result, Calculate c) {
        for (CostModelNode cmn : this.children.values()) {
            ((OpApplNodeWrapper)cmn).collectAndFreezeEvalCounts(result, c);
        }
    }

    protected void collectAndFreezeEvalCounts(Set<Long> result, Calculate c) {
        if (c == Calculate.FRESH) {
            this.snapshotEvalCount = this.getEvalCount(c);
            this.childCounts.clear();
            if (this.snapshotEvalCount > 0L || this.isPrimed()) {
                this.childCounts.add(this.snapshotEvalCount);
            }
            this.collectChildren(this.childCounts, c);
        }
        result.addAll(this.childCounts);
    }

    protected static enum Calculate {
        FRESH,
        CACHED;

    }
}

