/*
 * Decompiled with CFR 0.152.
 */
package tla2sany.parser;

import java.util.Enumeration;
import java.util.Hashtable;
import tla2sany.parser.Operator;
import util.UniqueString;

public class Operators {
    public static int assocNone = 0;
    public static int assocLeft = 1;
    public static int assocRight = 2;
    public static int nofix = 0;
    public static int prefix = 1;
    public static int postfix = 2;
    public static int infix = 3;
    public static int nfix = 4;
    static Hashtable DefinitionTable = new Hashtable();
    static Hashtable BuiltinTable = new Hashtable();

    public static void addOperator(UniqueString name, Operator op) {
        DefinitionTable.put(name, op);
    }

    public static Operator getOperator(UniqueString name) {
        return (Operator)DefinitionTable.get(name);
    }

    public static Operator getMixfix(Operator op) {
        if (op.isPrefix()) {
            return op;
        }
        UniqueString id = UniqueString.uniqueStringOf(op.getIdentifier().toString() + ".");
        return (Operator)DefinitionTable.get(id);
    }

    public static boolean existsOperator(UniqueString name) {
        return DefinitionTable.get(name) != null;
    }

    public static void addSynonym(UniqueString template, UniqueString match) {
        Operator n = (Operator)DefinitionTable.get(match);
        if (n != null) {
            DefinitionTable.put(template, n);
        }
    }

    public static UniqueString resolveSynonym(UniqueString name) {
        Operator n = (Operator)DefinitionTable.get(name);
        if (n == null) {
            return name;
        }
        return n.getIdentifier();
    }

    public static void addBuiltinAssoc(UniqueString symbol, UniqueString builtin) {
        BuiltinTable.put(symbol, builtin);
    }

    public static UniqueString getBuiltinAssoc(UniqueString symbol) {
        Operator n = (Operator)DefinitionTable.get(symbol);
        if (n != null) {
            UniqueString name = n.getIdentifier();
            return (UniqueString)BuiltinTable.get(name);
        }
        return null;
    }

    public static void printTable() {
        System.out.println("printing Operators table");
        Enumeration Enum2 = DefinitionTable.keys();
        while (Enum2.hasMoreElements()) {
            System.out.println("-> " + ((UniqueString)Enum2.nextElement()).toString());
        }
    }
}

