/*
 * Decompiled with CFR 0.152.
 */
package de.tlc4b.analysis.unchangedvariables;

import de.be4.classicalb.core.parser.analysis.DepthFirstAdapter;
import de.be4.classicalb.core.parser.node.AIdentifierExpression;
import de.be4.classicalb.core.parser.node.Node;
import de.tlc4b.analysis.MachineContext;
import de.tlc4b.analysis.unchangedvariables.UnchangedVariablesFinder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class InvariantPreservationAnalysis
extends DepthFirstAdapter {
    private final MachineContext machineContext;
    private final Map<Node, Set<Node>> preservingOperations = new HashMap<Node, Set<Node>>();
    private Set<Node> usedVariables;

    public List<Node> getPreservingOperations(Node invariant) {
        return new ArrayList<Node>((Collection)this.preservingOperations.get(invariant));
    }

    public InvariantPreservationAnalysis(MachineContext machineContext, List<Node> invariants, UnchangedVariablesFinder unchangedFinder) {
        this.machineContext = machineContext;
        for (Node inv : invariants) {
            this.usedVariables = new HashSet<Node>();
            inv.apply(this);
            HashSet<Node> preservingOperations = new HashSet<Node>();
            for (Node op : machineContext.getOperations().values()) {
                if (!Collections.disjoint(this.usedVariables, unchangedFinder.getAssignedVariables(op))) continue;
                preservingOperations.add(op);
            }
            this.preservingOperations.put(inv, preservingOperations);
        }
    }

    @Override
    public void inAIdentifierExpression(AIdentifierExpression node) {
        Node identifier = this.machineContext.getReferenceNode(node);
        if (this.machineContext.getVariables().containsValue(identifier)) {
            this.usedVariables.add(identifier);
        }
    }
}

