/*
 * Decompiled with CFR 0.152.
 */
package de.tlc4b.analysis.typerestriction;

import de.be4.classicalb.core.parser.analysis.DepthFirstAdapter;
import de.be4.classicalb.core.parser.node.AAnySubstitution;
import de.be4.classicalb.core.parser.node.AAssertionsMachineClause;
import de.be4.classicalb.core.parser.node.ABecomesSuchSubstitution;
import de.be4.classicalb.core.parser.node.AComprehensionSetExpression;
import de.be4.classicalb.core.parser.node.AConjunctPredicate;
import de.be4.classicalb.core.parser.node.AConstraintsMachineClause;
import de.be4.classicalb.core.parser.node.ADisjunctPredicate;
import de.be4.classicalb.core.parser.node.AEqualPredicate;
import de.be4.classicalb.core.parser.node.AExistsPredicate;
import de.be4.classicalb.core.parser.node.AForallPredicate;
import de.be4.classicalb.core.parser.node.AGeneralProductExpression;
import de.be4.classicalb.core.parser.node.AGeneralSumExpression;
import de.be4.classicalb.core.parser.node.AIdentifierExpression;
import de.be4.classicalb.core.parser.node.AImplicationPredicate;
import de.be4.classicalb.core.parser.node.AInitialisationMachineClause;
import de.be4.classicalb.core.parser.node.AIntersectionExpression;
import de.be4.classicalb.core.parser.node.ALambdaExpression;
import de.be4.classicalb.core.parser.node.ALetExpressionExpression;
import de.be4.classicalb.core.parser.node.ALetPredicatePredicate;
import de.be4.classicalb.core.parser.node.ALetSubstitution;
import de.be4.classicalb.core.parser.node.AMemberPredicate;
import de.be4.classicalb.core.parser.node.ANotMemberPredicate;
import de.be4.classicalb.core.parser.node.AOperation;
import de.be4.classicalb.core.parser.node.APowSubsetExpression;
import de.be4.classicalb.core.parser.node.APreconditionSubstitution;
import de.be4.classicalb.core.parser.node.APredicateParseUnit;
import de.be4.classicalb.core.parser.node.APropertiesMachineClause;
import de.be4.classicalb.core.parser.node.AQuantifiedIntersectionExpression;
import de.be4.classicalb.core.parser.node.AQuantifiedUnionExpression;
import de.be4.classicalb.core.parser.node.ASelectSubstitution;
import de.be4.classicalb.core.parser.node.ASetExtensionExpression;
import de.be4.classicalb.core.parser.node.ASetSubtractionExpression;
import de.be4.classicalb.core.parser.node.ASubsetPredicate;
import de.be4.classicalb.core.parser.node.Node;
import de.be4.classicalb.core.parser.node.PExpression;
import de.be4.classicalb.core.parser.node.PPredicate;
import de.be4.classicalb.core.parser.node.Start;
import de.be4.classicalb.core.parser.util.Utils;
import de.be4.ltl.core.parser.node.AExistsLtl;
import de.be4.ltl.core.parser.node.AForallLtl;
import de.tlc4b.TLC4BGlobals;
import de.tlc4b.analysis.ConstantsEvaluator;
import de.tlc4b.analysis.MachineContext;
import de.tlc4b.analysis.Typechecker;
import de.tlc4b.analysis.typerestriction.IdentifierDependencies;
import de.tlc4b.btypes.BType;
import de.tlc4b.exceptions.NotSupportedException;
import de.tlc4b.ltl.LTLFormulaVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;

public class TypeRestrictor
extends DepthFirstAdapter {
    private final MachineContext machineContext;
    private final IdentifierDependencies identifierDependencies;
    private final Typechecker typechecker;
    private final ConstantsEvaluator constantsEvaluator;
    private final Hashtable<Node, Node> restrictedTypeNodeTable;
    private final HashSet<Node> removedNodes;
    private final Hashtable<Node, ArrayList<Node>> restrictedNodeTable;
    private final Hashtable<Node, ArrayList<Node>> subtractedNodeTable;
    private final Hashtable<Node, HashSet<PExpression>> expectedIdentifieListTable = new Hashtable();
    private Hashtable<Node, Node> variablesHashTable;

    public Node getRestrictedNode(Node node) {
        return this.restrictedTypeNodeTable.get(node);
    }

    public Collection<Node> getAllRestrictedNodes() {
        return this.restrictedTypeNodeTable.values();
    }

    public TypeRestrictor(Start start, MachineContext machineContext, Typechecker typechecker, ConstantsEvaluator constantsEvaluator) {
        this.machineContext = machineContext;
        this.typechecker = typechecker;
        this.constantsEvaluator = constantsEvaluator;
        this.restrictedTypeNodeTable = new Hashtable();
        this.removedNodes = new HashSet();
        this.restrictedNodeTable = new Hashtable();
        this.subtractedNodeTable = new Hashtable();
        this.identifierDependencies = new IdentifierDependencies(machineContext);
        start.apply(this);
        this.checkLTLFormulas();
    }

    private void checkLTLFormulas() {
        for (LTLFormulaVisitor visitor : this.machineContext.getLTLFormulas()) {
            for (de.be4.ltl.core.parser.node.Node ltlNode : visitor.getUnparsedHashTable().keySet()) {
                HashSet<PExpression> set;
                HashSet<Node> list;
                AIdentifierExpression id;
                Node bNode = visitor.getBAst(ltlNode);
                if (ltlNode instanceof AExistsLtl) {
                    id = visitor.getLTLIdentifier(((AExistsLtl)ltlNode).getExistsIdentifier().getText());
                    list = new HashSet<Node>();
                    list.add(id);
                    this.analysePredicate(bNode, list, new HashSet<Node>());
                    set = new HashSet<PExpression>();
                    set.add(id);
                    this.createRestrictedTypeofLocalVariables(set, true);
                } else if (ltlNode instanceof AForallLtl) {
                    id = visitor.getLTLIdentifier(((AForallLtl)ltlNode).getForallIdentifier().getText());
                    list = new HashSet();
                    list.add(id);
                    this.analysePredicate(bNode, list, new HashSet<Node>());
                    set = new HashSet();
                    set.add(id);
                    this.createRestrictedTypeofLocalVariables(set, true);
                }
                bNode.apply(this);
            }
        }
    }

    public boolean isARemovedNode(Node node) {
        return this.removedNodes.contains(node);
    }

    private void putRestrictedType(Node identifier, Node expression) {
        ArrayList<Node> list = this.restrictedNodeTable.get(identifier);
        if (list == null) {
            list = new ArrayList();
            list.add(expression);
            this.restrictedNodeTable.put(identifier, list);
        } else if (!list.contains(expression)) {
            list.add(expression);
        }
    }

    private void putSubtractedType(Node identifier, Node expression) {
        ArrayList<Node> list = this.subtractedNodeTable.get(identifier);
        if (list == null) {
            list = new ArrayList();
            list.add(expression);
            this.subtractedNodeTable.put(identifier, list);
        } else {
            list.add(expression);
        }
    }

    @Override
    public void inAConstraintsMachineClause(AConstraintsMachineClause node) {
        HashSet<Node> list = new HashSet<Node>(this.machineContext.getScalarParameter().values());
        this.analysePredicate(node.getPredicates(), list, new HashSet<Node>());
        HashSet<PExpression> set = new HashSet<PExpression>();
        for (Node param : list) {
            set.add((PExpression)param);
        }
        this.createRestrictedTypeofLocalVariables(new HashSet<PExpression>(set), false);
    }

    @Override
    public void inAPropertiesMachineClause(APropertiesMachineClause node) {
        HashSet<PExpression> set = new HashSet<PExpression>();
        for (Node con : this.machineContext.getConstants().values()) {
            set.add((PExpression)con);
            Node valueOfConstant = this.constantsEvaluator.getValueOfConstant(con);
            if (valueOfConstant == null) continue;
            this.removedNodes.add(valueOfConstant.parent());
        }
        HashSet<Node> list = new HashSet<Node>(this.machineContext.getConstants().values());
        this.analysePredicate(node.getPredicates(), list, new HashSet<Node>());
        this.createRestrictedTypeofLocalVariables(new HashSet<PExpression>(set), false);
    }

    public void analyseDisjunktionPredicate(PPredicate node, HashSet<Node> list) {
        if (node instanceof ADisjunctPredicate) {
            ADisjunctPredicate dis = (ADisjunctPredicate)node;
            this.analyseDisjunktionPredicate(dis.getLeft(), list);
            this.analyseDisjunktionPredicate(dis.getRight(), list);
        } else {
            this.analysePredicate(node, list, new HashSet<Node>());
        }
    }

    private void analysePredicate(Node n, HashSet<Node> list, HashSet<Node> ignoreList) {
        if (this.removedNodes.contains(n)) {
            return;
        }
        if (n instanceof AEqualPredicate) {
            ArrayList<PExpression> element;
            PExpression left = ((AEqualPredicate)n).getLeft();
            Node r_left = this.machineContext.getReferenceNode(left);
            PExpression right = ((AEqualPredicate)n).getRight();
            Node r_right = this.machineContext.getReferenceNode(right);
            if (list.contains(r_left) && this.isAConstantExpression(right, list, ignoreList)) {
                right.apply(this);
                element = new ArrayList<PExpression>();
                element.add(right);
                if (this.machineContext.getVariables().containsValue(r_left)) {
                    r_left = this.variablesHashTable.get(r_left);
                }
                this.putRestrictedType(r_left, new ASetExtensionExpression(element));
                this.removedNodes.add(n);
            }
            if (list.contains(r_right) && this.isAConstantExpression(left, list, ignoreList)) {
                left.apply(this);
                element = new ArrayList();
                element.add(left);
                if (this.machineContext.getVariables().containsValue(r_right)) {
                    r_right = this.variablesHashTable.get(r_right);
                }
                this.putRestrictedType(r_right, new ASetExtensionExpression(element));
                this.removedNodes.add(n);
            }
            return;
        }
        if (n instanceof AMemberPredicate) {
            PExpression left = ((AMemberPredicate)n).getLeft();
            Node r_left = this.machineContext.getReferenceNode(left);
            PExpression right = ((AMemberPredicate)n).getRight();
            if (list.contains(r_left) && this.isAConstantExpression(right, list, ignoreList)) {
                if (this.machineContext.getVariables().containsValue(r_left)) {
                    r_left = this.variablesHashTable.get(r_left);
                }
                this.putRestrictedType(r_left, right);
                this.removedNodes.add(n);
            }
            return;
        }
        if (n instanceof ANotMemberPredicate) {
            PExpression left = ((ANotMemberPredicate)n).getLeft();
            Node r_left = this.machineContext.getReferenceNode(left);
            PExpression right = ((ANotMemberPredicate)n).getRight();
            if (list.contains(r_left) && this.isAConstantExpression(right, list, ignoreList)) {
                if (this.machineContext.getVariables().containsValue(r_left)) {
                    r_left = this.variablesHashTable.get(r_left);
                }
                this.putSubtractedType(r_left, right);
                this.removedNodes.add(n);
            }
            return;
        }
        if (n instanceof ASubsetPredicate) {
            PExpression left = ((ASubsetPredicate)n).getLeft();
            Node r_left = this.machineContext.getReferenceNode(left);
            PExpression right = ((ASubsetPredicate)n).getRight();
            if (list.contains(r_left) && this.isAConstantExpression(right, list, ignoreList)) {
                right.apply(this);
                if (this.machineContext.getVariables().containsValue(r_left)) {
                    r_left = this.variablesHashTable.get(r_left);
                }
                this.putRestrictedType(r_left, new APowSubsetExpression(right));
                this.removedNodes.add(n);
            }
            return;
        }
        if (n instanceof AConjunctPredicate) {
            PPredicate left = ((AConjunctPredicate)n).getLeft();
            PPredicate right = ((AConjunctPredicate)n).getRight();
            this.analysePredicate(left, list, ignoreList);
            this.analysePredicate(right, list, ignoreList);
            if (this.removedNodes.contains(left) && this.removedNodes.contains(right)) {
                this.removedNodes.add(n);
            }
            return;
        }
        if (n instanceof AExistsPredicate) {
            HashSet<Node> set = new HashSet<Node>();
            set.addAll(((AExistsPredicate)n).getIdentifiers());
            set.addAll(ignoreList);
            this.analysePredicate(((AExistsPredicate)n).getPredicate(), list, set);
        }
        if (n instanceof Start) {
            this.analysePredicate(((Start)n).getPParseUnit(), list, ignoreList);
        }
        if (n instanceof APredicateParseUnit) {
            this.analysePredicate(((APredicateParseUnit)n).getPredicate(), list, ignoreList);
        }
    }

    public boolean isAConstantExpression(Node node, HashSet<Node> list, HashSet<Node> ignoreList) {
        HashSet<Node> newList = new HashSet<Node>();
        newList.addAll(list);
        newList.addAll(ignoreList);
        return !this.identifierDependencies.containsIdentifier(node, newList);
    }

    @Override
    public void inAForallPredicate(AForallPredicate node) {
        ArrayList<PExpression> copy = new ArrayList<PExpression>(node.getIdentifiers());
        HashSet<Node> list = new HashSet<Node>(copy);
        AImplicationPredicate implication = (AImplicationPredicate)node.getImplication();
        this.analysePredicate(implication.getLeft(), list, new HashSet<Node>());
        this.createRestrictedTypeofLocalVariables(new HashSet<PExpression>(node.getIdentifiers()), false);
    }

    @Override
    public void inAExistsPredicate(AExistsPredicate node) {
        ArrayList<PExpression> copy = new ArrayList<PExpression>(node.getIdentifiers());
        HashSet<Node> list = new HashSet<Node>(copy);
        this.analysePredicate(node.getPredicate(), list, new HashSet<Node>());
        this.createRestrictedTypeofLocalVariables(new HashSet<PExpression>(node.getIdentifiers()), false);
    }

    @Override
    public void inAQuantifiedUnionExpression(AQuantifiedUnionExpression node) {
        ArrayList<PExpression> copy = new ArrayList<PExpression>(node.getIdentifiers());
        HashSet<Node> list = new HashSet<Node>(copy);
        this.analysePredicate(node.getPredicates(), list, new HashSet<Node>());
        this.createRestrictedTypeofLocalVariables(new HashSet<PExpression>(node.getIdentifiers()), false);
    }

    @Override
    public void inAQuantifiedIntersectionExpression(AQuantifiedIntersectionExpression node) {
        ArrayList<PExpression> copy = new ArrayList<PExpression>(node.getIdentifiers());
        HashSet<Node> list = new HashSet<Node>(copy);
        this.analysePredicate(node.getPredicates(), list, new HashSet<Node>());
        this.createRestrictedTypeofLocalVariables(new HashSet<PExpression>(node.getIdentifiers()), false);
    }

    @Override
    public void inAComprehensionSetExpression(AComprehensionSetExpression node) {
        ArrayList<PExpression> copy = new ArrayList<PExpression>(node.getIdentifiers());
        HashSet<Node> list = new HashSet<Node>(copy);
        this.analysePredicate(node.getPredicates(), list, new HashSet<Node>());
        this.createRestrictedTypeofLocalVariables(new HashSet<PExpression>(node.getIdentifiers()), false);
    }

    @Override
    public void inALambdaExpression(ALambdaExpression node) {
        ArrayList<PExpression> copy = new ArrayList<PExpression>(node.getIdentifiers());
        HashSet<Node> list = new HashSet<Node>(copy);
        this.analysePredicate(node.getPredicate(), list, new HashSet<Node>());
        this.createRestrictedTypeofLocalVariables(new HashSet<PExpression>(node.getIdentifiers()), false);
    }

    @Override
    public void inAGeneralSumExpression(AGeneralSumExpression node) {
        ArrayList<PExpression> copy = new ArrayList<PExpression>(node.getIdentifiers());
        HashSet<Node> list = new HashSet<Node>(copy);
        this.analysePredicate(node.getPredicates(), list, new HashSet<Node>());
        this.createRestrictedTypeofLocalVariables(new HashSet<PExpression>(node.getIdentifiers()), false);
    }

    @Override
    public void inAGeneralProductExpression(AGeneralProductExpression node) {
        ArrayList<PExpression> copy = new ArrayList<PExpression>(node.getIdentifiers());
        HashSet<Node> list = new HashSet<Node>(copy);
        this.analysePredicate(node.getPredicates(), list, new HashSet<Node>());
        this.createRestrictedTypeofLocalVariables(new HashSet<PExpression>(node.getIdentifiers()), false);
    }

    @Override
    public void caseAInitialisationMachineClause(AInitialisationMachineClause node) {
        this.expectedIdentifieListTable.put(node.getSubstitutions(), new HashSet());
        node.getSubstitutions().apply(this);
    }

    @Override
    public void caseAOperation(AOperation node) {
        HashSet<PExpression> list = new HashSet<PExpression>();
        ArrayList<PExpression> copy = new ArrayList<PExpression>(node.getParameters());
        list.addAll(copy);
        this.expectedIdentifieListTable.put(node.getOperationBody(), list);
        if (node.getOperationBody() != null) {
            node.getOperationBody().apply(this);
        }
        this.createRestrictedTypeofLocalVariables(list, false);
    }

    @Override
    public void inAPreconditionSubstitution(APreconditionSubstitution node) {
        HashSet<Node> set = new HashSet<Node>(this.getExpectedIdentifier(node));
        this.analysePredicate(node.getPredicate(), set, new HashSet<Node>());
    }

    private HashSet<PExpression> getExpectedIdentifier(Node node) {
        HashSet<PExpression> list = this.expectedIdentifieListTable.get(node);
        if (list == null) {
            list = new HashSet();
        }
        return list;
    }

    @Override
    public void inASelectSubstitution(ASelectSubstitution node) {
        HashSet<Node> list = new HashSet<Node>(this.getExpectedIdentifier(node));
        this.analysePredicate(node.getCondition(), list, new HashSet<Node>());
    }

    @Override
    public void inAAnySubstitution(AAnySubstitution node) {
        HashSet<Node> list = new HashSet<Node>();
        ArrayList<PExpression> copy = new ArrayList<PExpression>(node.getIdentifiers());
        list.addAll(copy);
        list.addAll(this.getExpectedIdentifier(node));
        this.analysePredicate(node.getWhere(), list, new HashSet<Node>());
        this.createRestrictedTypeofLocalVariables(new HashSet<PExpression>(node.getIdentifiers()), false);
    }

    @Override
    public void inALetSubstitution(ALetSubstitution node) {
        HashSet<Node> list = new HashSet<Node>();
        ArrayList<PExpression> copy = new ArrayList<PExpression>(node.getIdentifiers());
        list.addAll(copy);
        list.addAll(this.getExpectedIdentifier(node));
        this.analysePredicate(node.getPredicate(), list, new HashSet<Node>());
        this.createRestrictedTypeofLocalVariables(new HashSet<PExpression>(node.getIdentifiers()), false);
    }

    @Override
    public void inALetExpressionExpression(ALetExpressionExpression node) {
        super.inALetExpressionExpression(node);
    }

    @Override
    public void inALetPredicatePredicate(ALetPredicatePredicate node) {
        HashSet<Node> list = new HashSet<Node>();
        ArrayList<PExpression> copy = new ArrayList<PExpression>(node.getIdentifiers());
        list.addAll(copy);
        list.addAll(this.getExpectedIdentifier(node));
        this.analysePredicate(node.getAssignment(), list, new HashSet<Node>());
        this.createRestrictedTypeofLocalVariables(new HashSet<PExpression>(node.getIdentifiers()), false);
    }

    @Override
    public void inABecomesSuchSubstitution(ABecomesSuchSubstitution node) {
        if (!(node.getPredicate() instanceof AExistsPredicate)) {
            this.variablesHashTable = new Hashtable();
            HashSet<Node> list = new HashSet<Node>();
            ArrayList<PExpression> copy = new ArrayList<PExpression>(node.getIdentifiers());
            for (PExpression e : copy) {
                Node ref = this.machineContext.getReferenceNode(e);
                list.add(ref);
                this.variablesHashTable.put(ref, e);
            }
            this.analysePredicate(node.getPredicate(), list, new HashSet<Node>());
            this.createRestrictedTypeofLocalVariables(new HashSet<PExpression>(copy), false);
        }
    }

    private void createRestrictedTypeofLocalVariables(Set<PExpression> copy, boolean constant) {
        for (PExpression e : copy) {
            PExpression tree;
            if (this.constantsEvaluator.getValueOfIdentifierMap().containsKey(e)) continue;
            ArrayList<Node> restrictedList = this.restrictedNodeTable.get(e);
            if (restrictedList == null) {
                BType conType = this.typechecker.getType(e);
                if (conType == null) {
                    conType = this.typechecker.getType(this.machineContext.getReferenceNode(e));
                }
                if (conType.containsInfiniteType() && !(e.parent() instanceof ALambdaExpression) && !(e.parent() instanceof AComprehensionSetExpression)) {
                    AIdentifierExpression id = (AIdentifierExpression)e;
                    String localVariableName = Utils.getTIdentifierListAsString(id.getIdentifier());
                    throw new NotSupportedException("Unable to restrict the type '" + conType + "' of identifier '" + localVariableName + "' to a finite set. TLC is not able to handle infinite sets.\n" + (e.getStartPos() == null ? "### Unknown position." : "### Line " + e.getStartPos().getLine() + ", Column " + e.getEndPos().getPos()));
                }
                tree = conType.createASTNode(this.typechecker);
            } else {
                tree = (PExpression)restrictedList.get(0);
                for (int i = 1; i < restrictedList.size(); ++i) {
                    PExpression n = (PExpression)restrictedList.get(i);
                    tree = new AIntersectionExpression(tree, n);
                }
            }
            ArrayList<Node> subtractedList = this.subtractedNodeTable.get(e);
            if (subtractedList != null) {
                for (Node node : subtractedList) {
                    PExpression n = (PExpression)node;
                    tree = new ASetSubtractionExpression(tree, n);
                }
            }
            this.restrictedTypeNodeTable.put(e, tree);
        }
    }

    @Override
    public void caseAAssertionsMachineClause(AAssertionsMachineClause node) {
        if (TLC4BGlobals.isAssertion()) {
            ArrayList<PPredicate> copy = new ArrayList<PPredicate>(node.getPredicates());
            for (PPredicate e : copy) {
                e.apply(this);
            }
        }
    }

    public void addRemoveNode(Node node) {
        this.removedNodes.add(node);
    }
}

