/*
 * Decompiled with CFR 0.152.
 */
package de.tlc4b.analysis.transformation;

import de.be4.classicalb.core.parser.analysis.DepthFirstAdapter;
import de.be4.classicalb.core.parser.node.AComprehensionSetExpression;
import de.be4.classicalb.core.parser.node.AConjunctPredicate;
import de.be4.classicalb.core.parser.node.ACoupleExpression;
import de.be4.classicalb.core.parser.node.ADomainExpression;
import de.be4.classicalb.core.parser.node.AEqualPredicate;
import de.be4.classicalb.core.parser.node.AEventBComprehensionSetExpression;
import de.be4.classicalb.core.parser.node.AIdentifierExpression;
import de.be4.classicalb.core.parser.node.AMemberPredicate;
import de.be4.classicalb.core.parser.node.Node;
import de.be4.classicalb.core.parser.node.PExpression;
import de.be4.classicalb.core.parser.node.PPredicate;
import de.be4.classicalb.core.parser.node.Start;
import de.be4.classicalb.core.parser.util.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SetComprehensionOptimizer
extends DepthFirstAdapter {
    public static void optimizeSetComprehensions(Start start) {
        start.apply(new SetComprehensionOptimizer());
    }

    @Override
    public void caseAComprehensionSetExpression(AComprehensionSetExpression node) {
        LinkedHashMap<String, AIdentifierExpression> identifiers = new LinkedHashMap<String, AIdentifierExpression>();
        for (PExpression identifier : node.getIdentifiers()) {
            AIdentifierExpression id = (AIdentifierExpression)identifier;
            identifiers.put(Utils.getTIdentifierListAsString(id.getIdentifier()), id);
        }
        ArrayList<String> list = new ArrayList<String>(identifiers.keySet());
        HashMap<String, PExpression> values = new HashMap<String, PExpression>();
        ArrayList<AEqualPredicate> equalList = new ArrayList<AEqualPredicate>();
        this.analysePredicate(node.getPredicates(), list, values, equalList);
        ArrayList<ADomainExpression> parentDomainExprsList = this.collectParentDomainExpression(node.parent());
        if (!(values.isEmpty() && parentDomainExprsList.isEmpty() || values.size() >= list.size() || list.size() - values.size() > 2)) {
            new NodesRemover(node.getPredicates(), equalList, values);
            int max = Math.min(list.size() - 1, parentDomainExprsList.size());
            int exprCount = list.size() - max;
            ArrayList<PExpression> ids = new ArrayList<PExpression>();
            ArrayList<PExpression> ids2 = new ArrayList<PExpression>();
            ArrayList<PExpression> ids3 = new ArrayList<PExpression>();
            ArrayList<PExpression> exprs = new ArrayList<PExpression>();
            for (int i = 0; i < list.size(); ++i) {
                String name = (String)list.get(i);
                PExpression identifier = (PExpression)identifiers.get(name);
                if (i < exprCount) {
                    if (values.containsKey(name)) {
                        exprs.add((PExpression)values.get(name));
                    } else {
                        exprs.add(identifier.clone());
                    }
                }
                if (values.containsKey(name)) continue;
                ids.add(identifier.clone());
                ids2.add(identifier.clone());
                ids3.add(identifier.clone());
            }
            AComprehensionSetExpression compre = new AComprehensionSetExpression(ids3, node.getPredicates());
            AMemberPredicate member = new AMemberPredicate(ids2.size() == 1 ? (PExpression)ids2.get(0) : new ACoupleExpression(ids2), compre);
            AEventBComprehensionSetExpression eventBcomprehension = new AEventBComprehensionSetExpression(ids, new ACoupleExpression(exprs), member);
            this.setSourcePosition(node, eventBcomprehension);
            if (!parentDomainExprsList.isEmpty()) {
                ADomainExpression aDomainExpression = (ADomainExpression)parentDomainExprsList.get(max - 1);
                aDomainExpression.replaceBy(eventBcomprehension);
            } else {
                node.replaceBy(eventBcomprehension);
            }
            eventBcomprehension.apply(this);
        } else {
            node.getPredicates().apply(this);
        }
    }

    private ArrayList<ADomainExpression> collectParentDomainExpression(Node node) {
        if (node instanceof ADomainExpression) {
            ArrayList<ADomainExpression> domExprList = this.collectParentDomainExpression(node.parent());
            domExprList.add(0, (ADomainExpression)node);
            return domExprList;
        }
        return new ArrayList<ADomainExpression>();
    }

    private void setSourcePosition(AComprehensionSetExpression from, AEventBComprehensionSetExpression to) {
        to.setStartPos(from.getStartPos());
        to.setEndPos(from.getEndPos());
    }

    private void analysePredicate(PPredicate predicate, List<String> list, Map<String, PExpression> values, List<AEqualPredicate> equalList) {
        if (predicate instanceof AConjunctPredicate) {
            AConjunctPredicate con = (AConjunctPredicate)predicate;
            this.analysePredicate(con.getLeft(), list, values, equalList);
            this.analysePredicate(con.getRight(), list, values, equalList);
        } else if (predicate instanceof AEqualPredicate) {
            AEqualPredicate equal = (AEqualPredicate)predicate;
            if (equal.getLeft() instanceof AIdentifierExpression) {
                AIdentifierExpression id = (AIdentifierExpression)equal.getLeft();
                String name = Utils.getTIdentifierListAsString(id.getIdentifier());
                HashSet<String> names = new HashSet<String>(values.keySet());
                names.add(name);
                if (list.contains(name) && !DependenciesDetector.expressionContainsIdentifier(equal.getRight(), names)) {
                    equalList.add(equal);
                    values.put(name, equal.getRight());
                }
            } else if (!equalList.contains(equal) && equal.getRight() instanceof AIdentifierExpression) {
                AIdentifierExpression id = (AIdentifierExpression)equal.getRight();
                String name = Utils.getTIdentifierListAsString(id.getIdentifier());
                HashSet<String> names = new HashSet<String>(values.keySet());
                names.add(name);
                if (list.contains(name) && !DependenciesDetector.expressionContainsIdentifier(equal.getLeft(), names)) {
                    equalList.add(equal);
                    values.put(name, equal.getLeft());
                }
            }
        }
    }

    static class NodesRemover
    extends DepthFirstAdapter {
        final Map<String, PExpression> values;

        public NodesRemover(PPredicate predicate, List<AEqualPredicate> equalList, Map<String, PExpression> values) {
            this.values = values;
            for (AEqualPredicate pred : equalList) {
                pred.replaceBy(null);
            }
            predicate.apply(this);
        }

        @Override
        public void caseAConjunctPredicate(AConjunctPredicate node) {
            if (node.getLeft() != null) {
                node.getLeft().apply(this);
            }
            if (node.getRight() != null) {
                node.getRight().apply(this);
            }
            this.outAConjunctPredicate(node);
        }

        @Override
        public void outAConjunctPredicate(AConjunctPredicate node) {
            if (node.parent() != null) {
                if (node.getLeft() == null && node.getRight() == null) {
                    node.replaceBy(null);
                } else if (node.getLeft() == null) {
                    node.replaceBy(node.getRight());
                } else if (node.getRight() == null) {
                    node.replaceBy(node.getLeft());
                }
            }
        }

        @Override
        public void caseAIdentifierExpression(AIdentifierExpression node) {
            String name = Utils.getTIdentifierListAsString(node.getIdentifier());
            PExpression value = this.values.get(name);
            if (value != null) {
                node.replaceBy(value.clone());
            }
        }
    }

    static class DependenciesDetector
    extends DepthFirstAdapter {
        private final Set<String> names;
        private boolean hasDependency = false;

        private DependenciesDetector(Set<String> names) {
            this.names = names;
        }

        @Override
        public void caseAIdentifierExpression(AIdentifierExpression node) {
            String name = Utils.getTIdentifierListAsString(node.getIdentifier());
            if (this.names.contains(name)) {
                this.hasDependency = true;
            }
        }

        static boolean expressionContainsIdentifier(PExpression node, Set<String> names) {
            DependenciesDetector dependenciesDetector = new DependenciesDetector(names);
            node.apply(dependenciesDetector);
            return dependenciesDetector.hasDependency;
        }
    }
}

