/*
 * Decompiled with CFR 0.152.
 */
package de.tlc4b.analysis.transformation;

import de.be4.classicalb.core.parser.analysis.DepthFirstAdapter;
import de.be4.classicalb.core.parser.node.AAnySubstitution;
import de.be4.classicalb.core.parser.node.AAssertionSubstitution;
import de.be4.classicalb.core.parser.node.AAssignSubstitution;
import de.be4.classicalb.core.parser.node.ABecomesElementOfSubstitution;
import de.be4.classicalb.core.parser.node.ABecomesSuchSubstitution;
import de.be4.classicalb.core.parser.node.AFunctionExpression;
import de.be4.classicalb.core.parser.node.AIdentifierExpression;
import de.be4.classicalb.core.parser.node.AIfElsifSubstitution;
import de.be4.classicalb.core.parser.node.AIfSubstitution;
import de.be4.classicalb.core.parser.node.AInitialisationMachineClause;
import de.be4.classicalb.core.parser.node.ALetSubstitution;
import de.be4.classicalb.core.parser.node.AParallelSubstitution;
import de.be4.classicalb.core.parser.node.APreconditionSubstitution;
import de.be4.classicalb.core.parser.node.ASelectSubstitution;
import de.be4.classicalb.core.parser.node.ASelectWhenSubstitution;
import de.be4.classicalb.core.parser.node.ASequenceSubstitution;
import de.be4.classicalb.core.parser.node.Node;
import de.be4.classicalb.core.parser.node.PExpression;
import de.be4.classicalb.core.parser.node.PSubstitution;
import de.be4.classicalb.core.parser.node.Start;
import de.be4.classicalb.core.parser.node.Token;
import de.tlc4b.MP;
import de.tlc4b.exceptions.NotSupportedException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class SequenceSubstitutionsEliminator
extends DepthFirstAdapter {
    private ASequenceSubstitution topLevel = null;
    private boolean initialisationMode = false;
    private boolean replacementMode = false;
    private final Set<List<String>> parallelAssignedVariables = new HashSet<List<String>>();
    private final Set<List<String>> currentAssignedVariables = new HashSet<List<String>>();
    private final Deque<SubstitutionMode> modeStack = new ArrayDeque<SubstitutionMode>();
    private final Set<Node> primeNodes = new HashSet<Node>();

    public SequenceSubstitutionsEliminator(Start start) {
        start.apply(this);
    }

    @Override
    public void inAAnySubstitution(AAnySubstitution node) {
        if (this.topLevel == null) {
            return;
        }
        this.replacementMode = true;
        node.getWhere().apply(this);
        this.replacementMode = false;
    }

    @Override
    public void inAAssertionSubstitution(AAssertionSubstitution node) {
        if (this.topLevel == null) {
            return;
        }
        this.replacementMode = true;
        node.getPredicate().apply(this);
        this.replacementMode = false;
    }

    @Override
    public void inAAssignSubstitution(AAssignSubstitution node) {
        if (this.topLevel == null) {
            return;
        }
        this.replacementMode = true;
        for (PExpression rhs : node.getRhsExpressions()) {
            rhs.apply(this);
        }
        this.replacementMode = false;
        for (PExpression lhs : node.getLhsExpression()) {
            if (lhs instanceof AIdentifierExpression) {
                this.assignVariables((AIdentifierExpression)lhs);
                continue;
            }
            if (!(lhs instanceof AFunctionExpression)) continue;
            throw new NotSupportedException("function assignments in sequential substitutions are not yet supported");
        }
    }

    @Override
    public void inABecomesElementOfSubstitution(ABecomesElementOfSubstitution node) {
        if (this.topLevel == null) {
            return;
        }
        this.replacementMode = true;
        node.getSet().apply(this);
        this.replacementMode = false;
        for (PExpression lhs : node.getIdentifiers()) {
            if (!(lhs instanceof AIdentifierExpression)) continue;
            this.assignVariables((AIdentifierExpression)lhs);
        }
    }

    @Override
    public void inABecomesSuchSubstitution(ABecomesSuchSubstitution node) {
        if (this.topLevel == null) {
            return;
        }
        this.replacementMode = true;
        node.getPredicate().apply(this);
        this.replacementMode = false;
        for (PExpression lhs : node.getIdentifiers()) {
            if (!(lhs instanceof AIdentifierExpression)) continue;
            this.assignVariables((AIdentifierExpression)lhs);
        }
    }

    @Override
    public void caseAIdentifierExpression(AIdentifierExpression node) {
        if (this.topLevel == null) {
            return;
        }
        if (!this.initialisationMode && this.replacementMode && this.currentAssignedVariables.contains(SequenceSubstitutionsEliminator.identifierToStringList(node))) {
            this.primeNodes.add(node);
        }
    }

    @Override
    public void inAIfSubstitution(AIfSubstitution node) {
        if (this.topLevel == null) {
            return;
        }
        this.replacementMode = true;
        node.getCondition().apply(this);
        this.replacementMode = false;
    }

    @Override
    public void inAIfElsifSubstitution(AIfElsifSubstitution node) {
        if (this.topLevel == null) {
            return;
        }
        this.replacementMode = true;
        node.getCondition().apply(this);
        this.replacementMode = false;
    }

    @Override
    public void inAInitialisationMachineClause(AInitialisationMachineClause node) {
        this.initialisationMode = true;
    }

    @Override
    public void outAInitialisationMachineClause(AInitialisationMachineClause node) {
        this.initialisationMode = false;
    }

    @Override
    public void inALetSubstitution(ALetSubstitution node) {
        if (this.topLevel == null) {
            return;
        }
        this.replacementMode = true;
        node.getPredicate().apply(this);
        this.replacementMode = false;
    }

    @Override
    public void inAParallelSubstitution(AParallelSubstitution node) {
        this.modeStack.push(SubstitutionMode.PARALLEL);
    }

    @Override
    public void outAParallelSubstitution(AParallelSubstitution node) {
        if (this.modeStack.removeFirst() != SubstitutionMode.PARALLEL) {
            throw new IllegalStateException("expected PARALLEL mode");
        }
        if (this.modeStack.peekFirst() == SubstitutionMode.SEQUENTIAL) {
            this.currentAssignedVariables.addAll(this.parallelAssignedVariables);
            this.parallelAssignedVariables.clear();
        }
    }

    @Override
    public void inAPreconditionSubstitution(APreconditionSubstitution node) {
        if (this.topLevel == null) {
            return;
        }
        this.replacementMode = true;
        node.getPredicate().apply(this);
        this.replacementMode = false;
    }

    @Override
    public void inASelectSubstitution(ASelectSubstitution node) {
        if (this.topLevel == null) {
            return;
        }
        this.replacementMode = true;
        node.getCondition().apply(this);
        this.replacementMode = false;
    }

    @Override
    public void inASelectWhenSubstitution(ASelectWhenSubstitution node) {
        if (this.topLevel == null) {
            return;
        }
        this.replacementMode = true;
        node.getCondition().apply(this);
        this.replacementMode = false;
    }

    @Override
    public void inASequenceSubstitution(ASequenceSubstitution node) {
        if (this.topLevel == null) {
            this.topLevel = node;
        }
        this.modeStack.push(SubstitutionMode.SEQUENTIAL);
    }

    @Override
    public void outASequenceSubstitution(ASequenceSubstitution node) {
        node.replaceBy(new AParallelSubstitution(new ArrayList<PSubstitution>(node.getSubstitutions())));
        MP.printlnVerbose(node.getStartPos() + "-" + node.getEndPos() + ": replaced sequential substitution by parallel substitution");
        if (this.modeStack.pollFirst() != SubstitutionMode.SEQUENTIAL) {
            throw new IllegalStateException("expected SEQUENTIAL mode");
        }
        if (this.topLevel.equals(node)) {
            this.topLevel = null;
            this.parallelAssignedVariables.clear();
            this.currentAssignedVariables.clear();
        }
    }

    private void assignVariables(AIdentifierExpression lhs) {
        if (this.modeStack.peekFirst() == SubstitutionMode.SEQUENTIAL) {
            this.currentAssignedVariables.add(SequenceSubstitutionsEliminator.identifierToStringList(lhs));
        } else if (this.modeStack.peekFirst() == SubstitutionMode.PARALLEL) {
            this.parallelAssignedVariables.add(SequenceSubstitutionsEliminator.identifierToStringList(lhs));
        }
    }

    private static List<String> identifierToStringList(AIdentifierExpression identifier) {
        return identifier.getIdentifier().stream().map(Token::getText).collect(Collectors.toList());
    }

    public Set<Node> getPrimeNodes() {
        return this.primeNodes;
    }

    private static enum SubstitutionMode {
        PARALLEL,
        SEQUENTIAL;

    }
}

