/*
 * Decompiled with CFR 0.152.
 */
package de.tlc4b.analysis;

import de.be4.classicalb.core.parser.analysis.DepthFirstAdapter;
import de.be4.classicalb.core.parser.node.ACardExpression;
import de.be4.classicalb.core.parser.node.AEqualPredicate;
import de.be4.classicalb.core.parser.node.AExpressionDefinitionDefinition;
import de.be4.classicalb.core.parser.node.AIdentifierExpression;
import de.be4.classicalb.core.parser.node.AIntegerExpression;
import de.be4.classicalb.core.parser.node.AIntervalExpression;
import de.be4.classicalb.core.parser.node.AUnaryMinusExpression;
import de.be4.classicalb.core.parser.node.Node;
import de.tlc4b.TLC4BGlobals;
import de.tlc4b.analysis.MachineContext;
import de.tlc4b.exceptions.TranslationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class DefinitionsAnalyser
extends DepthFirstAdapter {
    private final MachineContext machineContext;
    private final Map<Node, Integer> deferredSetSize = new HashMap<Node, Integer>();

    public Integer getSize(Node node) {
        return this.deferredSetSize.get(node);
    }

    public DefinitionsAnalyser(MachineContext machineContext) {
        this.machineContext = machineContext;
        HashSet<Node> deferredSets = new HashSet<Node>(machineContext.getDeferredSets().values());
        this.findDefaultSizesInDefinitions();
        if (deferredSets.isEmpty()) {
            return;
        }
        for (String string : machineContext.getDeferredSets().keySet()) {
            Node node = machineContext.getDefinitions().get("scope_" + string);
            if (!(node instanceof AExpressionDefinitionDefinition)) continue;
            AExpressionDefinitionDefinition d = (AExpressionDefinitionDefinition)node;
            if (d.getRhs() instanceof AIntervalExpression) {
                AIntervalExpression interval = (AIntervalExpression)d.getRhs();
                int l_int = DefinitionsAnalyser.extractInteger(interval.getLeftBorder());
                int r_int = DefinitionsAnalyser.extractInteger(interval.getRightBorder());
                this.deferredSetSize.put(machineContext.getDeferredSets().get(string), r_int - l_int + 1);
                continue;
            }
            if (!(d.getRhs() instanceof AIntegerExpression)) continue;
            this.deferredSetSize.put(machineContext.getDeferredSets().get(string), DefinitionsAnalyser.extractInteger(d.getRhs()));
        }
    }

    private void findDefaultSizesInDefinitions() {
        Node node = this.machineContext.getDefinitions().get("SET_PREF_DEFAULT_SETSIZE");
        if (null != node) {
            try {
                TLC4BGlobals.setDEFERRED_SET_SIZE(DefinitionsAnalyser.extractInteger(((AExpressionDefinitionDefinition)node).getRhs()));
            }
            catch (ClassCastException e) {
                throw new TranslationException("Unable to determine the default set size from definition SET_PREF_DEFAULT_SETSIZE: " + node.getEndPos(), e);
            }
        }
        if (null != (node = this.machineContext.getDefinitions().get("SET_PREF_MAXINT"))) {
            try {
                TLC4BGlobals.setMAX_INT(DefinitionsAnalyser.extractInteger(((AExpressionDefinitionDefinition)node).getRhs()));
            }
            catch (ClassCastException e) {
                throw new TranslationException("Unable to determine MAXINT from definition SET_PREF_MAXINT: " + node.getEndPos(), e);
            }
        }
        if (null != (node = this.machineContext.getDefinitions().get("SET_PREF_MININT"))) {
            try {
                AExpressionDefinitionDefinition d = (AExpressionDefinitionDefinition)node;
                int value = d.getRhs() instanceof AUnaryMinusExpression ? -DefinitionsAnalyser.extractInteger(((AUnaryMinusExpression)d.getRhs()).getExpression()) : DefinitionsAnalyser.extractInteger(d.getRhs());
                TLC4BGlobals.setMIN_INT(value);
            }
            catch (ClassCastException e) {
                throw new TranslationException("Unable to determine the MININT from definition SET_PREF_MININT: " + node.getEndPos(), e);
            }
        }
    }

    @Override
    public void caseAIdentifierExpression(AIdentifierExpression node) {
        Node ref_node = this.machineContext.getReferences().get(node);
        if (this.deferredSetSize.containsKey(ref_node)) {
            try {
                ACardExpression cardNode = (ACardExpression)node.parent();
                AEqualPredicate equalsNode = (AEqualPredicate)cardNode.parent();
                this.deferredSetSize.put(ref_node, DefinitionsAnalyser.extractInteger(equalsNode.getLeft() == cardNode ? equalsNode.getRight() : cardNode));
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }

    private static int extractInteger(Node node) {
        return Integer.parseInt(((AIntegerExpression)node).getLiteral().getText());
    }
}

