/*
 * Decompiled with CFR 0.152.
 */
package de.tlc4b;

import de.be4.classicalb.core.parser.BParser;
import de.be4.classicalb.core.parser.analysis.prolog.RecursiveMachineLoader;
import de.be4.classicalb.core.parser.exceptions.BCompoundException;
import de.be4.classicalb.core.parser.node.APredicateParseUnit;
import de.be4.classicalb.core.parser.node.PPredicate;
import de.be4.classicalb.core.parser.node.Start;
import de.tlc4b.TLC4BGlobals;
import de.tlc4b.analysis.ConstantsEliminator;
import de.tlc4b.analysis.ConstantsEvaluator;
import de.tlc4b.analysis.DefinitionsAnalyser;
import de.tlc4b.analysis.MachineContext;
import de.tlc4b.analysis.PrecedenceCollector;
import de.tlc4b.analysis.PrimedNodesMarker;
import de.tlc4b.analysis.Renamer;
import de.tlc4b.analysis.Typechecker;
import de.tlc4b.analysis.UnsupportedConstructsFinder;
import de.tlc4b.analysis.UsedStandardModules;
import de.tlc4b.analysis.transformation.DefinitionsEliminator;
import de.tlc4b.analysis.transformation.SeesEliminator;
import de.tlc4b.analysis.transformation.SequenceSubstitutionsEliminator;
import de.tlc4b.analysis.transformation.SetComprehensionOptimizer;
import de.tlc4b.analysis.typerestriction.TypeRestrictor;
import de.tlc4b.analysis.unchangedvariables.InvariantPreservationAnalysis;
import de.tlc4b.analysis.unchangedvariables.UnchangedVariablesFinder;
import de.tlc4b.prettyprint.TLAPrinter;
import de.tlc4b.tla.Generator;
import de.tlc4b.tlc.TLCOutputInfo;
import java.io.File;
import java.util.Map;
import java.util.Set;

public class Translator {
    private String machineString;
    private final Start start;
    private Map<String, Start> parsedMachines;
    private String moduleString;
    private String configString;
    private String machineName;
    private String ltlFormula;
    private PPredicate constantsSetup;
    private Set<String> standardModulesToBeCreated;
    private TLCOutputInfo tlcOutputInfo;

    public Translator(String machineString) throws BCompoundException {
        this.machineString = machineString;
        BParser parser = new BParser("Testing");
        this.start = parser.parseMachine(machineString);
    }

    public Translator(String machineString, String ltlFormula) throws BCompoundException {
        this.machineString = machineString;
        this.ltlFormula = ltlFormula;
        BParser parser = new BParser("Testing");
        this.start = parser.parseMachine(machineString);
    }

    public Translator(String machineName, File machineFile, String ltlFormula, String constantSetup) throws BCompoundException {
        this.machineName = machineName;
        this.ltlFormula = ltlFormula;
        BParser parser = new BParser(machineName);
        this.start = parser.parseFile(machineFile);
        RecursiveMachineLoader rml = new RecursiveMachineLoader(machineFile.getParent(), parser.getContentProvider());
        rml.loadAllMachines(machineFile, this.start, parser.getDefinitions());
        this.parsedMachines = rml.getParsedMachines();
        if (constantSetup != null) {
            Start start2;
            BParser con = new BParser();
            try {
                start2 = con.parseFormula(constantSetup);
            }
            catch (BCompoundException e) {
                System.err.println("An error occurred while parsing the constants setup predicate.");
                throw e;
            }
            APredicateParseUnit parseUnit = (APredicateParseUnit)start2.getPParseUnit();
            this.constantsSetup = parseUnit.getPredicate();
        }
    }

    public void translate() {
        this.start.apply(new UnsupportedConstructsFinder());
        SeesEliminator.eliminateSeesClauses(this.start, this.parsedMachines);
        DefinitionsEliminator.eliminateDefinitions(this.start);
        SequenceSubstitutionsEliminator sequenceSubstitutionsEliminator = new SequenceSubstitutionsEliminator(this.start);
        SetComprehensionOptimizer.optimizeSetComprehensions(this.start);
        MachineContext machineContext = new MachineContext(this.machineName, this.start);
        if (this.ltlFormula != null) {
            machineContext.addLTLFormula(this.ltlFormula);
        }
        if (this.constantsSetup != null) {
            machineContext.setConstantSetupPredicate(this.constantsSetup);
        }
        machineContext.analyseMachine();
        this.machineName = machineContext.getMachineName();
        if (!machineContext.machineContainsOperations()) {
            TLC4BGlobals.setPrintCoverage(false);
        }
        Typechecker typechecker = new Typechecker(machineContext);
        UnchangedVariablesFinder unchangedVariablesFinder = new UnchangedVariablesFinder(machineContext);
        ConstantsEliminator constantsEliminator = new ConstantsEliminator(machineContext);
        constantsEliminator.start();
        ConstantsEvaluator constantsEvaluator = new ConstantsEvaluator(machineContext);
        InvariantPreservationAnalysis invariantPreservationAnalysis = new InvariantPreservationAnalysis(machineContext, constantsEvaluator.getInvariantList(), unchangedVariablesFinder);
        TypeRestrictor typeRestrictor = new TypeRestrictor(this.start, machineContext, typechecker, constantsEvaluator);
        PrecedenceCollector precedenceCollector = new PrecedenceCollector(this.start, typechecker, machineContext, typeRestrictor);
        DefinitionsAnalyser deferredSetSizeCalculator = new DefinitionsAnalyser(machineContext);
        Generator generator = new Generator(machineContext, typeRestrictor, constantsEvaluator, deferredSetSizeCalculator, typechecker);
        generator.generate();
        UsedStandardModules usedModules = new UsedStandardModules(this.start, typechecker, typeRestrictor, generator.getTlaModule());
        this.standardModulesToBeCreated = usedModules.getStandardModulesToBeCreated();
        PrimedNodesMarker primedNodesMarker = new PrimedNodesMarker(generator.getTlaModule().getOperations(), machineContext, sequenceSubstitutionsEliminator.getPrimeNodes());
        primedNodesMarker.start();
        Renamer renamer = new Renamer(machineContext);
        TLAPrinter printer = new TLAPrinter(machineContext, typechecker, unchangedVariablesFinder, precedenceCollector, usedModules, typeRestrictor, generator.getTlaModule(), generator.getConfigFile(), primedNodesMarker, renamer, invariantPreservationAnalysis);
        printer.start();
        this.moduleString = printer.getStringbuilder().toString();
        this.configString = printer.getConfigString().toString();
        this.tlcOutputInfo = new TLCOutputInfo(machineContext, renamer, typechecker, generator.getTlaModule(), generator.getConfigFile());
    }

    public String getMachineString() {
        return this.machineString;
    }

    public String getModuleString() {
        return this.moduleString;
    }

    public String getConfigString() {
        return this.configString;
    }

    public Start getStart() {
        return this.start;
    }

    public String getMachineName() {
        return this.machineName;
    }

    public TLCOutputInfo getTLCOutputInfo() {
        return this.tlcOutputInfo;
    }

    public Set<String> getStandardModuleToBeCreated() {
        return this.standardModulesToBeCreated;
    }
}

