/*
 * Decompiled with CFR 0.152.
 */
package de.prob.prolog.output;

import de.prob.prolog.output.IPrologTermOutput;
import de.prob.prolog.output.ModifiableByteBuffer;
import de.prob.prolog.term.PrologTerm;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public final class FastSwiTermOutput
implements IPrologTermOutput {
    private static final int TAG_BITS = 7;
    private static final int SIGN_BITS = 1;
    private static final int PL_REC_VERSION = 3;
    private static final int REC_VSHIFT = 5;
    private static final int REC_32 = 1;
    private static final int REC_64 = 2;
    private static final int REC_INT = 4;
    private static final int REC_ATOM = 8;
    private static final int REC_GROUND = 16;
    private static final int PL_TYPE_VARIABLE = 1;
    private static final int PL_TYPE_TAGGED_INTEGER = 4;
    private static final int PL_TYPE_CONS = 8;
    private static final int PL_TYPE_NIL = 9;
    private static final int PL_TYPE_EXT_ATOM = 11;
    private static final int PL_TYPE_EXT_WATOM = 12;
    private static final int PL_TYPE_EXT_COMPOUND = 13;
    private static final int PL_TYPE_EXT_FLOAT = 14;
    private final OutputStream out;
    private final Map<String, Integer> varCache;
    private final Deque<TermContext> termStack;
    private final ModifiableByteBuffer buffer;
    private boolean topLevel;
    private int stackSize;
    private int wordBytes;
    private ByteOrder endianness;
    private boolean windows;
    private boolean allowWAtom;
    private Charset cachedWAtomCharset;

    public FastSwiTermOutput(OutputStream out) {
        this.out = out;
        this.varCache = new HashMap<String, Integer>();
        this.termStack = new ArrayDeque<TermContext>();
        this.buffer = new ModifiableByteBuffer();
        this.topLevel = true;
        this.stackSize = 0;
        this.wordBytes = FastSwiTermOutput.is64Bit() ? 8 : 4;
        this.endianness = ByteOrder.nativeOrder();
        this.windows = System.getProperty("os.name", "").toLowerCase(Locale.ROOT).contains("windows");
        this.allowWAtom = true;
        this.cachedWAtomCharset = null;
    }

    public FastSwiTermOutput withWAtomSupport() {
        this.allowWAtom = true;
        this.cachedWAtomCharset = null;
        return this;
    }

    public FastSwiTermOutput withoutWAtomSupport() {
        this.allowWAtom = false;
        this.cachedWAtomCharset = null;
        return this;
    }

    public FastSwiTermOutput withWAtomCharset(Charset charset) {
        this.cachedWAtomCharset = charset;
        return this;
    }

    public FastSwiTermOutput withTarget64bit() {
        this.wordBytes = 8;
        this.cachedWAtomCharset = null;
        return this;
    }

    public FastSwiTermOutput withTarget32bit() {
        this.wordBytes = 4;
        this.cachedWAtomCharset = null;
        return this;
    }

    public FastSwiTermOutput withTargetBigEndian() {
        this.endianness = ByteOrder.BIG_ENDIAN;
        this.cachedWAtomCharset = null;
        return this;
    }

    public FastSwiTermOutput withTargetLittleEndian() {
        this.endianness = ByteOrder.LITTLE_ENDIAN;
        this.cachedWAtomCharset = null;
        return this;
    }

    public FastSwiTermOutput withTargetWindows() {
        this.windows = true;
        return this;
    }

    public FastSwiTermOutput withTargetNoWindows() {
        this.windows = false;
        return this;
    }

    private void handleTerm() {
        this.topLevel = false;
        TermContext ctx = this.termStack.peek();
        if (ctx instanceof ListContext) {
            this.buffer.write(8);
            this.stackSize += 3;
        } else if (ctx instanceof CompoundContext) {
            CompoundContext c = (CompoundContext)ctx;
            if (c.arity() == 0) {
                this.buffer.write(13);
                c.setArityPos(this.buffer.size());
                this.buffer.write(0);
                try {
                    this.writeString(this.buffer, c.functor());
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            c.increaseArity();
        }
    }

    @Override
    public IPrologTermOutput openTerm(String functor, boolean ignoreIndentation) {
        if (!this.topLevel || !this.termStack.isEmpty()) {
            this.handleTerm();
        }
        this.termStack.push(new CompoundContext(functor));
        return this;
    }

    @Override
    public IPrologTermOutput closeTerm() {
        CompoundContext ctx = (CompoundContext)this.termStack.pop();
        int arity = ctx.arity();
        if (arity < 0) {
            throw new IllegalArgumentException("invalid arity for compound term: " + arity);
        }
        if (arity == 0) {
            this.writeAtom(ctx.functor(), false);
        } else {
            if ((arity & 0xFFFFFF80) == 0) {
                this.buffer.set(ctx.arityPos(), arity);
            } else {
                int maxZips = 5;
                int actualZips = maxZips - Integer.numberOfLeadingZeros(arity) / 7;
                this.buffer.shiftRight(ctx.arityPos() + 1, actualZips - 1);
                int oldSize = this.buffer.size();
                try {
                    this.buffer.setSize(ctx.arityPos());
                    FastSwiTermOutput.writeSize(this.buffer, arity);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                finally {
                    this.buffer.setSize(oldSize);
                }
            }
            this.stackSize += 1 + arity;
        }
        return this;
    }

    @Override
    public IPrologTermOutput printAtom(String content) {
        this.writeAtom(content, true);
        return this;
    }

    @Override
    public IPrologTermOutput printString(String content) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IPrologTermOutput printNumber(long number) {
        if (this.topLevel && this.termStack.isEmpty()) {
            this.topLevel = false;
            try {
                this.out.write(this.REC_HDR() | 4 | 0x10);
                FastSwiTermOutput.writeInt64(this.out, number);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        } else {
            long MAX_TAGGED_INT = (1L << this.wordBytes * 8 - 7 - 1) - 1L;
            long MIN_TAGGED_INT = -(1L << this.wordBytes * 8 - 7 - 1);
            this.handleTerm();
            if (MIN_TAGGED_INT <= number && number <= MAX_TAGGED_INT) {
                this.buffer.write(4);
                try {
                    FastSwiTermOutput.writeInt64(this.buffer, number);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            } else {
                throw new UnsupportedOperationException("int out of range (" + number + ")");
            }
        }
        return this;
    }

    @Override
    public IPrologTermOutput printNumber(BigInteger number) {
        try {
            return this.printNumber(number.longValueExact());
        }
        catch (ArithmeticException arithmeticException) {
            throw new UnsupportedOperationException("int out of range (" + number + ")");
        }
    }

    @Override
    public IPrologTermOutput printNumber(double number) {
        int WORDS_PER_DOUBLE = (8 + this.wordBytes - 1) / this.wordBytes;
        this.handleTerm();
        this.buffer.write(14);
        ByteBuffer ieee754LE = ByteBuffer.allocate(8);
        ieee754LE.order(ByteOrder.LITTLE_ENDIAN);
        ieee754LE.putDouble(number);
        ieee754LE.flip();
        int len = ieee754LE.remaining();
        assert (len == 8);
        this.buffer.write(ieee754LE.array(), ieee754LE.arrayOffset(), len);
        this.stackSize += WORDS_PER_DOUBLE + 2;
        return this;
    }

    @Override
    public IPrologTermOutput openList() {
        if (!this.topLevel || !this.termStack.isEmpty()) {
            this.handleTerm();
        }
        this.termStack.push(ListContext.INSTANCE);
        return this;
    }

    @Override
    public IPrologTermOutput closeList() {
        ListContext _ctx = (ListContext)this.termStack.pop();
        if (this.topLevel && this.termStack.isEmpty()) {
            this.topLevel = false;
            try {
                this.out.write(this.REC_HDR() | 8 | 0x10);
                this.out.write(9);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        } else {
            this.buffer.write(9);
        }
        return this;
    }

    @Override
    public IPrologTermOutput tailSeparator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IPrologTermOutput printVariable(String var) {
        this.handleTerm();
        this.buffer.write(1);
        int index = this.varCache.computeIfAbsent(var, k -> this.varCache.size());
        try {
            FastSwiTermOutput.writeSize(this.buffer, index);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return this;
    }

    @Override
    public IPrologTermOutput printTerm(PrologTerm term) {
        term.toTermOutput(this);
        return this;
    }

    @Override
    public IPrologTermOutput flush() {
        try {
            this.out.flush();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return this;
    }

    @Override
    public IPrologTermOutput fullstop() {
        if (!this.termStack.isEmpty()) {
            throw new IllegalStateException(this.termStack.size() + " unclosed term(s) or list(s)");
        }
        if (!this.topLevel && this.buffer.size() == 0) {
            this.flush();
            this.reset();
            return this;
        }
        int tag = this.REC_HDR();
        if (this.varCache.isEmpty()) {
            tag |= 0x10;
        }
        try {
            this.out.write(tag);
            FastSwiTermOutput.writeSize(this.out, this.buffer.size());
            FastSwiTermOutput.writeSize(this.out, this.stackSize);
            if (!this.varCache.isEmpty()) {
                FastSwiTermOutput.writeSize(this.out, this.varCache.size());
            }
            this.out.write(this.buffer.bytes(), 0, this.buffer.size());
            this.out.flush();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.reset();
        return this;
    }

    public void reset() {
        this.varCache.clear();
        this.buffer.reset();
        this.topLevel = true;
        this.stackSize = 0;
    }

    private void writeAtom(String atom, boolean callHandleTerm) {
        if (this.topLevel && this.termStack.isEmpty()) {
            this.topLevel = false;
            try {
                this.out.write(this.REC_HDR() | 8 | 0x10);
                this.writeString(this.out, atom);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        if (callHandleTerm) {
            this.handleTerm();
        }
        try {
            this.writeString(this.buffer, atom);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void writeString(OutputStream os, String atom) throws IOException {
        CharsetEncoder extendedAsciiEncoder = StandardCharsets.ISO_8859_1.newEncoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
        try {
            ByteBuffer result = extendedAsciiEncoder.encode(CharBuffer.wrap(atom));
            os.write(11);
            int len = result.remaining();
            FastSwiTermOutput.writeSize(os, len);
            os.write(result.array(), result.arrayOffset(), len);
        }
        catch (CharacterCodingException e) {
            if (this.allowWAtom) {
                os.write(12);
                byte[] bytes = atom.getBytes(this.wcharCharset());
                FastSwiTermOutput.writeSize(os, bytes.length);
                os.write(bytes);
            }
            throw new IllegalArgumentException("atom contains non-latin characters", e);
        }
    }

    private static void writeSize(OutputStream os, int val) throws IOException {
        if ((val & 0xFFFFFF80) == 0) {
            os.write(val);
        } else {
            boolean leading = true;
            for (int zips = 4; zips >= 0; --zips) {
                int d = val >>> zips * 7 & 0x7F;
                if (d == 0 && leading) continue;
                if (zips != 0) {
                    d |= 0x80;
                }
                os.write(d);
                leading = false;
            }
        }
    }

    private static void writeInt64(OutputStream os, long value) throws IOException {
        int bytes;
        if (value == 0L) {
            bytes = 1;
        } else if (value == Long.MIN_VALUE) {
            bytes = 8;
        } else {
            int msb = 63 - Long.numberOfLeadingZeros(Math.abs(value));
            bytes = (msb + 9) / 8;
        }
        os.write(bytes);
        while (--bytes >= 0) {
            int b = (int)(value >> bytes * 8) & 0xFF;
            os.write(b);
        }
    }

    private Charset wcharCharset() {
        if (this.cachedWAtomCharset == null) {
            this.cachedWAtomCharset = this.windows ? StandardCharsets.UTF_16LE : (this.endianness == ByteOrder.BIG_ENDIAN ? Charset.forName("UTF-32BE") : Charset.forName("UTF-32LE"));
        }
        return this.cachedWAtomCharset;
    }

    private int REC_SZ() {
        if (this.wordBytes == 8) {
            return 2;
        }
        if (this.wordBytes == 4) {
            return 1;
        }
        throw new AssertionError();
    }

    private int REC_HDR() {
        return this.REC_SZ() | 0x60;
    }

    private static boolean is64Bit() {
        String bits = System.getProperty("sun.arch.data.model", System.getProperty("com.ibm.vm.bitmode", System.getProperty("os.arch", "")));
        return bits.contains("64");
    }

    private static final class CompoundContext
    extends TermContext {
        private final String functor;
        private int arityPos;
        private int arity;

        CompoundContext(String functor) {
            this.functor = functor;
            this.arity = 0;
        }

        String functor() {
            return this.functor;
        }

        int arityPos() {
            return this.arityPos;
        }

        void setArityPos(int arityPos) {
            this.arityPos = arityPos;
        }

        void increaseArity() {
            ++this.arity;
        }

        int arity() {
            return this.arity;
        }
    }

    private static final class ListContext
    extends TermContext {
        static final ListContext INSTANCE = new ListContext();

        private ListContext() {
        }
    }

    private static abstract class TermContext {
        private TermContext() {
        }
    }
}

