/*
 * Decompiled with CFR 0.152.
 */
package de.be4.classicalb.core.parser.exceptions;

import de.be4.classicalb.core.preparser.node.Token;
import java.util.Collections;
import java.util.List;

public class PreParseException
extends Exception {
    private final List<Token> tokens;
    private final int line;
    private final int pos;

    public PreParseException(List<Token> tokens, String message, Throwable cause) {
        super(message, cause);
        this.tokens = tokens;
        if (tokens.isEmpty()) {
            this.line = 0;
            this.pos = 0;
        } else {
            Token token = tokens.get(0);
            this.line = token.getLine();
            this.pos = token.getPos();
        }
    }

    public PreParseException(int line, int pos, String message, Throwable cause) {
        super(message, cause);
        this.tokens = Collections.emptyList();
        this.line = line;
        this.pos = pos;
    }

    public PreParseException(Token token, String message, Throwable cause) {
        this(Collections.singletonList(token), message, cause);
    }

    public PreParseException(String message, Throwable cause) {
        this(Collections.emptyList(), message, cause);
    }

    public PreParseException(List<Token> tokens, String message) {
        this(tokens, message, null);
    }

    public PreParseException(Token token, String message) {
        this(Collections.singletonList(token), message);
    }

    public PreParseException(int line, int pos, String message) {
        this(line, pos, message, null);
    }

    public PreParseException(String message) {
        this(Collections.emptyList(), message);
    }

    public List<Token> getTokensList() {
        return Collections.unmodifiableList(this.tokens);
    }

    public int getLine() {
        return this.line;
    }

    public int getPos() {
        return this.pos;
    }
}

