/*
 * Decompiled with CFR 0.152.
 */
package de.be4.classicalb.core.parser;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class FileSearchPathProvider
implements Iterable<File> {
    private final String fileName;
    private final ArrayList<String> searchPath = new ArrayList();

    public FileSearchPathProvider(String fileName) {
        this(".", fileName);
    }

    public FileSearchPathProvider(String prefix, String fileName) {
        this(prefix, fileName, Collections.emptyList());
    }

    public FileSearchPathProvider(String prefix, String fileName, List<String> paths) {
        this.fileName = fileName;
        this.searchPath.add(prefix);
        this.searchPath.addAll(paths);
        this.searchPath.addAll(this.getLibraryPath());
    }

    private List<String> getLibraryPath() {
        String stdlib = System.getProperty("prob.stdlib");
        if (stdlib != null) {
            return Arrays.asList(stdlib.split(File.pathSeparator));
        }
        return Collections.singletonList("." + File.separator + "stdlib");
    }

    @Override
    public Iterator<File> iterator() {
        File file = new File(this.fileName);
        if (file.isAbsolute()) {
            return Collections.singletonList(file).iterator();
        }
        return this.searchPath.stream().map(base -> new File((String)base, this.getFilename())).iterator();
    }

    public int size() {
        return this.searchPath.size();
    }

    public String getFilename() {
        return this.fileName;
    }

    public File resolve() throws IOException {
        for (File f : this) {
            if (!f.exists() || !f.isFile()) continue;
            return f.getCanonicalFile();
        }
        throw new FileNotFoundException("did not find: " + this.fileName);
    }
}

