/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.liveness;

import java.io.IOException;
import tlc2.output.MP;
import tlc2.tool.liveness.AbstractDiskGraph;
import tlc2.tool.liveness.GraphNode;
import tlc2.tool.liveness.NodePtrTable;
import tlc2.tool.liveness.OrderOfSolution;
import tlc2.util.LongVec;
import tlc2.util.MemIntQueue;
import tlc2.util.statistics.IBucketStatistics;

public class DiskGraph
extends AbstractDiskGraph {
    private NodePtrTable nodePtrTbl = new NodePtrTable(255);

    public DiskGraph(String metadir, int soln, IBucketStatistics graphStats) throws IOException {
        super(metadir, soln, graphStats);
    }

    @Override
    public final GraphNode getNode(long fp, int tidx) throws IOException {
        return this.getNode(fp);
    }

    public final GraphNode getNode(long stateFP) throws IOException {
        long ptr = this.nodePtrTbl.get(stateFP);
        if (ptr < 0L) {
            return new GraphNode(stateFP, -1);
        }
        if (this.gnodes == null) {
            return this.getNodeFromDisk(stateFP, -1, ptr);
        }
        return this.getNode(stateFP, -1, ptr);
    }

    @Override
    public final long getPtr(long fp, int tidx) {
        return this.getPtr(fp);
    }

    public final long getPtr(long fp) {
        return this.nodePtrTbl.get(fp);
    }

    @Override
    public void reset() throws IOException {
        this.nodePtrRAF.reset();
        this.nodeRAF.reset();
        this.nodePtrTbl = new NodePtrTable(255);
    }

    @Override
    protected void putNode(GraphNode node, long ptr) {
        this.nodePtrTbl.put(node.stateFP, ptr);
    }

    @Override
    protected boolean checkDuplicate(GraphNode node) {
        return this.nodePtrTbl.get(node.stateFP) != -1L;
    }

    @Override
    public long getLink(long state, int tidx) {
        return this.nodePtrTbl.get(state);
    }

    @Override
    public long putLink(long state, int tidx, long link) {
        assert (0x4000000000000000L <= link && link < Long.MAX_VALUE);
        int loc = this.nodePtrTbl.getLoc(state);
        long oldLink = this.nodePtrTbl.getByLoc(loc);
        if (!DiskGraph.isFilePointer(oldLink)) {
            return oldLink;
        }
        this.nodePtrTbl.putByLoc(state, link, loc);
        return -1L;
    }

    @Override
    public void setMaxLink(long state, int tidx) {
        this.nodePtrTbl.put(state, Long.MAX_VALUE);
    }

    @Override
    protected void makeNodePtrTbl(long ptr) throws IOException {
        this.nodePtrRAF.seek(0L);
        while (this.nodePtrRAF.getFilePointer() < ptr) {
            long fp = this.nodePtrRAF.readLong();
            this.nodePtrRAF.readInt();
            long loc = this.nodePtrRAF.readLongNat();
            this.nodePtrTbl.put(fp, loc);
        }
    }

    @Override
    public long size() {
        return this.nodePtrTbl.size();
    }

    public final String toString() {
        if (this.gnodes == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        try {
            long nodePtr = this.nodeRAF.getFilePointer();
            long nodePtrPtr = this.nodePtrRAF.getFilePointer();
            long len = this.nodePtrRAF.length();
            this.nodePtrRAF.seek(0L);
            while (this.nodePtrRAF.getFilePointer() < len) {
                long fp = this.nodePtrRAF.readLong();
                int tidx = this.nodePtrRAF.readInt();
                long loc = this.nodePtrRAF.readLongNat();
                sb.append(fp + " -> ");
                GraphNode gnode = this.getNode(fp, tidx, loc);
                int sz = gnode.succSize();
                for (int i = 0; i < sz; ++i) {
                    sb.append(gnode.getStateFP(i) + " ");
                }
                sb.append("\n");
            }
            this.nodeRAF.seek(nodePtr);
            this.nodePtrRAF.seek(nodePtrPtr);
        }
        catch (IOException e) {
            MP.printError(2129, e);
            System.exit(1);
        }
        return sb.toString();
    }

    @Override
    public final String toDotViz(OrderOfSolution oos) {
        int slen = oos.getCheckState().length;
        int alen = oos.getCheckAction().length;
        if (this.gnodes == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        try {
            sb.append("digraph DiskGraph {\n");
            sb.append("nodesep = 0.7\n");
            sb.append("rankdir=LR;\n");
            sb.append(this.toDotVizLegend(oos));
            sb.append("subgraph cluster_graph {\n");
            sb.append("color=\"white\";\n");
            long nodePtr = this.nodeRAF.getFilePointer();
            long nodePtrPtr = this.nodePtrRAF.getFilePointer();
            long len = this.nodePtrRAF.length();
            this.nodePtrRAF.seek(0L);
            while (this.nodePtrRAF.getFilePointer() < len) {
                long fp = this.nodePtrRAF.readLong();
                int tidx = this.nodePtrRAF.readInt();
                long loc = this.nodePtrRAF.readLongNat();
                GraphNode gnode = this.getNode(fp, tidx, loc);
                sb.append(gnode.toDotViz(this.isInitState(gnode), false, slen, alen));
            }
            sb.append("}}");
            this.nodeRAF.seek(nodePtr);
            this.nodePtrRAF.seek(nodePtrPtr);
        }
        catch (IOException e) {
            MP.printError(2129, e);
            System.exit(1);
        }
        return sb.toString();
    }

    @Override
    public final LongVec getPath(long state, int tidxIgnored) throws IOException {
        int numOfInits = this.initNodes.size();
        for (int i = 0; i < numOfInits; i += 2) {
            long state0 = this.initNodes.elementAt(i);
            if (state0 != state) continue;
            LongVec res = new LongVec(1);
            res.addElement(state0);
            return res;
        }
        this.makeNodePtrTbl();
        long offset = 0x4000000000000001L;
        MemIntQueue queue = new MemIntQueue(this.metadir, null);
        for (int i = 0; i < numOfInits; i += 2) {
            long state0 = this.initNodes.elementAt(i);
            long ptr = this.nodePtrTbl.get(state0);
            if (ptr == -1L) continue;
            queue.enqueueLong(state0);
            queue.enqueueLong(ptr);
            this.nodePtrTbl.put(state0, 0x4000000000000000L);
        }
        while (queue.hasElements()) {
            long curState = queue.dequeueLong();
            long curPtr = queue.dequeueLong();
            GraphNode curNode = this.getNode(curState, -1, curPtr);
            int succCnt = curNode.succSize();
            for (int i = 0; i < succCnt; ++i) {
                long nextPtr;
                long nextState = curNode.getStateFP(i);
                if (nextState == state) {
                    LongVec res = new LongVec(2);
                    res.addElement(nextState);
                    int curLoc = this.nodePtrTbl.getLoc(curState);
                    while (true) {
                        res.addElement(curState);
                        long ploc = this.nodePtrTbl.getByLoc(curLoc);
                        if (ploc == 0x4000000000000000L) break;
                        curLoc = (int)(ploc - 0x4000000000000001L);
                        curState = this.nodePtrTbl.getKeyByLoc(curLoc);
                    }
                    return res;
                }
                int nextLoc = this.nodePtrTbl.getLoc(nextState);
                if (nextLoc == -1 || !DiskGraph.isFilePointer(nextPtr = this.nodePtrTbl.getByLoc(nextLoc))) continue;
                queue.enqueueLong(nextState);
                queue.enqueueLong(nextPtr);
                int curLoc = this.nodePtrTbl.getLoc(curState);
                this.nodePtrTbl.putByLoc(nextState, 0x4000000000000001L + (long)curLoc, nextLoc);
            }
        }
        return super.getPath(state, tidxIgnored);
    }
}

