/*
 * Decompiled with CFR 0.152.
 */
package de.tlc4b.btypes;

import de.be4.classicalb.core.parser.node.ARecEntry;
import de.be4.classicalb.core.parser.node.AStructExpression;
import de.be4.classicalb.core.parser.node.PExpression;
import de.be4.classicalb.core.parser.node.PRecEntry;
import de.be4.classicalb.core.parser.node.TIdentifierLiteral;
import de.tlc4b.analysis.Typechecker;
import de.tlc4b.btypes.AbstractHasFollowers;
import de.tlc4b.btypes.BType;
import de.tlc4b.btypes.ITypechecker;
import de.tlc4b.btypes.SetType;
import de.tlc4b.btypes.UntypedType;
import de.tlc4b.exceptions.UnificationException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class StructType
extends AbstractHasFollowers {
    private final LinkedHashMap<String, BType> types = new LinkedHashMap();
    private boolean complete;

    public BType getType(String fieldName) {
        return this.types.get(fieldName);
    }

    public void setComplete() {
        this.complete = true;
    }

    public void add(String name, BType type) {
        if (type instanceof AbstractHasFollowers) {
            ((AbstractHasFollowers)type).addFollower(this);
        }
        this.types.put(name, type);
    }

    public String toString() {
        StringBuilder res = new StringBuilder();
        res.append("struct(");
        Iterator<Map.Entry<String, BType>> iterator = this.types.entrySet().iterator();
        if (!iterator.hasNext()) {
            res.append("...");
        }
        while (iterator.hasNext()) {
            Map.Entry<String, BType> next = iterator.next();
            String fieldName = next.getKey();
            res.append(fieldName).append(":").append(next.getValue());
            if (!iterator.hasNext()) continue;
            res.append(",");
        }
        res.append(")");
        return res.toString();
    }

    public void update(BType oldType, BType newType) {
        for (Map.Entry<String, BType> next : this.types.entrySet()) {
            String name = next.getKey();
            BType type = next.getValue();
            if (type != oldType) continue;
            this.types.put(name, newType);
            if (!(newType instanceof AbstractHasFollowers)) continue;
            ((AbstractHasFollowers)newType).addFollower(this);
        }
    }

    @Override
    public BType unify(BType other, ITypechecker typechecker) {
        if (!this.compare(other) || this.contains(other)) {
            throw new UnificationException();
        }
        if (other instanceof UntypedType) {
            ((UntypedType)other).setFollowersTo(this, typechecker);
            return this;
        }
        if (other instanceof StructType) {
            StructType s = (StructType)other;
            for (Map.Entry<String, BType> next : s.types.entrySet()) {
                String fieldName = next.getKey();
                BType sType = next.getValue();
                if (this.types.containsKey(fieldName)) {
                    BType res = this.types.get(fieldName).unify(sType, typechecker);
                    this.types.put(fieldName, res);
                    if (!(res instanceof AbstractHasFollowers)) continue;
                    ((AbstractHasFollowers)res).addFollower(this);
                    continue;
                }
                this.types.put(fieldName, sType);
                if (!(sType instanceof AbstractHasFollowers)) continue;
                AbstractHasFollowers f = (AbstractHasFollowers)sType;
                f.deleteFollower(other);
                f.addFollower(this);
            }
            ((StructType)other).setFollowersTo(this, typechecker);
            this.complete = this.complete || s.complete;
            return this;
        }
        throw new UnificationException();
    }

    @Override
    public boolean isUntyped() {
        for (BType bType : this.types.values()) {
            if (!bType.isUntyped()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean compare(BType other) {
        if (other instanceof UntypedType) {
            return true;
        }
        if (other instanceof StructType) {
            Object temp;
            StructType s = (StructType)other;
            Iterator<String> itr = this.types.keySet().iterator();
            HashSet<HashSet<String>> intersection = new HashSet<HashSet<String>>();
            while (itr.hasNext()) {
                temp = itr.next();
                if (!s.types.containsKey(temp)) continue;
                intersection.add((HashSet<String>)temp);
            }
            if (this.complete) {
                temp = new HashSet<String>(s.types.keySet());
                temp.removeAll(intersection);
                if (!temp.equals(new HashSet())) {
                    return false;
                }
            }
            if (s.complete) {
                temp = new HashSet<String>(this.types.keySet());
                temp.removeAll(intersection);
                if (!temp.equals(new HashSet())) {
                    return false;
                }
            }
            for (Map.Entry<String, BType> next : this.types.entrySet()) {
                String name = next.getKey();
                BType value = next.getValue();
                if (this.types.get(name).compare(value)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(BType other) {
        for (BType t : this.types.values()) {
            if (t.equals(other)) {
                return true;
            }
            if (!(t instanceof AbstractHasFollowers) || !((AbstractHasFollowers)t).contains(other)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsInfiniteType() {
        for (BType bType : this.types.values()) {
            if (!bType.containsInfiniteType()) continue;
            return true;
        }
        return false;
    }

    @Override
    public PExpression createASTNode(Typechecker typechecker) {
        ArrayList<PRecEntry> list = new ArrayList<PRecEntry>();
        Set<Map.Entry<String, BType>> entrySet = this.types.entrySet();
        for (Map.Entry<String, BType> entry : entrySet) {
            String name = entry.getKey();
            BType type = entry.getValue();
            ARecEntry recEntry = new ARecEntry(new TIdentifierLiteral(name), type.createASTNode(typechecker));
            list.add(recEntry);
        }
        AStructExpression node = new AStructExpression(list);
        typechecker.setType(node, new SetType(this));
        return node;
    }
}

