/*
 * Decompiled with CFR 0.152.
 */
package de.tlc4b.analysis.transformation;

import de.be4.classicalb.core.parser.Definitions;
import de.be4.classicalb.core.parser.IDefinitions;
import de.be4.classicalb.core.parser.analysis.DepthFirstAdapter;
import de.be4.classicalb.core.parser.analysis.checking.DefinitionCollector;
import de.be4.classicalb.core.parser.node.AAbstractMachineParseUnit;
import de.be4.classicalb.core.parser.node.ADefinitionExpression;
import de.be4.classicalb.core.parser.node.ADefinitionPredicate;
import de.be4.classicalb.core.parser.node.ADefinitionSubstitution;
import de.be4.classicalb.core.parser.node.ADefinitionsMachineClause;
import de.be4.classicalb.core.parser.node.AExpressionDefinitionDefinition;
import de.be4.classicalb.core.parser.node.AIdentifierExpression;
import de.be4.classicalb.core.parser.node.APredicateDefinitionDefinition;
import de.be4.classicalb.core.parser.node.ASubstitutionDefinitionDefinition;
import de.be4.classicalb.core.parser.node.PDefinition;
import de.be4.classicalb.core.parser.node.PExpression;
import de.be4.classicalb.core.parser.node.PMachineClause;
import de.be4.classicalb.core.parser.node.Start;
import de.be4.classicalb.core.parser.util.Utils;
import de.tlc4b.analysis.StandardModules;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class DefinitionsEliminator
extends DepthFirstAdapter {
    private final IDefinitions definitions = new Definitions();
    private final List<Map<String, PExpression>> contextStack = new ArrayList<Map<String, PExpression>>();

    public static void eliminateDefinitions(Start start) {
        start.apply(new DefinitionsEliminator(start));
    }

    private DefinitionsEliminator(Start node) {
        new DefinitionCollector(this.definitions).collectDefinitions(node);
    }

    @Override
    public void caseAAbstractMachineParseUnit(AAbstractMachineParseUnit node) {
        LinkedList<PMachineClause> copy = node.getMachineClauses();
        ADefinitionsMachineClause defClause = null;
        for (PMachineClause e : copy) {
            e.apply(this);
            if (!(e instanceof ADefinitionsMachineClause)) continue;
            defClause = (ADefinitionsMachineClause)e;
        }
        if (defClause != null && defClause.getDefinitions().isEmpty()) {
            defClause.replaceBy(null);
        }
    }

    @Override
    public void caseADefinitionsMachineClause(ADefinitionsMachineClause node) {
        String name;
        ArrayList<PDefinition> newDefinitionsList = new ArrayList<PDefinition>();
        ArrayList<PDefinition> oldDefinitionsList = new ArrayList<PDefinition>(node.getDefinitions());
        for (PDefinition e : oldDefinitionsList) {
            if (e instanceof AExpressionDefinitionDefinition && Utils.isProBSpecialDefinitionName(name = ((AExpressionDefinitionDefinition)e).getName().getText())) continue;
            e.apply(this);
        }
        for (PDefinition e : oldDefinitionsList) {
            if (e instanceof AExpressionDefinitionDefinition) {
                name = ((AExpressionDefinitionDefinition)e).getName().getText();
                if (!Utils.isProBSpecialDefinitionName(name) && !StandardModules.isKeywordInModuleExternalFunctions(name)) continue;
                newDefinitionsList.add(e);
                continue;
            }
            if (!(e instanceof APredicateDefinitionDefinition) || !Utils.isProBSpecialDefinitionName(name = ((APredicateDefinitionDefinition)e).getName().getText()) && !StandardModules.isKeywordInModuleExternalFunctions(name)) continue;
            newDefinitionsList.add(e);
        }
        for (PDefinition def : newDefinitionsList) {
            def.replaceBy(null);
        }
        node.setDefinitions(newDefinitionsList);
    }

    @Override
    public void caseADefinitionSubstitution(ADefinitionSubstitution node) {
        String name = node.getDefLiteral().getText();
        ASubstitutionDefinitionDefinition clone = (ASubstitutionDefinitionDefinition)this.definitions.getDefinition(name).clone();
        HashMap<String, PExpression> context = new HashMap<String, PExpression>();
        this.handleParameters(new LinkedList<PExpression>(node.getParameters()), clone.getParameters(), context);
        this.contextStack.add(context);
        clone.getRhs().apply(this);
        node.replaceBy(clone.getRhs());
        this.contextStack.remove(context);
    }

    @Override
    public void caseADefinitionExpression(ADefinitionExpression node) {
        String name = node.getDefLiteral().getText();
        if (this.checkExternalFunction(name, new ArrayList<PExpression>(node.getParameters()))) {
            return;
        }
        AExpressionDefinitionDefinition clone = (AExpressionDefinitionDefinition)this.definitions.getDefinition(name).clone();
        HashMap<String, PExpression> context = new HashMap<String, PExpression>();
        this.handleParameters(new LinkedList<PExpression>(node.getParameters()), clone.getParameters(), context);
        this.contextStack.add(context);
        clone.getRhs().apply(this);
        node.replaceBy(clone.getRhs());
        this.contextStack.remove(context);
    }

    @Override
    public void caseADefinitionPredicate(ADefinitionPredicate node) {
        String name = node.getDefLiteral().getText();
        if (this.checkExternalFunction(name, new ArrayList<PExpression>(node.getParameters()))) {
            return;
        }
        APredicateDefinitionDefinition clone = (APredicateDefinitionDefinition)this.definitions.getDefinition(name).clone();
        HashMap<String, PExpression> context = new HashMap<String, PExpression>();
        this.handleParameters(new LinkedList<PExpression>(node.getParameters()), clone.getParameters(), context);
        this.contextStack.add(context);
        clone.getRhs().apply(this);
        node.replaceBy(clone.getRhs());
        this.contextStack.remove(context);
    }

    @Override
    public void caseAIdentifierExpression(AIdentifierExpression node) {
        if (this.contextStack.isEmpty()) {
            return;
        }
        String name = Utils.getTIdentifierListAsString(node.getIdentifier());
        for (int i = this.contextStack.size() - 1; i >= 0; --i) {
            PExpression e = this.contextStack.get(i).get(name);
            if (e == null) continue;
            node.replaceBy(e.clone());
        }
    }

    private boolean checkExternalFunction(String name, List<PExpression> arguments) {
        if (StandardModules.isKeywordInModuleExternalFunctions(name)) {
            for (PExpression arg : arguments) {
                arg.apply(this);
            }
            return true;
        }
        return false;
    }

    private void handleParameters(List<PExpression> arguments, List<PExpression> cloneArguments, Map<String, PExpression> context) {
        for (int i = 0; i < cloneArguments.size(); ++i) {
            arguments.get(i).apply(this);
            AIdentifierExpression param = (AIdentifierExpression)cloneArguments.get(i);
            context.put(Utils.getTIdentifierListAsString(param.getIdentifier()), arguments.get(i));
        }
    }
}

