/*
 * Decompiled with CFR 0.152.
 */
package de.tlc4b.analysis;

import de.be4.classicalb.core.parser.analysis.DepthFirstAdapter;
import de.be4.classicalb.core.parser.node.AConvertBoolExpression;
import de.be4.classicalb.core.parser.node.ADomainExpression;
import de.be4.classicalb.core.parser.node.ALabelPredicate;
import de.be4.classicalb.core.parser.node.AMinusOrSetSubtractExpression;
import de.be4.classicalb.core.parser.node.AMultOrCartExpression;
import de.be4.classicalb.core.parser.node.Node;
import de.be4.classicalb.core.parser.node.Start;
import de.tlc4b.analysis.MachineContext;
import de.tlc4b.analysis.Precedence;
import de.tlc4b.analysis.Typechecker;
import de.tlc4b.analysis.typerestriction.TypeRestrictor;
import de.tlc4b.btypes.BType;
import de.tlc4b.btypes.FunctionType;
import de.tlc4b.btypes.IntegerType;
import java.util.HashSet;
import java.util.Hashtable;

public class PrecedenceCollector
extends DepthFirstAdapter {
    private static final Hashtable<String, Precedence> PRECEDENCES = new Hashtable();
    private final Hashtable<Node, Precedence> precedenceTable = new Hashtable();
    private final HashSet<Node> brackets = new HashSet();
    private final Typechecker typechecker;

    private static void put(String s, int from, int to, boolean leftAssociative) {
        PRECEDENCES.put(s, new Precedence(s, from, to, leftAssociative));
    }

    private Precedence getPrecedence(Node node) {
        String name = node.getClass().getSimpleName();
        return PRECEDENCES.get(name);
    }

    public HashSet<Node> getBrackets() {
        return this.brackets;
    }

    public PrecedenceCollector(Start start, Typechecker typeChecker, MachineContext machineContext, TypeRestrictor typeRestrictor) {
        this.typechecker = typeChecker;
        start.apply(this);
        if (machineContext.getConstantsSetup() != null) {
            machineContext.getConstantsSetup().apply(this);
        }
        for (Node node : typeRestrictor.getAllRestrictedNodes()) {
            node.apply(this);
        }
    }

    @Override
    public void caseStart(Start node) {
        this.inStart(node);
        node.getPParseUnit().apply(this);
        node.getEOF().apply(this);
        this.outStart(node);
    }

    @Override
    public void defaultIn(Node node) {
        Node parent = node.parent();
        Precedence p = this.getPrecedence(node);
        if (p != null) {
            Precedence parentPrecedence;
            this.precedenceTable.put(node, p);
            if (parent instanceof ALabelPredicate) {
                parent = parent.parent();
            }
            if (parent != null && Precedence.makeBrackets(p, parentPrecedence = this.precedenceTable.get(node.parent()))) {
                this.brackets.add(node);
            }
        }
    }

    @Override
    public void inAConvertBoolExpression(AConvertBoolExpression node) {
        Precedence parent = PRECEDENCES.get(node.parent().getClass().getSimpleName());
        if (parent != null) {
            this.precedenceTable.put(node, parent);
        }
    }

    @Override
    public void inAMultOrCartExpression(AMultOrCartExpression node) {
        BType type = this.typechecker.getType(node);
        Precedence p = type instanceof IntegerType ? new Precedence("AMultOrCartExpression", 13, 13, true) : new Precedence("AMultOrCartExpression", 8, 13, false);
        this.precedenceTable.put(node, p);
        Precedence parent = this.precedenceTable.get(node.parent());
        if (Precedence.makeBrackets(p, parent)) {
            this.brackets.add(node);
        }
    }

    @Override
    public void inADomainExpression(ADomainExpression node) {
        BType type = this.typechecker.getType(node.getExpression());
        if (type instanceof FunctionType) {
            Precedence p = new Precedence("ADomainExpression", 9, 9, false);
            this.precedenceTable.put(node, p);
            Precedence parent = this.precedenceTable.get(node.parent());
            if (Precedence.makeBrackets(p, parent)) {
                this.brackets.add(node);
            }
        }
    }

    @Override
    public void inAMinusOrSetSubtractExpression(AMinusOrSetSubtractExpression node) {
        BType type = this.typechecker.getType(node);
        Precedence p = type instanceof IntegerType ? new Precedence("AMinusOrSetSubtractExpression", 11, 11, true) : new Precedence("AMinusOrSetSubtractExpression", 8, 8, false);
        this.precedenceTable.put(node, p);
        Precedence parent = this.precedenceTable.get(node.parent());
        if (Precedence.makeBrackets(p, parent)) {
            this.brackets.add(node);
        }
    }

    static {
        PrecedenceCollector.put("AImplicationPredicate", 1, 1, false);
        PrecedenceCollector.put("AExistsPredicate", 1, 1, false);
        PrecedenceCollector.put("AForallPredicate", 1, 1, false);
        PrecedenceCollector.put("AEquivalencePredicate", 2, 2, false);
        PrecedenceCollector.put("ADisjunctPredicate", 3, 3, true);
        PrecedenceCollector.put("AConjunctPredicate", 3, 3, true);
        PrecedenceCollector.put("APreconditionSubstitution", 3, 3, true);
        PrecedenceCollector.put("AAssertionSubstitution", 3, 3, true);
        PrecedenceCollector.put("ASelectWhenSubstitution", 3, 3, true);
        PrecedenceCollector.put("AParallelSubstitution", 3, 3, true);
        PrecedenceCollector.put("ASelectSubstitution", 3, 3, true);
        PrecedenceCollector.put("AEqualPredicate", 5, 5, false);
        PrecedenceCollector.put("ALessPredicate", 5, 5, false);
        PrecedenceCollector.put("AGreaterPredicate", 5, 5, false);
        PrecedenceCollector.put("ALessEqualPredicate", 5, 5, false);
        PrecedenceCollector.put("AGreaterEqualPredicate", 5, 5, false);
        PrecedenceCollector.put("ANotEqualPredicate", 5, 5, false);
        PrecedenceCollector.put("APowerOfExpression", 14, 14, false);
        PrecedenceCollector.put("ASubsetPredicate", 5, 5, false);
        PrecedenceCollector.put("APowSubsetExpression", 8, 8, false);
        PrecedenceCollector.put("AUnionExpression", 8, 8, true);
        PrecedenceCollector.put("AIntersectionExpression", 8, 8, true);
        PrecedenceCollector.put("AUnionExpression", 8, 8, true);
        PrecedenceCollector.put("ASetSubtractionExpression", 8, 8, false);
        PrecedenceCollector.put("AIntervalExpression", 9, 9, true);
        PrecedenceCollector.put("ACartesianProductExpression", 8, 13, false);
        PrecedenceCollector.put("AAddExpression", 10, 10, true);
        PrecedenceCollector.put("AModuloExpression", 10, 11, true);
        PrecedenceCollector.put("AUnaryMinusExpression", 12, 12, false);
        PrecedenceCollector.put("AConcatExpression", 13, 13, true);
        PrecedenceCollector.put("ADivExpression", 13, 13, false);
        PrecedenceCollector.put("AFunctionExpression", 20, 20, false);
    }
}

