/*
 * Decompiled with CFR 0.152.
 */
package de.prob.prolog.term;

import de.prob.prolog.output.IPrologTermOutput;
import de.prob.prolog.term.IntegerLongPrologTerm;
import de.prob.prolog.term.IntegerPrologTerm;
import de.prob.prolog.term.PrologTerm;
import java.math.BigInteger;
import java.util.Objects;

public abstract class AIntegerPrologTerm
extends PrologTerm {
    public static final AIntegerPrologTerm ZERO;
    public static final AIntegerPrologTerm ONE;
    public static final AIntegerPrologTerm MINUS_ONE;
    public static final AIntegerPrologTerm TWO;
    public static final AIntegerPrologTerm TEN;
    private static final int MAX_CONSTANT = 16;
    private static final AIntegerPrologTerm[] POS_CACHE;
    private static final AIntegerPrologTerm[] NEG_CACHE;

    public static AIntegerPrologTerm create(long number) {
        if (number == 0L) {
            return ZERO;
        }
        if (number > 0L && number <= 16L) {
            return POS_CACHE[(int)number];
        }
        if (number < 0L && number >= -16L) {
            return NEG_CACHE[(int)(-number)];
        }
        return new IntegerLongPrologTerm(number);
    }

    public static AIntegerPrologTerm create(BigInteger number) {
        Objects.requireNonNull(number, "number");
        try {
            return AIntegerPrologTerm.create(number.longValueExact());
        }
        catch (ArithmeticException ignored) {
            return new IntegerPrologTerm(number);
        }
    }

    public static AIntegerPrologTerm create(String number) {
        return AIntegerPrologTerm.create(number, 10);
    }

    public static AIntegerPrologTerm create(String number, int radix) {
        Objects.requireNonNull(number, "number");
        try {
            return AIntegerPrologTerm.create(Long.parseLong(number, radix));
        }
        catch (NumberFormatException ignored) {
            return AIntegerPrologTerm.create(new BigInteger(number, radix));
        }
    }

    @Override
    public boolean isNumber() {
        return true;
    }

    @Override
    public boolean isInteger() {
        return true;
    }

    public abstract BigInteger getValue();

    @Override
    public String getFunctor() {
        return this.getValue().toString();
    }

    @Override
    public void toTermOutput(IPrologTermOutput pto) {
        pto.printNumber(this.getValue());
    }

    public int intValue() {
        return this.getValue().intValue();
    }

    public int intValueExact() {
        return this.getValue().intValueExact();
    }

    public long longValue() {
        return this.getValue().longValue();
    }

    public long longValueExact() {
        return this.getValue().longValueExact();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AIntegerPrologTerm)) {
            return false;
        }
        return this.getValue().equals(((AIntegerPrologTerm)other).getValue());
    }

    public int hashCode() {
        return this.getValue().hashCode();
    }

    static {
        POS_CACHE = new AIntegerPrologTerm[17];
        NEG_CACHE = new AIntegerPrologTerm[17];
        ZERO = new IntegerLongPrologTerm(0L);
        for (int i = 1; i <= 16; ++i) {
            AIntegerPrologTerm.POS_CACHE[i] = new IntegerLongPrologTerm(i);
            AIntegerPrologTerm.NEG_CACHE[i] = new IntegerLongPrologTerm(-i);
        }
        ONE = AIntegerPrologTerm.create(1L);
        MINUS_ONE = AIntegerPrologTerm.create(-1L);
        TWO = AIntegerPrologTerm.create(2L);
        TEN = AIntegerPrologTerm.create(10L);
    }
}

