/*
 * Decompiled with CFR 0.152.
 */
package de.be4.classicalb.core.parser.analysis.checking;

import de.be4.classicalb.core.parser.analysis.DepthFirstAdapter;
import de.be4.classicalb.core.parser.analysis.MachineClauseAdapter;
import de.be4.classicalb.core.parser.analysis.checking.SemanticCheck;
import de.be4.classicalb.core.parser.exceptions.CheckException;
import de.be4.classicalb.core.parser.node.AInitialisationMachineClause;
import de.be4.classicalb.core.parser.node.AInvalidOperationsClauseMachineClause;
import de.be4.classicalb.core.parser.node.AInvalidSubstitution;
import de.be4.classicalb.core.parser.node.ALocalOperationsMachineClause;
import de.be4.classicalb.core.parser.node.AMissingSemicolonOperation;
import de.be4.classicalb.core.parser.node.AOperationsMachineClause;
import de.be4.classicalb.core.parser.node.Start;
import java.util.ArrayList;
import java.util.List;

public class SemicolonCheck
implements SemanticCheck {
    private final List<CheckException> exceptions = new ArrayList<CheckException>();

    @Override
    public void runChecks(Start rootNode) {
        MissingSemicolonWalker adapter = new MissingSemicolonWalker();
        rootNode.apply(adapter);
    }

    @Override
    public List<CheckException> getCheckExceptions() {
        return this.exceptions;
    }

    private final class MissingSemicolonWalker
    extends MachineClauseAdapter {
        private MissingSemicolonWalker() {
        }

        @Override
        public void caseAInvalidOperationsClauseMachineClause(AInvalidOperationsClauseMachineClause node) {
            SemicolonCheck.this.exceptions.add(new CheckException("Invalid semicolon after last operation", node.getSemicolon()));
        }

        @Override
        public void caseAOperationsMachineClause(AOperationsMachineClause node) {
            node.apply(new OperationMissingSemicolonWalker());
        }

        @Override
        public void caseALocalOperationsMachineClause(ALocalOperationsMachineClause node) {
            node.apply(new OperationMissingSemicolonWalker());
        }

        @Override
        public void caseAInitialisationMachineClause(AInitialisationMachineClause node) {
            node.apply(new OperationMissingSemicolonWalker());
        }
    }

    private final class OperationMissingSemicolonWalker
    extends DepthFirstAdapter {
        private OperationMissingSemicolonWalker() {
        }

        @Override
        public void caseAMissingSemicolonOperation(AMissingSemicolonOperation node) {
            SemicolonCheck.this.exceptions.add(new CheckException("Semicolon missing between operations", node.getOperation()));
        }

        @Override
        public void caseAInvalidSubstitution(AInvalidSubstitution node) {
            SemicolonCheck.this.exceptions.add(new CheckException("Invalid semicolon after last substitution (before END)", node.getSemicolon()));
        }
    }
}

