/*
 * Decompiled with CFR 0.152.
 */
package de.be4.classicalb.core.parser.analysis.checking;

import de.be4.classicalb.core.parser.IDefinitions;
import de.be4.classicalb.core.parser.PreParser;
import de.be4.classicalb.core.parser.analysis.DepthFirstAdapter;
import de.be4.classicalb.core.parser.analysis.MachineClauseAdapter;
import de.be4.classicalb.core.parser.exceptions.CheckException;
import de.be4.classicalb.core.parser.node.ADefinitionsMachineClause;
import de.be4.classicalb.core.parser.node.AExpressionDefinitionDefinition;
import de.be4.classicalb.core.parser.node.APredicateDefinitionDefinition;
import de.be4.classicalb.core.parser.node.ASubstitutionDefinitionDefinition;
import de.be4.classicalb.core.parser.node.PDefinition;
import de.be4.classicalb.core.parser.node.Start;
import de.hhu.stups.sablecc.patch.SourcePosition;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class DefinitionCollector
extends MachineClauseAdapter {
    private final IDefinitions definitions;
    private final List<CheckException> exceptions = new ArrayList<CheckException>();

    public DefinitionCollector(IDefinitions definitions) {
        this.definitions = definitions;
    }

    public void collectDefinitions(Start rootNode) {
        rootNode.apply(this);
    }

    public List<CheckException> getExceptions() {
        return this.exceptions;
    }

    @Override
    public void caseADefinitionsMachineClause(ADefinitionsMachineClause definitions) {
        definitions.apply(new DepthFirstAdapter(){

            @Override
            public void caseAPredicateDefinitionDefinition(APredicateDefinitionDefinition node) {
                String defName = node.getName().getText();
                DefinitionCollector.this.addDefinition(node, IDefinitions.Type.Predicate, defName);
            }

            @Override
            public void caseASubstitutionDefinitionDefinition(ASubstitutionDefinitionDefinition node) {
                String defName = node.getName().getText();
                DefinitionCollector.this.addDefinition(node, IDefinitions.Type.Substitution, defName);
            }

            @Override
            public void caseAExpressionDefinitionDefinition(AExpressionDefinitionDefinition node) {
                String defName = node.getName().getText();
                IDefinitions.Type type = PreParser.getExpressionDefinitionRhsType(node.getRhs());
                DefinitionCollector.this.addDefinition(node, type, defName);
            }
        });
    }

    private void addDefinition(PDefinition def, IDefinitions.Type type, String name) {
        if (this.definitions.containsDefinition(name)) {
            PDefinition existingDefinition = this.definitions.getDefinition(name);
            File file = this.definitions.getFile(name);
            StringBuilder sb = new StringBuilder();
            sb.append("Duplicate definition: ").append(name).append(".\n");
            SourcePosition firstPos = existingDefinition.getStartPos();
            sb.append("(First appearance at ").append(this.getPosition(firstPos));
            if (file != null) {
                sb.append(" in file: ").append(file.getAbsolutePath());
            }
            sb.append(")\n");
            CheckException e = new CheckException(sb.toString(), def);
            this.exceptions.add(e);
        } else {
            this.definitions.addDefinition(def, type, name);
        }
    }

    private String getPosition(SourcePosition pos) {
        return "Line: " + pos.getLine() + ", Column: " + pos.getPos();
    }

    public IDefinitions getDefinitions() {
        return this.definitions;
    }
}

