/*
 * Decompiled with CFR 0.152.
 */
package de.be4.classicalb.core.parser;

import de.be4.classicalb.core.parser.BParser;
import de.be4.classicalb.core.parser.analysis.prolog.ASTProlog;
import de.be4.classicalb.core.parser.exceptions.BCompoundException;
import de.be4.classicalb.core.parser.node.Start;
import de.prob.parserbase.ProBParseException;
import de.prob.parserbase.ProBParserBase;
import de.prob.prolog.output.IPrologTermOutput;

public class ClassicalBParser
implements ProBParserBase {
    private static final String WRAPPER_EXPR = "bexpr";
    private static final String WRAPPER_PRED = "bpred";
    private static final String WRAPPER_TRANS = "bop";
    private final BParser bparser;

    public ClassicalBParser() {
        this(new BParser());
    }

    public ClassicalBParser(BParser bparser) {
        this.bparser = bparser;
    }

    @Override
    public void parseExpression(IPrologTermOutput pto, String expression, boolean wrap) throws ProBParseException {
        this.parseExpression(pto, expression, wrap, 1, 1);
    }

    @Override
    public void parseExpression(IPrologTermOutput pto, String expression, boolean wrap, int startLine, int startColumn) throws ProBParseException {
        this.bparser.setStartPosition(startLine, startColumn);
        try {
            Start ast = this.bparser.parseExpression(expression);
            this.printAst(pto, ast, wrap, WRAPPER_EXPR);
        }
        catch (BCompoundException e) {
            throw new ProBParseException(e.getFirstException().getMessage(), e);
        }
    }

    @Override
    public void parsePredicate(IPrologTermOutput pto, String predicate, boolean wrap) throws ProBParseException {
        this.parsePredicate(pto, predicate, wrap, 1, 1);
    }

    @Override
    public void parsePredicate(IPrologTermOutput pto, String predicate, boolean wrap, int startLine, int startColumn) throws ProBParseException {
        this.bparser.setStartPosition(startLine, startColumn);
        try {
            Start ast = this.bparser.parsePredicate(predicate);
            this.printAst(pto, ast, wrap, WRAPPER_PRED);
        }
        catch (BCompoundException e) {
            throw new ProBParseException(e.getFirstException().getMessage(), e);
        }
    }

    @Override
    public void parseTransitionPredicate(IPrologTermOutput pto, String transPredicate, boolean wrap) throws ProBParseException {
        this.parseTransitionPredicate(pto, transPredicate, wrap, 1, 1);
    }

    @Override
    public void parseTransitionPredicate(IPrologTermOutput pto, String trans2, boolean wrap, int startLine, int startColumn) throws ProBParseException {
        this.bparser.setStartPosition(startLine, startColumn);
        try {
            Start ast = this.bparser.parseTransition(trans2);
            this.printAst(pto, ast, wrap, WRAPPER_TRANS);
        }
        catch (BCompoundException e) {
            throw new ProBParseException(e.getFirstException().getMessage(), e);
        }
    }

    private void printAst(IPrologTermOutput pto, Start ast, boolean wrap, String wrapper) {
        if (wrap) {
            pto.openTerm(wrapper);
        }
        ASTProlog.printFormula(ast, pto);
        if (wrap) {
            pto.closeTerm();
        }
    }
}

